/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.telemetry.main.entity.Task;
import com.coraltele.telemetry.db.telemetry.main.repository.TaskRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.AgentTaskModel;
import com.coraltele.telemetry.model.GraphDataPointModel;
import com.coraltele.telemetry.model.GroupTaskModel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TaskManagementService {
    private static final Logger logger = LogManager.getLogger(TaskManagementService.class);
    @Autowired
    private TaskRepository taskRepository;

    public RequestResponse taskDetails() {
        RequestResponse returnValue = new RequestResponse();
        try {
            ArrayList lstValue = new ArrayList();
            List taskDetailsList = this.taskRepository.findAll();
            if (taskDetailsList.isEmpty()) {
                logger.info("Task list is empty");
                this.addEmptyTaskData(lstValue);
                returnValue.setMessageDetail("No tasks available.");
                returnValue.setData(lstValue);
            } else {
                Map taskCounts = this.calculateTaskCounts(taskDetailsList);
                this.addTaskData(lstValue, taskCounts);
                returnValue.setMessageDetail("Task details retrieved successfully.");
                returnValue.setData(lstValue);
            }
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessageDetail(e.getMessage());
            logger.error("Error while fetching task details: {}", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    private Map<String, Integer> calculateTaskCounts(List<Task> taskDetailsList) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        counts.put("totalTask", 0);
        counts.put("pendingTask", 0);
        counts.put("inProgress", 0);
        counts.put("pendingForApproval", 0);
        counts.put("completedTask", 0);
        counts.put("delayedTask", 0);
        Long currentTime = Instant.now().getEpochSecond();
        for (Task task : taskDetailsList) {
            counts.put("totalTask", (Integer)counts.get("totalTask") + 1);
            if ("New".equalsIgnoreCase(task.getCurrentStats())) {
                counts.put("pendingTask", (Integer)counts.get("pendingTask") + 1);
            } else if (!("New".equalsIgnoreCase(task.getCurrentStats()) || "pending for approval".equalsIgnoreCase(task.getCurrentStats()) || "Completed".equalsIgnoreCase(task.getCurrentStats()))) {
                counts.put("inProgress", (Integer)counts.get("inProgress") + 1);
            } else if ("pending for approval".equalsIgnoreCase(task.getCurrentStats())) {
                counts.put("pendingForApproval", (Integer)counts.get("pendingForApproval") + 1);
            } else if ("Completed".equalsIgnoreCase(task.getCurrentStats()) && Boolean.TRUE.equals(task.getIsTaskCompleted()) && task.getTaskCompletedOn() != null) {
                counts.put("completedTask", (Integer)counts.get("completedTask") + 1);
            }
            Long taskCompletionDate = task.getTaskCompletedOn();
            Long expectedDate = task.getExpectedCompletionDate();
            if ((taskCompletionDate == null || taskCompletionDate <= expectedDate) && (taskCompletionDate != null || expectedDate >= currentTime)) continue;
            counts.put("delayedTask", (Integer)counts.get("delayedTask") + 1);
        }
        return counts;
    }

    public RequestResponse getGroupTaskSummary() {
        RequestResponse returnValue = new RequestResponse();
        HashMap summaryMap = new HashMap();
        try {
            List tasks = this.taskRepository.findAll();
            this.groupTasksByGroup(tasks, summaryMap);
            ArrayList summaryList = new ArrayList(summaryMap.values());
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Task details retrieved successfully.");
            returnValue.setData(summaryList);
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessageDetail(e.getMessage());
            logger.error("Error while fetching group task details: {}", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    public RequestResponse getAgentTaskSummary() {
        RequestResponse returnValue = new RequestResponse();
        HashMap summaryMap = new HashMap();
        try {
            List tasks = this.taskRepository.findAll();
            this.groupTasksByAgent(tasks, summaryMap);
            ArrayList summaryList = new ArrayList(summaryMap.values());
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Agent task details retrieved successfully.");
            returnValue.setData(summaryList);
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessageDetail(e.getMessage());
            logger.error("Error while fetching agent task details: {}", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    private void addEmptyTaskData(List<GraphDataPointModel> lstValue) {
        lstValue.add(new GraphDataPointModel("Total Task", Double.valueOf(0.0), "cyan", null, "calendar_view_day", Boolean.valueOf(true)));
        lstValue.add(new GraphDataPointModel("Pending Task", Double.valueOf(0.0), "skyblue", null, "add_chart", Boolean.valueOf(true)));
        lstValue.add(new GraphDataPointModel("In Progress", Double.valueOf(0.0), "orange", null, "access_time", Boolean.valueOf(true)));
        lstValue.add(new GraphDataPointModel("Pending for Approval", Double.valueOf(0.0), "deeppink", null, "autorenew", Boolean.valueOf(true)));
        lstValue.add(new GraphDataPointModel("Completed Task", Double.valueOf(0.0), "green", null, "closed_caption_disabled", Boolean.valueOf(true)));
        lstValue.add(new GraphDataPointModel("Delayed", Double.valueOf(0.0), "red", null, "hourglass_empty", Boolean.valueOf(true)));
    }

    private void addTaskData(List<GraphDataPointModel> lstValue, Map<String, Integer> taskCounts) {
        lstValue.add(new GraphDataPointModel("Total Task", Double.valueOf(taskCounts.get("totalTask").doubleValue()), "cyan", null, "calendar_view_day", Boolean.valueOf(true)));
        lstValue.add(new GraphDataPointModel("Pending Task", Double.valueOf(taskCounts.get("pendingTask").doubleValue()), "skyblue", null, "add_chart", Boolean.valueOf(true)));
        lstValue.add(new GraphDataPointModel("In Progress", Double.valueOf(taskCounts.get("inProgress").doubleValue()), "orange", null, "access_time", Boolean.valueOf(true)));
        lstValue.add(new GraphDataPointModel("Pending for Approval", Double.valueOf(taskCounts.get("pendingForApproval").doubleValue()), "deeppink", null, "autorenew", Boolean.valueOf(true)));
        lstValue.add(new GraphDataPointModel("Completed Task", Double.valueOf(taskCounts.get("completedTask").doubleValue()), "green", null, "closed_caption_disabled", Boolean.valueOf(true)));
        lstValue.add(new GraphDataPointModel("Delayed", Double.valueOf(taskCounts.get("delayedTask").doubleValue()), "red", null, "hourglass_empty", Boolean.valueOf(true)));
    }

    private void groupTasksByGroup(List<Task> tasks, Map<String, GroupTaskModel> summaryMap) {
        Long currentTime = Instant.now().getEpochSecond();
        for (Task task : tasks) {
            String group = task.getAssignedGroup();
            if (!StringUtils.hasText((String)group)) continue;
            GroupTaskModel summary = summaryMap.computeIfAbsent(group, k -> {
                GroupTaskModel newSummary = new GroupTaskModel();
                newSummary.setAssignedGroup(group);
                newSummary.setTotalTask(0);
                newSummary.setPendingTask(0);
                newSummary.setDelayedTask(0);
                newSummary.setInProgress(0);
                newSummary.setPendingForApproval(0);
                newSummary.setCompletedTask(0);
                return newSummary;
            });
            summary.setTotalTask(summary.getTotalTask() + 1);
            if ("New".equalsIgnoreCase(task.getCurrentStats())) {
                summary.setPendingTask(summary.getPendingTask() + 1);
            } else if (!("New".equalsIgnoreCase(task.getCurrentStats()) || "pending for approval".equalsIgnoreCase(task.getCurrentStats()) || "Completed".equalsIgnoreCase(task.getCurrentStats()))) {
                summary.setInProgress(summary.getInProgress() + 1);
            } else if ("pending for approval".equalsIgnoreCase(task.getCurrentStats())) {
                summary.setPendingForApproval(summary.getPendingForApproval() + 1);
            } else if ("Completed".equalsIgnoreCase(task.getCurrentStats()) && Boolean.TRUE.equals(task.getIsTaskCompleted()) && task.getTaskCompletedOn() != null) {
                summary.setCompletedTask(summary.getCompletedTask() + 1);
            }
            Long taskCompletionDate = task.getTaskCompletedOn();
            Long expectedDate = task.getExpectedCompletionDate();
            if ((taskCompletionDate == null || taskCompletionDate <= expectedDate) && (taskCompletionDate != null || expectedDate >= currentTime)) continue;
            summary.setDelayedTask(summary.getDelayedTask() + 1);
        }
    }

    private void groupTasksByAgent(List<Task> tasks, Map<String, AgentTaskModel> summaryMap) {
        Long currentTime = Instant.now().getEpochSecond();
        for (Task task : tasks) {
            String user = task.getAssignedUser();
            if (!StringUtils.hasText((String)user)) continue;
            AgentTaskModel summary = summaryMap.computeIfAbsent(user, k -> {
                AgentTaskModel newSummary = new AgentTaskModel();
                newSummary.setAssignedUser(user);
                newSummary.setTotalTask(0);
                newSummary.setPendingTask(0);
                newSummary.setDelayedTask(0);
                newSummary.setInProgress(0);
                newSummary.setPendingForApproval(0);
                newSummary.setCompletedTask(0);
                return newSummary;
            });
            summary.setTotalTask(summary.getTotalTask() + 1);
            if ("New".equalsIgnoreCase(task.getCurrentStats())) {
                summary.setPendingTask(summary.getPendingTask() + 1);
            } else if (!("New".equalsIgnoreCase(task.getCurrentStats()) || "pending for approval".equalsIgnoreCase(task.getCurrentStats()) || "Completed".equalsIgnoreCase(task.getCurrentStats()))) {
                summary.setInProgress(summary.getInProgress() + 1);
            } else if ("pending for approval".equalsIgnoreCase(task.getCurrentStats())) {
                summary.setPendingForApproval(summary.getPendingForApproval() + 1);
            } else if ("Completed".equalsIgnoreCase(task.getCurrentStats()) && Boolean.TRUE.equals(task.getIsTaskCompleted()) && task.getTaskCompletedOn() != null) {
                summary.setCompletedTask(summary.getCompletedTask() + 1);
            }
            Long taskCompletionDate = task.getTaskCompletedOn();
            Long expectedDate = task.getExpectedCompletionDate();
            if ((taskCompletionDate == null || taskCompletionDate <= expectedDate) && (taskCompletionDate != null || expectedDate >= currentTime)) continue;
            summary.setDelayedTask(summary.getDelayedTask() + 1);
        }
    }
}

