/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.CategoryService;
import com.coraltele.telemetry.db.telemetry.main.repository.CategoryServiceRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.MonitorServiceRepository;
import com.coraltele.telemetry.model.discovery.ServiceStatus;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PortMonitoringThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(PortMonitoringThread.class);
    private Thread thread;
    public boolean isRunning = true;
    public Integer duration;
    public Integer portNumber;
    public String serviceCode;
    public String serviceName;
    private SCADAAssetRepository scadaAssetRepository;
    private SCADAAssetService scadaAssetService;
    private MonitorServiceRepository monitorServiceRepository;
    private CategoryServiceRepository categoryServiceRepository;

    public PortMonitoringThread(String serviceCode, Integer duration, Integer portNumber, CategoryServiceRepository categoryServiceRepository, SCADAAssetRepository scadaAssetRepository, MonitorServiceRepository monitorServiceRepository, SCADAAssetService scadaAssetService, String serviceName) {
        this.scadaAssetRepository = scadaAssetRepository;
        this.scadaAssetService = scadaAssetService;
        this.monitorServiceRepository = monitorServiceRepository;
        this.categoryServiceRepository = categoryServiceRepository;
        this.duration = duration;
        this.portNumber = portNumber;
        this.serviceCode = serviceCode;
        this.serviceName = serviceName;
        this.startService();
    }

    public void startService() {
        logger.info("Starting Discovery Thread");
        this.thread = new Thread((Runnable)this);
        this.thread.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.runExecutor();
                    Thread.sleep(this.duration * 1000);
                }
            }
            catch (InterruptedException e) {
                logger.error("Thread interrupted.", (Throwable)e);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Exception e) {
                logger.error("Error in creating thread MonitoringThread", (Throwable)e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runExecutor() {
        List monitorServices = this.monitorServiceRepository.findAll();
        ExecutorService executor = Executors.newFixedThreadPool(monitorServices.size());
        try {
            List categoryServices = this.categoryServiceRepository.findAll();
            for (CategoryService category : categoryServices) {
                if (!category.getServiceCode().equals(this.serviceCode)) continue;
                List scadaAssetData = this.scadaAssetRepository.findAllByCategory(category.getCategoryCode());
                for (SCADAAsset scadaData : scadaAssetData) {
                    Runnable task = () -> this.isPortListening(this.portNumber, scadaData.getIpAddress(), category.getSeverity(), category.getServiceCode(), category.getCategoryCode(), scadaData.getId(), this.serviceName);
                    executor.submit(task);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in executing tasks.", (Throwable)e);
        }
        finally {
            executor.shutdown();
        }
    }

    public void stopService() {
        this.isRunning = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    private void isPortListening(Integer portNumber, String ipAddress, Integer severity, String service, String category, Long assetId, String serviceName) {
        try {
            Socket socket = new Socket(ipAddress, (int)portNumber);
            ServiceStatus device = new ServiceStatus();
            device.setAssetId(assetId);
            device.setName(serviceName);
            device.setIpAddress(ipAddress);
            device.setCategory(category);
            device.setService(service);
            device.setStatus(Boolean.valueOf(true));
            device.setStatusDetail("Port is available");
            device.setSeverity(Integer.valueOf(0));
            device.setAlias(serviceName);
            device.setSlot(Integer.valueOf(0));
            this.scadaAssetService.updateServiceStatus(device);
            socket.close();
        }
        catch (Exception e) {
            ServiceStatus device = new ServiceStatus();
            device.setAssetId(assetId);
            device.setName(serviceName);
            device.setIpAddress(ipAddress);
            device.setCategory(category);
            device.setService(service);
            device.setStatus(Boolean.valueOf(false));
            device.setStatusDetail("Port is not available");
            device.setSeverity(severity);
            device.setAlias(serviceName);
            device.setSlot(Integer.valueOf(0));
            logger.error("Error in connecting socket", (Throwable)e);
            this.scadaAssetService.updateServiceStatus(device);
        }
    }
}

