/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.user.service;

import com.coraltele.telemetry.db.users.main.entity.Role;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.entity.UserRole;
import com.coraltele.telemetry.db.users.main.repository.RoleRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRoleRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.user.model.UserRoleModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserRoleService {
    private static final Logger logger = LogManager.getLogger(UserRoleService.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;

    public RequestResponse rolesAgainstUser(int userId) {
        Optional user = this.userRepository.findById(userId);
        ArrayList<UserRoleModel> returnData = new ArrayList<UserRoleModel>();
        RequestResponse returnValue = new RequestResponse();
        if (user.isPresent()) {
            List list = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRole : list) {
                UserRoleModel data = new UserRoleModel();
                data.setId(userRole.getId());
                data.setUserId(userRole.getUser().getId());
                data.setUser(userRole.getUser().getUsername());
                data.setRoleId(userRole.getRole().getId());
                data.setRole(userRole.getRole().getDescription());
                returnData.add(data);
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setData(returnData);
                logger.info(returnValue.getMessage());
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Data not found ");
            returnValue.setData(returnData);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse usersAgainstRole(int roleId) {
        Optional role = this.roleRepository.findById(roleId);
        ArrayList<UserRoleModel> returnData = new ArrayList<UserRoleModel>();
        RequestResponse returnValue = new RequestResponse();
        if (role.isPresent()) {
            List list = this.userRoleRepository.findByRole((Role)role.get());
            for (UserRole userRole : list) {
                UserRoleModel data = new UserRoleModel();
                data.setId(userRole.getId());
                data.setRoleId(userRole.getRole().getId());
                data.setRole(userRole.getRole().getDescription());
                data.setUserId(userRole.getUser().getId());
                data.setUser(userRole.getUser().getUsername());
                returnData.add(data);
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setData(returnData);
                logger.info(returnValue.getMessage());
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Data not found ");
            returnValue.setData(returnData);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public List<String> getRolesOfParticularUser(String username) {
        ArrayList<String> returnData = new ArrayList<String>();
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            List list = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRole : list) {
                returnData.add(userRole.getRole().getDescription());
            }
        }
        return returnData;
    }

    public List<Integer> roleIdOfParticularUser(String username) {
        ArrayList<Integer> returnValue = new ArrayList<Integer>();
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            List userRole = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRoleTraverse : userRole) {
                returnValue.add(userRoleTraverse.getRole().getId());
            }
        }
        return returnValue;
    }
}

