/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.messaging.service;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.ExtensionRegistrationsEventModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.stereotype.Service;

@Service
public class MultiChannelSubscriber
implements MessageListener {
    private static final Logger logger = LogManager.getLogger(MultiChannelSubscriber.class);

    public void onMessage(Message message, byte[] pattern) {
        String channel = new String(pattern);
        String messageBody = message.toString();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            ExtensionRegistrationsEventModel subscribedData = (ExtensionRegistrationsEventModel)objectMapper.readValue(messageBody, ExtensionRegistrationsEventModel.class);
            switch (channel) {
                case "imsv2register": {
                    logger.info("Processing event from channel imsv2register: {}", (Object)messageBody);
                    Constants.extensionDetailsService.createRegisteredExtension(subscribedData);
                    break;
                }
                case "imsv2deregister": {
                    logger.info("Processing event from channel imsv2deregister: {}", (Object)messageBody);
                    Constants.extensionDetailsService.updateRegisteredExtension(subscribedData);
                    break;
                }
                default: {
                    logger.warn("Received message from unknown channel: {}", (Object)channel);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while processing message from channel {}: {}", (Object)channel, (Object)messageBody, (Object)e);
        }
    }
}

