/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.telephony.main.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import lombok.Generated;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Subselect;

@Entity
@Immutable
@Subselect(value="SELECT\n    a1.call_direction,\n    a1.uuid,\n    a1.cid_num,\n    COALESCE(a2.name, a1.cid_name) AS cid_name,\n    a1.dest,\n    COALESCE(a3.name, a1.dest) AS dest_name,\n    a1.start_epoch,\n    a1.answer_epoch,\n    a1.is_answered,\n    CASE\n        WHEN a1.call_direction = 'OUT'\n            THEN a1.caller_ip_out\n        ELSE a1.caller_ip_local\n    END AS caller_ip,\n    CASE\n        WHEN a1.call_direction = 'OUT'\n            THEN a1.destination_ip_out\n        ELSE a1.destination_ip_local\n    END AS destination_ip,\n\n    CASE\n        WHEN a1.is_answered = TRUE THEN 'Talk'\n        WHEN a1.is_answered = FALSE AND a1.callstate = 'ACTIVE' THEN 'Message'\n        ELSE a1.callstate\n    END AS call_state\n\nFROM (\n    SELECT\n        a.uuid,\n        a.cid_num,\n        a.cid_name,\n        COALESCE(a.dest, b.dest) AS dest,\n        COALESCE(b.callstate, a.callstate) AS callstate,\n        a.application,\n        a.created_epoch AS start_epoch,\n        c.call_created_epoch AS answer_epoch,\n\n        CASE\n            WHEN c.call_created_epoch IS NULL THEN FALSE\n            ELSE TRUE\n        END AS is_answered,\n        split_part(a.name, '@', 2) AS caller_ip_out,\n        split_part(b.name, '@', 2) AS destination_ip_out,\n        a.ip_addr AS caller_ip_local,\n        b.ip_addr AS destination_ip_local,\n\n        CASE\n            WHEN LOWER(a.name) LIKE '%internal%'\n                 AND LOWER(COALESCE(b.name, '')) LIKE '%internal%' THEN 'INT'\n            WHEN LOWER(a.name) LIKE '%internal%'\n                 AND LOWER(COALESCE(b.name, '')) LIKE '%external%' THEN 'OUT'\n            WHEN LOWER(a.name) LIKE '%external%'\n                 AND LOWER(COALESCE(b.name, '')) LIKE '%internal%' THEN 'IN'\n            WHEN LOWER(a.name) LIKE '%external%'\n                 AND LOWER(COALESCE(b.name, '')) LIKE '%external%' THEN 'TT'\n            ELSE 'UNK'\n        END AS call_direction\n\n    FROM channels a\n    LEFT JOIN (\n        SELECT *\n        FROM channels\n        WHERE uuid <> call_uuid\n    ) b ON a.uuid = b.call_uuid\n    LEFT JOIN calls c ON a.call_uuid = c.call_uuid\n    WHERE COALESCE(a.call_uuid, a.uuid) = a.uuid\n) a1\n\nLEFT JOIN (\n    SELECT contactno AS extension, contactname AS name\n    FROM pbx.directorylist\n) a2 ON a1.cid_num = a2.extension\n\nLEFT JOIN (\n    SELECT contactno AS extension, contactname AS name\n    FROM pbx.directorylist\n) a3 ON a1.dest = a3.extension\n")
public class ActiveCall {
    @Column(name="call_direction")
    private String callDirection;
    @Id
    @Column(name="uuid")
    private String uuid;
    @Column(name="cid_num")
    private String cidNum;
    @Column(name="cid_name")
    private String cidName;
    @Column(name="dest")
    private String dest;
    @Column(name="dest_name")
    private String destName;
    @Column(name="start_epoch")
    private Long startEpoch;
    @Column(name="answer_epoch")
    private Long answerEpoch;
    @Column(name="is_answered")
    private Boolean isAnswered;
    @Column(name="call_state")
    private String callState;
    @Column(name="caller_ip")
    private String callerIp;
    @Column(name="destination_ip")
    private String destinationIp;

    @Generated
    public String getCallDirection() {
        return this.callDirection;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public String getCidNum() {
        return this.cidNum;
    }

    @Generated
    public String getCidName() {
        return this.cidName;
    }

    @Generated
    public String getDest() {
        return this.dest;
    }

    @Generated
    public String getDestName() {
        return this.destName;
    }

    @Generated
    public Long getStartEpoch() {
        return this.startEpoch;
    }

    @Generated
    public Long getAnswerEpoch() {
        return this.answerEpoch;
    }

    @Generated
    public Boolean getIsAnswered() {
        return this.isAnswered;
    }

    @Generated
    public String getCallState() {
        return this.callState;
    }

    @Generated
    public String getCallerIp() {
        return this.callerIp;
    }

    @Generated
    public String getDestinationIp() {
        return this.destinationIp;
    }

    @Generated
    public void setCallDirection(String callDirection) {
        this.callDirection = callDirection;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setCidNum(String cidNum) {
        this.cidNum = cidNum;
    }

    @Generated
    public void setCidName(String cidName) {
        this.cidName = cidName;
    }

    @Generated
    public void setDest(String dest) {
        this.dest = dest;
    }

    @Generated
    public void setDestName(String destName) {
        this.destName = destName;
    }

    @Generated
    public void setStartEpoch(Long startEpoch) {
        this.startEpoch = startEpoch;
    }

    @Generated
    public void setAnswerEpoch(Long answerEpoch) {
        this.answerEpoch = answerEpoch;
    }

    @Generated
    public void setIsAnswered(Boolean isAnswered) {
        this.isAnswered = isAnswered;
    }

    @Generated
    public void setCallState(String callState) {
        this.callState = callState;
    }

    @Generated
    public void setCallerIp(String callerIp) {
        this.callerIp = callerIp;
    }

    @Generated
    public void setDestinationIp(String destinationIp) {
        this.destinationIp = destinationIp;
    }

    @Generated
    public ActiveCall() {
    }

    @Generated
    public ActiveCall(String callDirection, String uuid, String cidNum, String cidName, String dest, String destName, Long startEpoch, Long answerEpoch, Boolean isAnswered, String callState, String callerIp, String destinationIp) {
        this.callDirection = callDirection;
        this.uuid = uuid;
        this.cidNum = cidNum;
        this.cidName = cidName;
        this.dest = dest;
        this.destName = destName;
        this.startEpoch = startEpoch;
        this.answerEpoch = answerEpoch;
        this.isAnswered = isAnswered;
        this.callState = callState;
        this.callerIp = callerIp;
        this.destinationIp = destinationIp;
    }
}

