/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.snmpRules.service;

import com.coraltele.telemetry.db.telemetry.main.entity.SnmpRules;
import com.coraltele.telemetry.db.telemetry.main.repository.SnmpRulesRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.main.snmpRules.model.SnmpRulesModel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SnmpRulesService {
    @Autowired
    private SnmpRulesRepository snmpRulesRepository;
    private static final Logger logger = LogManager.getLogger(SnmpRulesService.class);

    public RequestResponse getAll() {
        List listOfSnmpRules = (List)this.snmpRulesRepository.findAll();
        ArrayList<SnmpRulesModel> addValue = new ArrayList<SnmpRulesModel>();
        RequestResponse returnValue = new RequestResponse();
        for (SnmpRules snmpRules : listOfSnmpRules) {
            SnmpRulesModel data = new SnmpRulesModel();
            data.setAlias(snmpRules.getAlias());
            data.setCreatedBy(snmpRules.getCreatedBy());
            data.setCreatedOn(snmpRules.getCreatedOn());
            data.setId(snmpRules.getId());
            data.setFailureServiceCodeValue(snmpRules.getFailureServiceCodeValue());
            data.setFailureServiceCodeVariable(snmpRules.getFailureServiceCodeVariable());
            data.setRulePriority(snmpRules.getRulePriority());
            data.setServiceCode(snmpRules.getServiceCode());
            data.setSeverity(snmpRules.getSeverity());
            data.setSlot(snmpRules.getSlot());
            data.setSnmpVersion(snmpRules.getSnmpVersion());
            data.setStatusDetailFailure(snmpRules.getStatusDetailFailure());
            data.setStatusDetailSuccess(snmpRules.getStatusDetailSuccess());
            data.setSuccessServiceCodeValue(snmpRules.getSuccessServiceCodeValue());
            data.setSuccessServiceCodeVariable(snmpRules.getSuccessServiceCodeVariable());
            data.setSuccessValue(snmpRules.getSuccessValue());
            data.setSuccessVariable(snmpRules.getSuccessVariable());
            data.setTrapId(snmpRules.getTrapId());
            data.setTrapIdType(snmpRules.getTrapIdType());
            addValue.add(data);
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createData(SnmpRulesModel data, String userName) {
        logger.debug("snmp create new alert : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            SnmpRules snmpRules = new SnmpRules();
            snmpRules.setAlias(data.getAlias());
            snmpRules.setCreatedBy(userName);
            snmpRules.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            snmpRules.setFailureServiceCodeValue(data.getFailureServiceCodeValue());
            snmpRules.setFailureServiceCodeVariable(data.getFailureServiceCodeVariable());
            snmpRules.setId(data.getId());
            snmpRules.setRulePriority(data.getRulePriority());
            snmpRules.setServiceCode(data.getServiceCode());
            snmpRules.setSeverity(data.getSeverity());
            snmpRules.setSlot(data.getSlot());
            snmpRules.setSnmpVersion(data.getSnmpVersion());
            snmpRules.setStatusDetailFailure(data.getStatusDetailFailure());
            snmpRules.setStatusDetailSuccess(data.getStatusDetailSuccess());
            snmpRules.setSuccessServiceCodeValue(data.getSuccessServiceCodeValue());
            snmpRules.setSuccessValue(data.getSuccessValue());
            snmpRules.setSuccessServiceCodeVariable(data.getSuccessServiceCodeVariable());
            snmpRules.setSuccessVariable(data.getSuccessVariable());
            snmpRules.setTrapId(data.getTrapId());
            snmpRules.setTrapIdType(data.getTrapIdType());
            this.snmpRulesRepository.save((Object)snmpRules);
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("snmp created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setIssue(Constants.NodeStatus.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create snmp record");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Object)e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateById(SnmpRulesModel data, String userName) {
        logger.debug("Update snmp {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional snmpRulesById = this.snmpRulesRepository.findById((Object)data.getId());
        if (!snmpRulesById.isPresent()) {
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("snmpRules not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getAlias() != null) {
            ((SnmpRules)snmpRulesById.get()).setAlias(data.getAlias());
        }
        if (data.getCreatedBy() != null) {
            ((SnmpRules)snmpRulesById.get()).setCreatedBy(userName);
        }
        if (data.getCreatedOn() != null) {
            ((SnmpRules)snmpRulesById.get()).setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
        }
        if (data.getId() != null) {
            ((SnmpRules)snmpRulesById.get()).setId(data.getId());
        }
        if (data.getFailureServiceCodeValue() != null) {
            ((SnmpRules)snmpRulesById.get()).setFailureServiceCodeValue(data.getFailureServiceCodeValue());
        }
        if (data.getFailureServiceCodeVariable() != null) {
            ((SnmpRules)snmpRulesById.get()).setFailureServiceCodeVariable(data.getFailureServiceCodeVariable());
        }
        if (data.getRulePriority() != null) {
            ((SnmpRules)snmpRulesById.get()).setRulePriority(data.getRulePriority());
        }
        if (data.getFailureServiceCodeVariable() != null) {
            ((SnmpRules)snmpRulesById.get()).setFailureServiceCodeVariable(data.getFailureServiceCodeVariable());
        }
        if (data.getServiceCode() != null) {
            ((SnmpRules)snmpRulesById.get()).setServiceCode(data.getServiceCode());
        }
        if (data.getSeverity() != null) {
            ((SnmpRules)snmpRulesById.get()).setSeverity(data.getSeverity());
        }
        if (data.getSlot() != null) {
            ((SnmpRules)snmpRulesById.get()).setSlot(data.getSlot());
        }
        if (data.getSnmpVersion() != null) {
            ((SnmpRules)snmpRulesById.get()).setSnmpVersion(data.getSnmpVersion());
        }
        if (data.getStatusDetailFailure() != null) {
            ((SnmpRules)snmpRulesById.get()).setStatusDetailFailure(data.getStatusDetailFailure());
        }
        if (data.getStatusDetailSuccess() != null) {
            ((SnmpRules)snmpRulesById.get()).setStatusDetailSuccess(data.getStatusDetailSuccess());
        }
        if (data.getSuccessServiceCodeValue() != null) {
            ((SnmpRules)snmpRulesById.get()).setSuccessServiceCodeVariable(data.getSuccessServiceCodeVariable());
        }
        if (data.getSuccessValue() != null) {
            ((SnmpRules)snmpRulesById.get()).setSuccessValue(data.getSuccessValue());
        }
        if (data.getSuccessVariable() != null) {
            ((SnmpRules)snmpRulesById.get()).setSuccessVariable(data.getSuccessVariable());
        }
        if (data.getTrapId() != null) {
            ((SnmpRules)snmpRulesById.get()).setTrapId(data.getTrapId());
        }
        if (data.getTrapIdType() != null) {
            ((SnmpRules)snmpRulesById.get()).setTrapIdType(data.getTrapIdType());
        }
        this.snmpRulesRepository.save(snmpRulesById.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("snmpRules Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteManualAlert(String id) {
        logger.debug("Delete alert id {}", (Object)id);
        RequestResponse returnValue = new RequestResponse();
        Optional snmpRulesById = this.snmpRulesRepository.findById((Object)id);
        if (snmpRulesById.isPresent()) {
            try {
                this.snmpRulesRepository.deleteById((Object)id);
                returnValue.setStatus(0);
                returnValue.setMessage("snmp record deleted");
                logger.info(returnValue.getMessage());
            }
            catch (Exception ex) {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to delete snmp");
                returnValue.setMessageDetail("Contact with your administrator");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to delete record");
            returnValue.setMessageDetail("Record Not found");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse getById(String id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional snmpRulesById = this.snmpRulesRepository.findById((Object)id);
            if (snmpRulesById.isPresent()) {
                SnmpRulesModel data = new SnmpRulesModel();
                data.setAlias(((SnmpRules)snmpRulesById.get()).getAlias());
                data.setCreatedBy(((SnmpRules)snmpRulesById.get()).getCreatedBy());
                data.setCreatedOn(((SnmpRules)snmpRulesById.get()).getCreatedOn());
                data.setFailureServiceCodeValue(((SnmpRules)snmpRulesById.get()).getFailureServiceCodeValue());
                data.setFailureServiceCodeVariable(((SnmpRules)snmpRulesById.get()).getFailureServiceCodeVariable());
                data.setId(((SnmpRules)snmpRulesById.get()).getId());
                data.setRulePriority(((SnmpRules)snmpRulesById.get()).getRulePriority());
                data.setServiceCode(((SnmpRules)snmpRulesById.get()).getServiceCode());
                data.setSeverity(((SnmpRules)snmpRulesById.get()).getSeverity());
                data.setSlot(((SnmpRules)snmpRulesById.get()).getSlot());
                data.setSnmpVersion(((SnmpRules)snmpRulesById.get()).getSnmpVersion());
                data.setStatusDetailFailure(((SnmpRules)snmpRulesById.get()).getStatusDetailFailure());
                data.setStatusDetailSuccess(((SnmpRules)snmpRulesById.get()).getStatusDetailSuccess());
                data.setSuccessServiceCodeValue(((SnmpRules)snmpRulesById.get()).getSuccessServiceCodeValue());
                data.setSuccessServiceCodeVariable(((SnmpRules)snmpRulesById.get()).getSuccessServiceCodeVariable());
                data.setSuccessValue(((SnmpRules)snmpRulesById.get()).getSuccessValue());
                data.setSuccessVariable(((SnmpRules)snmpRulesById.get()).getSuccessVariable());
                data.setTrapId(((SnmpRules)snmpRulesById.get()).getTrapId());
                data.setTrapIdType(((SnmpRules)snmpRulesById.get()).getTrapIdType());
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
        }
        return returnValue;
    }
}

