/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.monitorService.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.service.main.monitorService.model.MonitorServiceModel;
import com.coraltele.telemetry.service.main.monitorService.service.MonitorServiceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/monitorService"})
@RestController
public class MonitorServiceController {
    @Autowired
    MonitorServiceService monitorServiceService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody MonitorServiceModel data) {
        RequestResponse returnValue = this.monitorServiceService.createMonitorService(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody MonitorServiceModel data) {
        RequestResponse returnValue = this.monitorServiceService.updateById(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/{id}"})
    public ResponseEntity<RequestResponse> deleteById(@PathVariable(value="id") Long id) {
        RequestResponse returnValue = this.monitorServiceService.deleteMonitorServiceById(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getMonitorServiceByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.monitorServiceService.getMonitorServiceByFilter(searchRequest);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

