/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.sensor.controller;

import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.coralnms.sensor.model.SensorModel;
import com.coraltele.telemetry.service.coralnms.sensor.service.SensorService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/sensor"})
public class SensorController {
    @Autowired
    private SensorService service;

    @PostMapping(value={"/register"})
    public String data(@RequestBody SensorModel data) {
        return this.service.create(data);
    }

    @GetMapping(value={"/{id}"})
    public List<SensorModel> getByid(@PathVariable(value="id") Long id) {
        return this.service.getById(id);
    }

    @GetMapping(value={"/list"})
    public List<SensorModel> getAll() {
        return this.service.getAll();
    }

    @GetMapping(value={"/list/{assetId}"})
    public ResponseEntity<RequestResponse> getAssetSensors(@PathVariable(value="assetId") String assetId) {
        RequestResponse returnValue = new RequestResponse();
        if (assetId.contains("-")) {
            returnValue.setData((Object)this.service.getAssetSensor(assetId));
        } else {
            returnValue.setData((Object)Long.parseLong(assetId));
        }
        return ResponseEntity.ok((Object)returnValue);
    }

    @PutMapping(value={"/{id}"})
    public String update(@RequestBody SensorModel data, @PathVariable(value="id") Long id) {
        return this.service.update(data, id);
    }
}

