/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.billing.callMos.service;

import com.coraltele.telemetry.db.billing.repository.CallMosRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.NodeConfiguration;
import com.coraltele.telemetry.db.telephony.pbx.repository.NodeConfigurationRepository;
import com.coraltele.telemetry.service.billing.callMos.service.MessageProducerService;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class MessageConsumerService {
    private static final Logger logger = LogManager.getLogger(MessageConsumerService.class);
    @Autowired
    private CallMosRepository callMosRepository;
    @Autowired
    private MessageProducerService messageProducerService;
    @Autowired
    NodeConfigurationRepository nodeConfigurationRepository;

    @PostConstruct
    public void initializeListeners() {
        try {
            List brokerIps = this.nodeConfigurationRepository.findAll();
            String ownIp = this.messageProducerService.getServerIp();
            boolean isBillingServer = false;
            for (NodeConfiguration brokerIp : brokerIps) {
                if (!StringUtils.hasText((String)brokerIp.getIpAddress()) || !brokerIp.getIpAddress().equalsIgnoreCase(ownIp) || brokerIp.getIsBillingEnabled() == null || brokerIp.getIsBillingEnabled() != 1) continue;
                isBillingServer = true;
                break;
            }
            for (NodeConfiguration brokerIp : brokerIps) {
                if (!isBillingServer && brokerIp.getIpAddress().equals(ownIp)) continue;
                this.startListener(brokerIp.getIpAddress());
            }
        }
        catch (Exception e) {
            logger.error("Error while initializing Message Listeners : {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void startListener(String brokerIp) {
        try {
            String brokerUrl = "tcp://" + brokerIp + ":9890";
            logger.info("ActiveMq Listen at:{}", (Object)brokerUrl);
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerUrl);
            factory.setUserName("admin");
            factory.setPassword("admin");
            DefaultMessageListenerContainer container = new DefaultMessageListenerContainer();
            container.setConnectionFactory((ConnectionFactory)factory);
            container.setDestinationName(this.messageProducerService.getServerCode() + ".call.mos");
            container.setMessageListener((Object)new /* Unavailable Anonymous Inner Class!! */);
            container.setConcurrency("2-5");
            container.setSessionAcknowledgeMode(2);
            container.initialize();
            container.start();
            logger.info("ActiveMQ Listener started for broker {} on queue {}", (Object)brokerIp, (Object)(this.messageProducerService.getServerCode() + ".call.mos"));
        }
        catch (Exception e) {
            logger.error("Failed to start listener for broker {}: {}", (Object)brokerIp, (Object)e.getMessage());
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static /* synthetic */ CallMosRepository access$100(MessageConsumerService x0) {
        return x0.callMosRepository;
    }
}

