/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnablePacketCapture;
import com.coraltele.telemetry.thread.PacketListenerThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnablePacketCapture.class})
public class PacketListenerProcess {
    private static final Logger logger = LogManager.getLogger(PacketListenerProcess.class);
    private static final Integer MAX_THREADS = 1;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);

    @Scheduled(fixedRate=5000L)
    public void startHealthCheck() {
        logger.info("Maximum Threads Packet Capture : {}, Active Thread Packet Capture {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting Bandwidth Analyzer Thread");
            this.threadPool.execute((Runnable)new PacketListenerThread());
        }
        logger.info("{} Threads started", (Object)threadsStarted);
    }
}

