/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.component.service.CallDataCollectionService;
import com.coraltele.telemetry.helper.Constants;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CallDataRecordDistributionThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(CallDataRecordDistributionThread.class);
    private Boolean isRunning = true;
    CallDataCollectionService callDataCollectionService;

    public CallDataRecordDistributionThread(CallDataCollectionService callDataCollectionService) {
        this.callDataCollectionService = callDataCollectionService;
    }

    @Override
    public void run() {
        logger.info("Starting thread for Cdr Data Distribution");
        try {
            while (Boolean.TRUE.equals(this.isRunning)) {
                this.callDataCollectionService.processWssUsersMapping();
                List cdrDataList = this.callDataCollectionService.processCoralAppCdrData();
                int userStatusList = this.callDataCollectionService.processUserStatusInteractions();
                int channelListSize = 100;
                if (Boolean.TRUE.equals(Constants.SEND_CHANNELS_DATA_IN_VOICE_LOGGER)) {
                    logger.info("Channels data processing for voice logger Started.");
                    channelListSize = this.callDataCollectionService.channelDataCollection();
                }
                if (Boolean.TRUE.equals(Constants.SEND_CHANNELS_DATA_IN_BILLING_CDR)) {
                    logger.info("Channels data processing for billing cdr Started.");
                    this.callDataCollectionService.setDataFromChannelsInBillingCdr();
                }
                Thread.sleep(cdrDataList.size() < 100 && channelListSize < 100 && userStatusList < 100 ? 10000L : 1000L);
            }
        }
        catch (Exception e) {
            logger.error("Error in Getting Data from db. Closing thread, thread will be re started in few seconds {}", (Object)e.getMessage(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }
}

