/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.user.service;

import com.coraltele.telemetry.db.users.main.entity.Menu;
import com.coraltele.telemetry.db.users.main.repository.MenuRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.ReturnField;
import com.coraltele.telemetry.service.user.model.MenuModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MenuService {
    private static final Logger logger = LogManager.getLogger(MenuService.class);
    @Autowired
    private MenuRepository menuRepository;

    public RequestResponse createMenu(MenuModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Menu menu = new Menu();
            menu.setDescription(data.getMenuDetail());
            menu.setMenuName(data.getMenuName());
            menu.setUrlPath(data.getUrlPath());
            this.menuRepository.save((Object)menu);
            ReturnField field = new ReturnField();
            field.setId(menu.getId());
            field.setDescription(menu.getDescription());
            returnValue.setStatus(0);
            returnValue.setMessage("Menu Registered");
            returnValue.setData((Object)field);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("unable to create menu");
            returnValue.setMessageDetail("Contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getMenuById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional menu = this.menuRepository.findById(id);
            if (menu.isPresent()) {
                MenuModel data = new MenuModel();
                data.setMenuDetail(((Menu)menu.get()).getDescription());
                data.setMenuName(((Menu)menu.get()).getMenuName());
                data.setUrlPath(((Menu)menu.get()).getUrlPath());
                returnValue.setStatus(0);
                returnValue.setMessage("Menu Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAll() {
        List list = (List)this.menuRepository.findAll();
        ArrayList<MenuModel> addValue = new ArrayList<MenuModel>();
        RequestResponse returnValue = new RequestResponse();
        for (Menu menu : list) {
            MenuModel data = new MenuModel();
            data.setMenuDetail(menu.getDescription());
            data.setMenuName(menu.getMenuName());
            data.setUrlPath(menu.getUrlPath());
            addValue.add(data);
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateMenu(int id, MenuModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional menu = this.menuRepository.findById(id);
            if (menu.isPresent()) {
                ((Menu)menu.get()).setMenuName(data.getMenuName());
                ((Menu)menu.get()).setDescription(data.getMenuDetail());
                ((Menu)menu.get()).setUrlPath(data.getUrlPath());
                this.menuRepository.save(menu.get());
                returnValue.setStatus(0);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("Menu Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("menu not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to update menu");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteMenu(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional menu = this.menuRepository.findById(id);
            if (menu.isPresent()) {
                this.menuRepository.deleteById((Object)id);
                returnValue.setStatus(0);
                returnValue.setMessage("deleted");
                returnValue.setMessageDetail("Record deleted successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to delete menu");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }
}

