/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.alternateIp.service;

import com.coraltele.telemetry.db.telemetry.main.entity.AlternateIp;
import com.coraltele.telemetry.db.telemetry.main.repository.AlternateIpRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.main.alternateIp.model.AlternateIpModel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlternateIpService {
    @Autowired
    private AlternateIpRepository alternateIpRepository;
    private static final Logger logger = LogManager.getLogger(AlternateIpService.class);

    public RequestResponse getAll() {
        List listOfAlternateIps = this.alternateIpRepository.findAll();
        ArrayList<AlternateIpModel> addValue = new ArrayList<AlternateIpModel>();
        RequestResponse returnValue = new RequestResponse();
        for (AlternateIp alternateIp : listOfAlternateIps) {
            AlternateIpModel data = new AlternateIpModel();
            data.setAliasIpAddress(alternateIp.getAliasIpAddress());
            data.setId(alternateIp.getId());
            data.setIpAddress(alternateIp.getIpAddress());
            data.setCreatedBy(alternateIp.getCreatedBy());
            data.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            addValue.add(data);
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createData(AlternateIpModel data, String userName) {
        logger.debug("alternteIp create new alert : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            AlternateIp alternateIp = new AlternateIp();
            alternateIp.setAliasIpAddress(data.getAliasIpAddress());
            alternateIp.setCreatedBy(userName);
            alternateIp.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            alternateIp.setId(data.getId());
            alternateIp.setIpAddress(data.getIpAddress());
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("AlternateIp created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setIssue(Constants.NodeStatus.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create AlternateIp");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(AlternateIpModel data, String userName) {
        logger.debug("Update AlternateIp {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional alternateIpById = this.alternateIpRepository.findById((Object)data.getId());
        if (!alternateIpById.isPresent()) {
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("AlternateIp not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getAliasIpAddress() != null) {
            ((AlternateIp)alternateIpById.get()).setAliasIpAddress(data.getAliasIpAddress());
        }
        if (data.getCreatedBy() != null) {
            ((AlternateIp)alternateIpById.get()).setCreatedBy(userName);
        }
        if (data.getCreatedOn() != null) {
            ((AlternateIp)alternateIpById.get()).setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
        }
        if (data.getId() != null) {
            ((AlternateIp)alternateIpById.get()).setId(data.getId());
        }
        if (data.getIpAddress() != null) {
            ((AlternateIp)alternateIpById.get()).setIpAddress(data.getIpAddress());
        }
        this.alternateIpRepository.save(alternateIpById.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("AlternateIp Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteById(String id) {
        logger.debug("Delete alert id {}", (Object)id);
        RequestResponse returnValue = new RequestResponse();
        Optional alternateIpById = this.alternateIpRepository.findById((Object)id);
        if (alternateIpById.isPresent()) {
            try {
                this.alternateIpRepository.deleteById((Object)id);
                returnValue.setStatus(0);
                returnValue.setMessage("AlternateIp deleted");
                logger.info(returnValue.getMessage());
            }
            catch (Exception ex) {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to delete alert");
                returnValue.setMessageDetail("Contact with your administrator");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to delete record");
            returnValue.setMessageDetail("Record Not found");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse getById(String id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional alternateIpById = this.alternateIpRepository.findById((Object)id);
            if (alternateIpById.isPresent()) {
                AlternateIpModel data = new AlternateIpModel();
                data.setId(((AlternateIp)alternateIpById.get()).getId());
                data.setAliasIpAddress(((AlternateIp)alternateIpById.get()).getAliasIpAddress());
                data.setCreatedBy(((AlternateIp)alternateIpById.get()).getCreatedBy());
                data.setCreatedOn(((AlternateIp)alternateIpById.get()).getCreatedOn());
                data.setIpAddress(((AlternateIp)alternateIpById.get()).getIpAddress());
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
        }
        return returnValue;
    }
}

