/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnableCallCenterVersionControl;
import com.coraltele.telemetry.db.billing.repository.UserStatusRepository;
import com.coraltele.telemetry.db.coralapps.repository.CoralAgentsStateRepository;
import com.coraltele.telemetry.helper.DateFormatUtility;
import com.coraltele.telemetry.helper.GetAgentFullName;
import com.coraltele.telemetry.thread.CallCenterVersionControlThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableCallCenterVersionControl.class})
public class CallCenterVersionControlProcess {
    private static final Logger logger = LogManager.getLogger(CallCenterVersionControlProcess.class);
    private static final Integer MAX_THREADS = 1;
    @Autowired
    private UserStatusRepository userStatusRepository;
    @Autowired
    private CoralAgentsStateRepository coralAgentsStateRepository;
    @Autowired
    private GetAgentFullName getAgentFullName;
    @Autowired
    private DateFormatUtility dateFormatUtility;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);

    @Scheduled(fixedRate=5000L)
    public void startCounterCollection() {
        logger.info("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting CallCenter VersionControl Thread");
            this.threadPool.execute((Runnable)new CallCenterVersionControlThread(this.userStatusRepository, this.coralAgentsStateRepository, this.getAgentFullName, this.dateFormatUtility));
        }
        logger.info("{} CallCenter Version Control Threads started", (Object)threadsStarted);
    }
}

