/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.NMSOutage;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.NMSOutageTrap;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.NMSOutageRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.NMSOutageTrapRepository;
import com.coraltele.telemetry.helper.SnmpService;
import com.coraltele.telemetry.model.SCADATrapModel;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;

public class NMSOutageThread
implements DisposableBean,
Runnable {
    private static final Logger logger = LogManager.getLogger(NMSOutageThread.class);
    private Thread thread;
    private NMSOutageRepository nmsOutageRepository;
    private NMSOutageTrapRepository nmsOutageTrapRepository;
    private SnmpService snmpService;
    public volatile boolean isRunning = true;

    public NMSOutageThread(NMSOutageRepository nmsOutageRepository, NMSOutageTrapRepository nmsOutageTrapRepository, SnmpService snmpService) {
        this.nmsOutageRepository = nmsOutageRepository;
        this.nmsOutageTrapRepository = nmsOutageTrapRepository;
        this.snmpService = snmpService;
        this.thread = new Thread((Runnable)this);
        this.thread.start();
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                SCADATrapModel scadaData;
                long id;
                Object trap;
                Thread.sleep(10000L);
                for (NMSOutage outage : this.nmsOutageRepository.findPendingDownMessages()) {
                    trap = new NMSOutageTrap();
                    id = outage.getNodeId().intValue();
                    scadaData = new SCADATrapModel(Long.valueOf(id), outage.getOid(), outage.getNodeName() + " " + outage.getServiceName(), outage.getIpAddress(), "ERROR", outage.getServiceName() + " Un-available", Integer.valueOf(0), outage.getServiceName(), Integer.valueOf(0), "", "", "ICMP", Integer.valueOf(3));
                    this.snmpService.sendTrap(scadaData, "");
                    trap.setOutageId(outage.getOutageId());
                    trap.setDownMessageSent(true);
                    trap.setUpMessageSent(false);
                    this.nmsOutageTrapRepository.save(trap);
                }
                for (NMSOutage outage : this.nmsOutageRepository.findPendingUpMessage()) {
                    trap = this.nmsOutageTrapRepository.findById((Object)outage.getTrapId());
                    id = outage.getNodeId().intValue();
                    if (!((Optional)trap).isPresent()) continue;
                    scadaData = new SCADATrapModel(Long.valueOf(id), outage.getOid(), outage.getNodeName() + " " + outage.getServiceName(), outage.getIpAddress(), "OK", outage.getServiceName() + " Available", Integer.valueOf(0), outage.getServiceName(), Integer.valueOf(0), "", "", "ICMP", Integer.valueOf(0));
                    this.snmpService.sendTrap(scadaData, "");
                    ((NMSOutageTrap)((Optional)trap).get()).setUpMessageSent(true);
                    this.nmsOutageTrapRepository.save(((Optional)trap).get());
                }
            }
            catch (InterruptedException e) {
                logger.error("While sleeping thread.", (Throwable)e);
            }
        }
    }

    public void destroy() throws Exception {
    }
}

