/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.alertHistory.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.InputIdModel;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.service.main.alertHistory.service.AlertHistoryService;
import com.coraltele.telemetry.service.main.alertHistory.service.AlertHistoryViewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/alertHistory"})
public class AlertHistoryController {
    @Autowired
    AlertHistoryViewService alertHistoryViewService;
    @Autowired
    AlertHistoryService alertHistoryService;

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllAlertHistory(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.alertHistoryViewService.getAllAlertHistory(searchRequest);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.alertHistoryService.deleteAlertHistoryById(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

