/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.widget.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.coralnms.widget.service.WidgetService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/api/v2/widget"})
@RestController
public class WidgetController {
    @Autowired
    WidgetService widgetService;

    @PostMapping(value={"/export"})
    public ResponseEntity<RequestResponse> storeDataIntoFile() throws IOException {
        RequestResponse returnValue = this.widgetService.storeDataIntoFile();
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/uploadFile"})
    public ResponseEntity<RequestResponse> upload(@RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="id") String id) throws IOException {
        RequestResponse returnValue = this.widgetService.widgetFileUpload(multipartFile, id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

