/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.location.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Location;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.LocationRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.specification.LocationSpecification;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.ReturnField;
import com.coraltele.telemetry.model.InputIdModel;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.model.SearchResponse;
import com.coraltele.telemetry.service.coralnms.location.model.LocationFilteredModel;
import com.coraltele.telemetry.service.coralnms.location.model.LocationModel;
import com.coraltele.telemetry.service.coralnms.location.model.LocationParentModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class LocationService {
    private static final Logger logger = LogManager.getLogger(LocationService.class);
    @Autowired
    LocationRepository locationRepository;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RequestResponse createLocation(LocationModel data) {
        logger.debug("create new location: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            List existingLocations = this.locationRepository.findAll();
            if (!existingLocations.isEmpty() && data.getParentLocation() == null) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("Parent ID is required ");
                logger.error(returnValue.getMessage());
                return returnValue;
            }
            Location location = new Location();
            location.setBackgroundImageURL(data.getBackgroundImageURL());
            location.setCode(data.getCode());
            location.setName(data.getName());
            location.setUuid(UUID.randomUUID());
            location.setXcoordinate(data.getXCoordinate());
            location.setYcoordinate(data.getYCoordinate());
            location.setConfiguration(data.getConfiguration());
            if (data.getParentLocation() != null) {
                Optional parentLocation = this.locationRepository.findById(data.getParentLocation());
                if (!parentLocation.isPresent()) {
                    returnValue.setIssue(Constants.NodeStatus.ERROR);
                    returnValue.setMessage("Invalid Parent Location ID.");
                    return returnValue;
                }
                location.setParentLocation((Location)parentLocation.get());
            } else {
                location.setParentLocation(null);
            }
            this.locationRepository.save((Object)location);
            returnValue.setStatus(0);
            returnValue.setMessage("Location created successfully");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        catch (DataIntegrityViolationException ex) {
            returnValue.setIssue(Constants.NodeStatus.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create location");
            returnValue.setMessageDetail("Read constraint cannot be null");
            logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            return returnValue;
        }
        catch (Exception e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("Error");
            returnValue.setMessageDetail("Location not created");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getById(Integer id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional location = this.locationRepository.findById(id);
            if (location.isPresent()) {
                LocationModel data = new LocationModel();
                data.setId(((Location)location.get()).getId());
                data.setBackgroundImageURL(((Location)location.get()).getBackgroundImageURL());
                data.setCode(((Location)location.get()).getCode());
                data.setName(((Location)location.get()).getName());
                data.setUuid(((Location)location.get()).getUuid());
                data.setXCoordinate(((Location)location.get()).getXcoordinate());
                data.setYCoordinate(((Location)location.get()).getYcoordinate());
                data.setConfiguration(((Location)location.get()).getConfiguration());
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
        }
        return returnValue;
    }

    public RequestResponse updateById(LocationModel data) {
        logger.debug("Update Location {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional location = this.locationRepository.findById(data.getId());
        if (!location.isPresent()) {
            returnValue.setStatus(-1);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("location not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getName() != null) {
            ((Location)location.get()).setName(data.getName());
        }
        if (data.getCode() != null) {
            ((Location)location.get()).setCode(data.getCode());
        }
        if (data.getUuid() != null) {
            ((Location)location.get()).setUuid(data.getUuid());
        }
        if (data.getBackgroundImageURL() != null) {
            ((Location)location.get()).setBackgroundImageURL(data.getBackgroundImageURL());
        }
        if (data.getXCoordinate() != null) {
            ((Location)location.get()).setXcoordinate(data.getXCoordinate());
        }
        if (data.getYCoordinate() != null) {
            ((Location)location.get()).setYcoordinate(data.getYCoordinate());
        }
        if (data.getConfiguration() != null) {
            ((Location)location.get()).setConfiguration(data.getConfiguration());
        }
        if (data.getParentLocation() != null) {
            Optional parentLocation = this.locationRepository.findById(data.getParentLocation());
            if (parentLocation.isPresent()) {
                ((Location)location.get()).setParentLocation((Location)parentLocation.get());
            } else {
                ((Location)location.get()).setParentLocation(null);
            }
        }
        this.locationRepository.save(location.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("location Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteLocation(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<Location> locationsToDelete = new ArrayList<Location>();
        for (Integer id : data.getId()) {
            Optional location = this.locationRepository.findById(Integer.valueOf(id));
            if (location.isPresent()) {
                Location currentLocation = (Location)location.get();
                if (this.hasChildLocations(currentLocation)) {
                    returnValue.setIssue(Constants.NodeStatus.ERROR);
                    returnValue.setMessage("Cannot delete location because it has child locations.");
                    logger.info(returnValue.getMessage());
                    return returnValue;
                }
                locationsToDelete.add(currentLocation);
                continue;
            }
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.locationRepository.deleteAll(locationsToDelete);
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records have been deleted");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    private boolean hasChildLocations(Location location) {
        return this.locationRepository.existsByParentLocation(location);
    }

    public RequestResponse getAllParentId() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<LocationParentModel> addValue = new ArrayList<LocationParentModel>();
        List location = this.locationRepository.findAll();
        if (location.isEmpty()) {
            returnValue.setMessage("List is empty");
            logger.error("unable to fetch data: ", (Object)returnValue.getMessage());
        } else {
            for (Location row : location) {
                LocationParentModel data = new LocationParentModel();
                data.setLocationId(row.getId());
                data.setLocationName(row.getName());
                data.setLocationCode(row.getCode());
                addValue.add(data);
            }
        }
        returnValue.setData(addValue);
        returnValue.setMessage("List of Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateBackgroundImageUrl(LocationModel data) {
        logger.debug("Update Location {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional location = this.locationRepository.findById(data.getId());
        if (!location.isPresent()) {
            returnValue.setStatus(-1);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("location not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getBackgroundImageURL() != null) {
            ((Location)location.get()).setBackgroundImageURL(data.getBackgroundImageURL());
        }
        this.locationRepository.save(location.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("backgroundImageURL Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getLocationByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = LocationSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.locationRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.locationRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        ArrayList location = new ArrayList();
        location.addAll(page.getContent());
        List finalData = this.getFilteredParentLocation(location);
        responseData.setCurrentPageData((Object)finalData);
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<LocationFilteredModel> getFilteredParentLocation(List<Location> location) {
        ArrayList<LocationFilteredModel> addValue = new ArrayList<LocationFilteredModel>();
        for (Location row : location) {
            LocationFilteredModel data = new LocationFilteredModel();
            ReturnField parentField = new ReturnField();
            data.setId(row.getId());
            data.setName(row.getName());
            data.setUuid(row.getUuid());
            if (row.getParentLocation() == null) {
                data.setParentLocation(null);
            } else {
                parentField.setId(row.getParentLocation().getId().intValue());
                parentField.setDescription(row.getParentLocation().getName());
                data.setParentLocation(parentField);
            }
            data.setCode(row.getCode());
            data.setBackgroundImageURL(row.getBackgroundImageURL());
            data.setXcoordinate(row.getXcoordinate());
            data.setYcoordinate(row.getYcoordinate());
            data.setConfiguration(row.getConfiguration());
            addValue.add(data);
        }
        return addValue;
    }
}

