/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.helper.Constants;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import org.joda.time.Days;
import org.joda.time.ReadablePartial;
import org.springframework.stereotype.Component;

@Component
public class DateFormatUtility {
    private static final ZoneId zoneId = ZoneId.of(Constants.TIME_ZONE_FOR_SUMMARY);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    public long getDaysDifference(LocalDate previousDate, LocalDate currentDate) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String convertPreviousDate = dateTimeFormatter.format(previousDate);
        String convertCurrentDate = dateTimeFormatter.format(currentDate);
        org.joda.time.LocalDate dateBefore = org.joda.time.LocalDate.parse((String)convertPreviousDate);
        org.joda.time.LocalDate dateAfter = org.joda.time.LocalDate.parse((String)convertCurrentDate);
        long daysDifference = Math.abs(Days.daysBetween((ReadablePartial)dateBefore, (ReadablePartial)dateAfter).getDays());
        return daysDifference;
    }

    public LocalDateTime convertStringToTimestamp(String dateString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("d MMM, yyyy h:mm:ss a");
        LocalDateTime localDateTime = LocalDateTime.parse(dateString, formatter);
        return localDateTime;
    }

    public String formatDuration(long durationInSeconds) {
        Duration duration = Duration.ofSeconds(durationInSeconds);
        long hours = duration.toHours();
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.getSeconds() % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public Integer getDurationInSeconds(LocalDateTime startTime, LocalDateTime endTime) {
        Duration duration = Duration.between(startTime, endTime);
        return (int)duration.abs().getSeconds();
    }

    public Object epochToLocalDateTime(Long epoch) {
        if (epoch == 0L || epoch == null) {
            return "";
        }
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(epoch), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formatDateTime = localDateTime.format(formatter);
        return formatDateTime;
    }

    public static Long toEpochSeconds(String dateTimeStr) {
        LocalDateTime dateTime = LocalDateTime.parse(dateTimeStr, formatter).truncatedTo(ChronoUnit.MINUTES);
        return dateTime.atZone(ZoneOffset.UTC).toInstant().getEpochSecond();
    }

    public static String fromEpochSeconds(Long epochSeconds) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds), ZoneOffset.UTC);
        return dateTime.format(formatter);
    }

    public static LocalDateTime epochToLocalDTime(Long epoch) {
        if (epoch == null) {
            throw new IllegalArgumentException("Epoch value cannot be null");
        }
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(epoch), ZoneId.systemDefault());
    }

    public Long getMidNightEpochFromDateTime(LocalDateTime dateTime) {
        LocalDateTime startOfDay = dateTime.toLocalDate().atStartOfDay();
        return startOfDay.atZone(zoneId).toEpochSecond();
    }

    public long getMidnightEpochFromEpoch(long recordEpoch) {
        ZonedDateTime dateTimeZoned = Instant.ofEpochSecond(recordEpoch).atZone(zoneId);
        ZonedDateTime startOfDay = dateTimeZoned.toLocalDate().atStartOfDay(zoneId);
        return startOfDay.toEpochSecond();
    }

    public long toEpoch(LocalDateTime dateTime) {
        return dateTime.atZone(zoneId).toEpochSecond();
    }

    public LocalDateTime toLocalDateTime(long epochSeconds) {
        return Instant.ofEpochSecond(epochSeconds).atZone(zoneId).toLocalDateTime();
    }
}

