DO $$
BEGIN
    IF NOT EXISTS (
            SELECT 1
            FROM information_schema.views
            WHERE table_schema = 'pbx'
            AND table_name = 'v_extensionforstatemachine'
        ) THEN
            CREATE VIEW pbx.v_extensionforstatemachine AS
            SELECT a.extension,
                COALESCE(a.imsi, ''::text::character varying) AS imsi,
                a.extension_type,
                    CASE
                        WHEN COALESCE(vip.name, ''::text) <> ''::text THEN COALESCE(vip.name, ''::text)::character varying(255)
                        ELSE a.name
                    END AS name,
                COALESCE(a.ext_groupid, ''::text) AS ext_groupid,
                    CASE
                        WHEN COALESCE(b.id, 0) > 0 THEN 1
                        ELSE 0
                    END AS featurecode,
                COALESCE(a.rlucode, ''::text) AS rlucode,
                COALESCE(did.did_number, ''::character varying) AS did_number,
                COALESCE(did.dod_number, ''::character varying) AS dod_number,
                COALESCE(service.dnd, 0::bigint) AS dnd,
                COALESCE(service.vm, 0::bigint) AS vm,
                COALESCE(service.intercom, 0::bigint) AS intercom,
                COALESCE(service.local, 0::bigint) AS local,
                COALESCE(service.std, 0::bigint) AS std,
                COALESCE(service.isd, 0::bigint) AS isd,
                COALESCE(service.fwd_no_ans::text, '0'::text) AS fwd_no_ans,
                COALESCE(service.fwd_busy::text, '0'::text) AS fwd_busy,
                COALESCE(service.fwd_all::text, '0'::text) AS fwd_all,
                loc.contact,
                split_part(split_part(loc.contact::text, '@'::text, 2), ':'::text, 1) AS registeredip,
                    CASE
                        WHEN COALESCE(split_part(split_part(split_part(loc.contact::text, '@'::text, 2), ':'::text, 2), ';'::text, 1), ''::text) = ''::text THEN '0'::text
                        ELSE COALESCE(split_part(split_part(split_part(loc.contact::text, '@'::text, 2), ':'::text, 2), ';'::text, 1), '0'::text)
                    END AS registeredport,
                COALESCE(a.data, ''::text) AS datavalue,
                0 AS maxchannel,
                COALESCE(a.company, ''::character varying) AS company,
                COALESCE(a.department, ''::character varying) AS department,
                COALESCE(a.designation, ''::character varying) AS designation,
                COALESCE(a.accountcode, ''::character varying) AS accountcode,
                COALESCE(a.column2, ''::text) AS location,
                COALESCE(a.assigneduser, ''::text::character varying) AS ucuser,
                COALESCE(a.homerlucode, ''::text) AS homerlucode,
                    CASE
                        WHEN COALESCE(loc.username, ''::character varying)::text = ''::text THEN 0::bigint
                        ELSE date_part('epoch'::text, loc.expires - loc.last_modified)::bigint
                    END AS expire,
                    CASE
                        WHEN COALESCE(loc.username, ''::character varying)::text = ''::text THEN 0::bigint
                        ELSE date_part('epoch'::text, loc.last_modified::timestamp(0) with time zone)::bigint
                    END AS registrationepoch
            FROM pbx.extensions a
                LEFT JOIN pbx.m_vipmaster vip ON a.extension = COALESCE(vip.officeext, ''::text)
                LEFT JOIN pbx.didmapping did ON a.extension = COALESCE(did.ext_number, ''::text::character varying)::text
                LEFT JOIN pbx.v_extensionwiseservices service ON a.extension = service.extension
                LEFT JOIN location loc ON a.extension = loc.username::text
                LEFT JOIN ( SELECT b_1.id,
                        b_1.extension
                    FROM ( SELECT m_actioncodelist.id,
                                m_actioncodelist.description,
                                m_actioncodelist.shortcode
                            FROM pbx.m_actioncodelist
                            UNION
                            SELECT codemaster.id,
                                codemaster.description,
                                codemaster.shortcode
                            FROM pbx.codemaster) a_1
                        JOIN pbx.extensions b_1 ON a_1.shortcode::text = b_1.extension_type::text) b ON a.extension = b.extension
            UNION
            SELECT a.gatewaycode AS extension,
                ''::text AS imsi,
                'gatewaycontroller'::character varying(20) AS extension_type,
                COALESCE(a.description, ''::character varying)::character varying(255) AS name,
                ''::text AS ext_groupid,
                0 AS featurecode,
                ''::text AS rlucode,
                ''::text AS did_number,
                ''::text AS dod_number,
                0 AS dnd,
                0 AS vm,
                0 AS intercom,
                0 AS local,
                0 AS std,
                0 AS isd,
                '0'::text AS fwd_no_ans,
                '0'::text AS fwd_busy,
                '0'::text AS fwd_all,
                ''::character varying(512) AS contact,
                ''::text AS registeredip,
                '0'::text AS registeredport,
                ''::text AS datavalue,
                COALESCE(sum(a.channellimit), 0::bigint) AS maxchannel,
                ''::text AS company,
                ''::text AS department,
                ''::text AS designation,
                ''::text AS accountcode,
                ''::text AS location,
                ''::text AS ucuser,
                ''::text AS homerlucode,
                0::bigint AS expire,
                0::bigint AS registrationepoch
            FROM pbx.m_gatewaycontroller a
            GROUP BY a.gatewaycode, a.description;

            ALTER TABLE pbx.v_extensionforstatemachine
            OWNER TO postgres;
    END IF;
END $$;