/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.coralapps.entity.CallDataRecord;
import com.coraltele.telemetry.db.coralapps.repository.CallDataRecordRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.SwitchCallDataRecord;
import com.coraltele.telemetry.db.telephony.pbx.repository.SwitchCallDataRecordRepository;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwitchCdrCollectionThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(SwitchCdrCollectionThread.class);
    private SwitchCallDataRecordRepository switchCallDataRecordRepository;
    private CallDataRecordRepository callDataRecordRepository;
    Boolean isActive = true;

    public SwitchCdrCollectionThread(SwitchCallDataRecordRepository switchCallDataRecordRepository, CallDataRecordRepository callDataRecordRepository) {
        this.switchCallDataRecordRepository = switchCallDataRecordRepository;
        this.callDataRecordRepository = callDataRecordRepository;
    }

    @Override
    public void run() {
        try {
            while (Boolean.TRUE.equals(this.isActive)) {
                logger.info("Starting Thread for Switch CDR Data Process");
                List switchDataList = this.switchCallDataRecordRepository.getDataToSync();
                if (!switchDataList.isEmpty()) {
                    for (SwitchCallDataRecord switchData : switchDataList) {
                        try {
                            logger.info("Switch data Processing is: {}", (Object)switchData.getUuid().toString());
                            CallDataRecord calldataRecord = new CallDataRecord();
                            calldataRecord.setAgentName(switchData.getAgentName());
                            calldataRecord.setAgentType(switchData.getAgentType());
                            calldataRecord.setAnswerTime(switchData.getAnswerTime());
                            calldataRecord.setBillsec(switchData.getBillsec());
                            calldataRecord.setBridgeUUID(switchData.getBridgeUUID());
                            calldataRecord.setCallerIDName(switchData.getCallerIDName());
                            calldataRecord.setCallerIDNumber(switchData.getCallerIDNumber());
                            calldataRecord.setCampaign(switchData.getCampaign());
                            calldataRecord.setCoralApp(switchData.getCoralApp());
                            calldataRecord.setDestinationNumber(switchData.getDestinationNumber());
                            calldataRecord.setDirection(switchData.getDirection());
                            calldataRecord.setEndTime(switchData.getEndTime());
                            calldataRecord.setHangupCause(switchData.getHangupCause());
                            calldataRecord.setInitialCallerIdNumber(switchData.getInitialCallerIdNumber());
                            calldataRecord.setIsDataSynced(switchData.getIsDataSynced());
                            calldataRecord.setLastApp(switchData.getLastApp());
                            calldataRecord.setLastArg(switchData.getLastArg());
                            calldataRecord.setMemberSessionUUID(switchData.getMemberSessionUUID());
                            calldataRecord.setPulse(switchData.getPulse());
                            calldataRecord.setPulseRate(switchData.getPulseRate());
                            calldataRecord.setQueue(switchData.getQueue());
                            calldataRecord.setRecordType(switchData.getRecordType());
                            calldataRecord.setRecordingFile(switchData.getRecordingFile());
                            calldataRecord.setStartTime(switchData.getStartTime());
                            calldataRecord.setTransferBy(switchData.getTransferBy());
                            calldataRecord.setTransferTo(switchData.getTransferTo());
                            calldataRecord.setTransferType(switchData.getTransferType());
                            calldataRecord.setUuid(switchData.getUuid());
                            calldataRecord.setTransferStatus(switchData.getTransferStatus());
                            calldataRecord.setSipRecToUri(switchData.getSipRecToUri());
                            calldataRecord.setRemoteMeidaIp(switchData.getRemoteMeidaIp());
                            calldataRecord.setDestinationName(switchData.getDestinationName());
                            calldataRecord.setDuration(switchData.getDuration());
                            calldataRecord.setColumn3(switchData.getColumn3());
                            calldataRecord.setRemoteCallerIp(switchData.getRemoteCallerIp());
                            calldataRecord.setMemberUUID(switchData.getMemberUUID());
                            calldataRecord.setInitialDestinationNumber(switchData.getInitialDestinationNumber());
                            calldataRecord.setContext(switchData.getContext());
                            calldataRecord.setRtpAudioInMos(switchData.getRtpAudioInMos());
                            calldataRecord.setRtpJitterMinVariance(switchData.getRtpJitterMinVariance());
                            calldataRecord.setRtpJitterMaxVariance(switchData.getRtpJitterMaxVariance());
                            calldataRecord.setRtpJitterLossRate(switchData.getRtpJitterLossRate());
                            calldataRecord.setCoralCallDirection(switchData.getCoralCallDirection());
                            calldataRecord.setQueueJoinedEpoch(switchData.getQueueJoinedEpoch());
                            calldataRecord.setCoralGateway(switchData.getCoralGateway());
                            calldataRecord.setCoralGateway(switchData.getCoralGateway());
                            calldataRecord.setCoralGatewayName(switchData.getCoralGatewayName());
                            calldataRecord.setCoralInBoundGateway(switchData.getCoralInBoundGateway());
                            calldataRecord.setCoralInBoundGatewayName(switchData.getCoralInBoundGatewayName());
                            calldataRecord.setCoralFeatureCode(switchData.getCoralFeatureCode());
                            this.callDataRecordRepository.save((Object)calldataRecord);
                            switchData.setIsDataSynced(Integer.valueOf(1));
                            this.switchCallDataRecordRepository.save((Object)switchData);
                        }
                        catch (Exception ex) {
                            switchData.setIsDataSynced(Integer.valueOf(-100));
                            this.switchCallDataRecordRepository.save((Object)switchData);
                            logger.error("Error processing switch cdr data UUID : {} {} {}", (Object)switchData.getUuid().toString(), (Object)ex.getMessage(), (Object)ex);
                        }
                    }
                } else {
                    logger.info("Switch cdr data list is empty");
                }
                Thread.sleep(switchDataList.size() < 100 ? 10000L : 1000L);
                logger.info("Successfully Sync Switch Cdr data");
            }
        }
        catch (Exception e) {
            logger.info("Error while processing Switch Cdr into Coralapps: {} {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

