/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Category;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.AlertHistory;
import com.coraltele.telemetry.db.telemetry.main.entity.Severity;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertHistoryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.SeverityRepository;
import com.coraltele.telemetry.helper.SendEmail;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendEmailThread
implements Runnable {
    private CategoryRepository categoryRepository;
    private AlertHistoryRepository alertHistoryRepository;
    private SendEmail sendEmail;
    private SeverityRepository severityRepository;
    private static final Logger logger = LogManager.getLogger(SendEmailThread.class);
    String mailBodyDataReplace;
    String mailSubjectDataReplace;

    public SendEmailThread(SendEmail sendEmailService, CategoryRepository categoryRepositoryNode, AlertHistoryRepository alertHistoryRepositoryNode, SeverityRepository severityRepository) {
        this.sendEmail = sendEmailService;
        this.categoryRepository = categoryRepositoryNode;
        this.alertHistoryRepository = alertHistoryRepositoryNode;
        this.severityRepository = severityRepository;
    }

    @Override
    public void run() {
        logger.info("Starting thread for send mails of NMS alerts");
        try {
            while (true) {
                List nodAlertHistories = (List)this.alertHistoryRepository.findAll();
                for (AlertHistory alert : nodAlertHistories) {
                    Optional categoryCode = this.categoryRepository.findByCode(alert.getCategoryCode());
                    Optional listSeverity = this.severityRepository.findBySeverityLevel(alert.getSeverity());
                    logger.info("Processing alert for sending mail {} ", (Object)alert);
                    if (categoryCode.isPresent()) {
                        if (Boolean.TRUE.equals(((Category)categoryCode.get()).getSendEmail())) {
                            if (this.sendEmail.mailTo != null && this.sendEmail.mailFrom != null) {
                                this.mailBodyDataReplace = this.sendEmail.mailBody.replace("##IPAddress", alert.getIpAddress()).replace("##ServiceCode", alert.getServiceCode()).replace("##Severity", listSeverity.isPresent() ? ((Severity)listSeverity.get()).getSeverityName() : Integer.toString(alert.getSeverity())).replace("##CategoryCode", ((Category)categoryCode.get()).getCode()).replace("##nodeName", alert.getName());
                                this.mailSubjectDataReplace = this.sendEmail.subject.replace("##IPAddress", alert.getIpAddress()).replace("##ServiceCode", alert.getServiceCode()).replace("##Severity", listSeverity.isPresent() ? ((Severity)listSeverity.get()).getSeverityName() : Integer.toString(alert.getSeverity())).replace("##CategoryCode", ((Category)categoryCode.get()).getCode()).replace("##nodeName", alert.getName());
                                if (this.sendEmail.sendMail(((Category)categoryCode.get()).getEmailId(), this.sendEmail.mailFrom, this.sendEmail.mailBody, this.sendEmail.subject)) {
                                    logger.info("Send mail failed, Status reverted. System will retry sending mail.");
                                } else {
                                    logger.info("mail is sent Successfully");
                                    alert.setEmailAlertSend(Integer.valueOf(1));
                                }
                            } else {
                                alert.setEmailAlertSend(Integer.valueOf(-3));
                                logger.info("where sendTo and sendFrom is not Present {}", categoryCode.get());
                            }
                        } else {
                            alert.setEmailAlertSend(Integer.valueOf(-1));
                            logger.info("mail is not send Successfully {}", (Object)alert.getCategoryCode());
                        }
                    } else {
                        alert.setEmailAlertSend(Integer.valueOf(-2));
                        logger.info("Category not found {}", (Object)alert.getCategoryCode());
                    }
                    this.alertHistoryRepository.save((Object)alert);
                }
                Thread.sleep(2000L);
            }
        }
        catch (Exception e) {
            logger.info("Error in send email thread for NMS Alerts. Closing thread, thread will be re started in few seconds", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
    }
}

