/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.messaging.service;

import com.coraltele.telemetry.db.telemetry.main.entity.ExtensionStatus;
import com.coraltele.telemetry.db.telemetry.main.repository.ExtensionStatusRepository;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class ChannelUpdateMessageSubscriber
implements MessageListener {
    private static final Logger logger = LogManager.getLogger(ChannelUpdateMessageSubscriber.class);
    private ExtensionStatusRepository extensionStatusRepository;

    public void onMessage(Message message, byte[] pattern) {
        String messageBody = message.toString();
        logger.info("State Update : {}", (Object)messageBody);
        ObjectMapper data = new ObjectMapper();
        try {
            data.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ExtensionStatus dataReceived = (ExtensionStatus)data.readValue(messageBody, ExtensionStatus.class);
            Optional extension = this.extensionStatusRepository.findById((Object)dataReceived.getNumber());
            if (extension.isPresent()) {
                ExtensionStatus dataToSave = (ExtensionStatus)extension.get();
                dataToSave.setAvailable(dataReceived.isAvailable());
                dataToSave.setRemoteParty(dataReceived.getRemoteParty());
                dataToSave.setCallStatus(dataReceived.getCallStatus());
                dataToSave.setAccountcode(dataReceived.getAccountcode());
                dataToSave.setActiveCallId(dataReceived.getActiveCallId());
                dataToSave.setAvailabilityState(dataReceived.getAvailabilityState());
                dataToSave.setAvailabilityStateEpoch(dataReceived.getAvailabilityStateEpoch());
                dataToSave.setAvailableChannel(dataReceived.getAvailableChannel());
                dataToSave.setCompany(dataReceived.getCompany());
                dataToSave.setConsumedChannel(dataReceived.getConsumedChannel());
                dataToSave.setContact(dataReceived.getContact());
                dataToSave.setData(dataReceived.getData());
                dataToSave.setDepartment(dataReceived.getDepartment());
                dataToSave.setDesignation(dataReceived.getDesignation());
                dataToSave.setDidNumber(dataReceived.getDidNumber());
                dataToSave.setDirection(dataReceived.getDirection());
                dataToSave.setDnd(dataReceived.getDnd());
                dataToSave.setDodNumber(dataReceived.getDodNumber());
                dataToSave.setExpire(dataReceived.getExpire());
                dataToSave.setExtensionType(dataReceived.getExtensionType());
                dataToSave.setFeatureCode(dataReceived.getFeatureCode());
                dataToSave.setFwd_all(dataReceived.getFwd_all());
                dataToSave.setFwd_busy(dataReceived.getFwd_busy());
                dataToSave.setFwd_no_ans(dataReceived.getFwd_no_ans());
                dataToSave.setGatewayState(dataReceived.getGatewayState());
                dataToSave.setGroupCode(dataReceived.getGroupCode());
                dataToSave.setHomeRluCode(dataReceived.getHomeRluCode());
                dataToSave.setIntercom(dataReceived.getIntercom());
                dataToSave.setIsd(dataReceived.getIsd());
                dataToSave.setLastNumberDialedExternal(dataReceived.getLastNumberDialedExternal());
                dataToSave.setLastNumberDialedInternal(dataReceived.getLastNumberDialedInternal());
                dataToSave.setLastReceivedCall(dataReceived.getLastReceivedCall());
                dataToSave.setLocal(dataReceived.getLocal());
                dataToSave.setLocation(dataReceived.getLocation());
                dataToSave.setMaxChannel(dataReceived.getMaxChannel());
                dataToSave.setName(dataReceived.getName());
                dataToSave.setOnHook(dataReceived.isOnHook());
                dataToSave.setPresenceStatus(dataReceived.getPresenceStatus());
                dataToSave.setRegistrationEpoch(dataReceived.getRegistrationEpoch());
                dataToSave.setRegistrationIP(dataReceived.getRegistrationIP());
                dataToSave.setRegistrationPort(dataReceived.getRegistrationPort());
                dataToSave.setRegistrationStatus(dataReceived.getRegistrationStatus());
                dataToSave.setRluCode(dataReceived.getRluCode());
                dataToSave.setStd(dataReceived.getStd());
                dataToSave.setUcUser(dataReceived.getUcUser());
                dataToSave.setVm(dataReceived.getVm());
                this.extensionStatusRepository.save((Object)dataToSave);
            } else {
                this.extensionStatusRepository.save((Object)dataReceived);
            }
        }
        catch (Exception e) {
            logger.info("Error while processing message : {}", (Object)messageBody, (Object)e);
        }
    }

    @Generated
    public ExtensionStatusRepository getExtensionStatusRepository() {
        return this.extensionStatusRepository;
    }

    @Generated
    public void setExtensionStatusRepository(ExtensionStatusRepository extensionStatusRepository) {
        this.extensionStatusRepository = extensionStatusRepository;
    }
}

