/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.categoryService.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.service.main.categoryService.model.CategoryServiceModel;
import com.coraltele.telemetry.service.main.categoryService.service.CategoryServiceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/categoryService"})
@RestController
public class CategoryServiceController {
    @Autowired
    CategoryServiceService categoryServiceService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody CategoryServiceModel data) {
        RequestResponse returnValue = this.categoryServiceService.createCategoryService(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody CategoryServiceModel data) {
        RequestResponse returnValue = this.categoryServiceService.updateById(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/{id}"})
    public ResponseEntity<RequestResponse> deleteById(@PathVariable(value="id") Long id) {
        RequestResponse returnValue = this.categoryServiceService.deleteCategoryServiceById(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getCategoryServiceByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.categoryServiceService.getCategoryServiceByFilter(searchRequest);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dropdownServiceCode/list"})
    public ResponseEntity<RequestResponse> getAllServiceCode() {
        RequestResponse returnValue = this.categoryServiceService.getAllServiceCode();
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/dropdownCategoryCode/list"})
    public ResponseEntity<RequestResponse> getAllCategoryCode() {
        RequestResponse returnValue = this.categoryServiceService.getAllCategoryCode();
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

