/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.telephony.pbx.controller;

import com.coraltele.telemetry.db.telephony.pbx.entity.SmsDetails;
import com.coraltele.telemetry.db.telephony.pbx.service.SmsDetailsService;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/sms"})
public class SmsDetailsController {
    @Autowired
    private SmsDetailsService smsDetailsService;

    @GetMapping(value={"/save"})
    public ResponseEntity<RequestResponse> sendSms(@RequestHeader(value="Authorization") String authHeader, @RequestParam(name="to") String destination, @RequestParam(name="message") String smsText) {
        RequestResponse returnValue = new RequestResponse();
        try {
            if (!("Cluster " + Constants.CLUSTER_KEY).equals(authHeader)) {
                returnValue.setStatus(1);
                returnValue.setMessage("Unauthorized: Invalid Cluster key");
                return new ResponseEntity((Object)returnValue, HttpStatus.UNAUTHORIZED);
            }
            SmsDetails savedSms = this.smsDetailsService.saveSms(destination, smsText);
            returnValue.setMessage("SMS saved successfully in pbx.smsdetails table");
            returnValue.setData((Object)savedSms);
        }
        catch (Exception e) {
            returnValue.setStatus(1);
            returnValue.setMessage("Error in saving SMS");
            returnValue.setMessageDetail(e.getMessage());
            return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
        }
        return ResponseEntity.ok((Object)returnValue);
    }
}

