/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.controller;

import com.coraltele.telemetry.component.service.SystemHealthService;
import com.coraltele.telemetry.helper.RequestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/healthCheck"})
@Configuration
public class SystemHealthController {
    @Autowired
    private SystemHealthService systemHealthService;

    @GetMapping(value={"/ram/{widgetId}"})
    public ResponseEntity<RequestResponse> RamInfo(@PathVariable(value="widgetId") String widgetId) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            RequestResponse data = this.systemHealthService.getRamInfo(widgetId);
            return ResponseEntity.ok((Object)data);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/hdd/{widgetId}"})
    public ResponseEntity<RequestResponse> getHardDisk(@PathVariable(value="widgetId") String widgetId) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            RequestResponse data = this.systemHealthService.getHardDisk(widgetId);
            return ResponseEntity.ok((Object)data);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/listProcess/{widgetId}"})
    public ResponseEntity<RequestResponse> getProcessList(@PathVariable(value="widgetId") String widgetId) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            RequestResponse data = this.systemHealthService.getProcessList(widgetId);
            return ResponseEntity.ok((Object)data);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/swapMemory/{widgetId}"})
    public ResponseEntity<RequestResponse> getSwapMemory(@PathVariable(value="widgetId") String widgetId) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            RequestResponse data = this.systemHealthService.getSwapMemory(widgetId);
            return ResponseEntity.ok((Object)data);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/cpuLoad/{widgetId}"})
    public ResponseEntity<RequestResponse> getCpuLoad(@PathVariable(value="widgetId") String widgetId) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            RequestResponse data = this.systemHealthService.getCpuLoad(widgetId);
            return ResponseEntity.ok((Object)data);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

