/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.billing.entity;

import java.math.BigDecimal;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="call_mos")
public class CallMos {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(name="callid")
    private String callId;
    @Column(name="mos", columnDefinition="numeric(2,1) default 0")
    private BigDecimal mos;
    @Column(name="createdon")
    private Long createdOn;
    @Column(name="callerid")
    private String caller;
    @Column(name="calleeid")
    private String callee;
    private String uuid;
    @Column(name="rtp_audio_in_jitter_min_variance", columnDefinition="numeric(5,3) default 0")
    private BigDecimal rtpJitterMinVariance;
    @Column(name="rtp_audio_in_jitter_max_variance", columnDefinition="numeric(5,3) default 0")
    private BigDecimal rtpJitterMaxVariance;
    @Column(name="rtp_audio_in_jitter_loss_rate", columnDefinition="numeric(5,3) default 0")
    private BigDecimal rtpJitterLossRate;

    @PrePersist
    private void setValue() {
        if (this.mos == null) {
            this.mos = BigDecimal.valueOf(0.0);
        }
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID().toString();
        }
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public String getCallId() {
        return this.callId;
    }

    @Generated
    public BigDecimal getMos() {
        return this.mos;
    }

    @Generated
    public Long getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public String getCaller() {
        return this.caller;
    }

    @Generated
    public String getCallee() {
        return this.callee;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public BigDecimal getRtpJitterMinVariance() {
        return this.rtpJitterMinVariance;
    }

    @Generated
    public BigDecimal getRtpJitterMaxVariance() {
        return this.rtpJitterMaxVariance;
    }

    @Generated
    public BigDecimal getRtpJitterLossRate() {
        return this.rtpJitterLossRate;
    }

    @Generated
    public void setId(Integer id) {
        this.id = id;
    }

    @Generated
    public void setCallId(String callId) {
        this.callId = callId;
    }

    @Generated
    public void setMos(BigDecimal mos) {
        this.mos = mos;
    }

    @Generated
    public void setCreatedOn(Long createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setCaller(String caller) {
        this.caller = caller;
    }

    @Generated
    public void setCallee(String callee) {
        this.callee = callee;
    }

    @Generated
    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setRtpJitterMinVariance(BigDecimal rtpJitterMinVariance) {
        this.rtpJitterMinVariance = rtpJitterMinVariance;
    }

    @Generated
    public void setRtpJitterMaxVariance(BigDecimal rtpJitterMaxVariance) {
        this.rtpJitterMaxVariance = rtpJitterMaxVariance;
    }

    @Generated
    public void setRtpJitterLossRate(BigDecimal rtpJitterLossRate) {
        this.rtpJitterLossRate = rtpJitterLossRate;
    }

    @Generated
    public CallMos() {
    }

    @Generated
    public CallMos(Integer id, String callId, BigDecimal mos, Long createdOn, String caller, String callee, String uuid, BigDecimal rtpJitterMinVariance, BigDecimal rtpJitterMaxVariance, BigDecimal rtpJitterLossRate) {
        this.id = id;
        this.callId = callId;
        this.mos = mos;
        this.createdOn = createdOn;
        this.caller = caller;
        this.callee = callee;
        this.uuid = uuid;
        this.rtpJitterMinVariance = rtpJitterMinVariance;
        this.rtpJitterMaxVariance = rtpJitterMaxVariance;
        this.rtpJitterLossRate = rtpJitterLossRate;
    }
}

