/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.WidgetList;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetListRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.HttpUtils;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.ChannelActiveCallsModel;
import com.coraltele.telemetry.model.GraphDataPointModel;
import com.coraltele.telemetry.model.NewActiveCallsChannel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class ChannelActiveCallService {
    private static final Logger logger = LogManager.getLogger(ChannelActiveCallService.class);
    private static final double ONE_WAY_BASE_KBPS = 95.2;
    private static final double TWO_WAY_BASE_KBPS = 190.4;
    @Autowired
    WidgetListRepository widgetListRepository;

    public List<ChannelActiveCallsModel> fetchChannelActiveCallData(String widgetCode) {
        Optional widgetData = this.widgetListRepository.findByCode(widgetCode);
        ArrayList<ChannelActiveCallsModel> returnValue = new ArrayList<ChannelActiveCallsModel>();
        if (widgetData.isPresent()) {
            if (Constants.NODE_MODE.contains("PBX")) {
                return HttpUtils.getRemoteActiveCalls((String)((WidgetList)widgetData.get()).getMetricsInstanceName());
            }
            String callServerURL = String.format("http%s://%s/api/v2/realtime/channels", Constants.CLUSTER_SSL_ENABLED != false ? "s" : "", ((WidgetList)widgetData.get()).getMetricsInstanceName());
            logger.info("Fetching data from : {}", (Object)callServerURL);
            try {
                RestTemplate restTemplate = new RestTemplate();
                ResponseEntity response = restTemplate.getForEntity(callServerURL, NewActiveCallsChannel[].class, new Object[0]);
                NewActiveCallsChannel[] data = (NewActiveCallsChannel[])response.getBody();
                long currentTimestamp = System.currentTimeMillis() / 1000L;
                if (logger.isDebugEnabled()) {
                    ObjectMapper objectMapper = new ObjectMapper();
                    try {
                        logger.debug("Channel Data is : {}", (Object)objectMapper.writeValueAsString((Object)data));
                    }
                    catch (Exception e) {
                        logger.error("Error while logging Channel Data: ", (Throwable)e);
                    }
                }
                Arrays.stream(data).filter(row -> "initiator".equals(row.getDirection()) && !"stale".equals(row.getState()) && row.getRingEpoch() != null).forEach(channel -> {
                    String caller = StringUtils.hasText((String)channel.getLocalName()) ? channel.getLocalName() : channel.getLocalUser();
                    String callee = StringUtils.hasText((String)channel.getRemoteName()) ? channel.getRemoteName() : channel.getRemoteUser();
                    long startTime = channel.getRingEpoch() == null ? 0L : channel.getRingEpoch() / 1000L;
                    long answerTime = channel.getAnswerEpoch() == null ? 0L : channel.getAnswerEpoch() / 1000L;
                    String ringDuration = LocalTime.ofSecondOfDay((long)Math.floor((channel.getAnswerEpoch() == null || channel.getAnswerEpoch() == 0L ? currentTimestamp : channel.getAnswerEpoch() / 1000L) - startTime)).toString();
                    String callDuration = LocalTime.ofSecondOfDay((long)Math.floor(currentTimestamp - startTime)).toString();
                    String callType = channel.getCoralInboundGateway() != null || channel.getCoralInboundGatewayName() != null || channel.getCoralGatewayName() != null ? "Trunk" : "Internal";
                    String callerIpAddress = null;
                    String calleeIpAddress = null;
                    if (channel.getEntity().contains("user")) {
                        callerIpAddress = StringUtils.hasText((String)channel.getInternalIpAddress()) ? channel.getInternalIpAddress() : channel.getTrunkIpAddress();
                        calleeIpAddress = StringUtils.hasText((String)channel.getTrunkIpAddress()) ? channel.getTrunkIpAddress() : channel.getInternalIpAddress();
                    } else {
                        callerIpAddress = StringUtils.hasText((String)channel.getTrunkIpAddress()) ? channel.getTrunkIpAddress() : channel.getInternalIpAddress();
                        calleeIpAddress = StringUtils.hasText((String)channel.getInternalIpAddress()) ? channel.getInternalIpAddress() : channel.getTrunkIpAddress();
                    }
                    callerIpAddress = this.removePort(callerIpAddress);
                    calleeIpAddress = this.removePort(calleeIpAddress);
                    returnValue.add(new ChannelActiveCallsModel(caller, callee, Long.valueOf(startTime), Long.valueOf(answerTime), ringDuration, callDuration, "", "", callerIpAddress, calleeIpAddress, callType));
                });
                logger.info("Fetched {} active calls", (Object)returnValue.size());
            }
            catch (Exception e) {
                logger.error("Error while retrieving Channel Active Calls List : {} {} {}", (Object)callServerURL, (Object)e.getMessage(), (Object)e);
            }
            return returnValue;
        }
        return returnValue;
    }

    private String removePort(String ip) {
        if (StringUtils.hasText((String)ip)) {
            return ip.split(":")[0];
        }
        return "";
    }

    public RequestResponse fetchChannelActiveBandWidthDetails(String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        List activeCallList = this.fetchChannelActiveCallData(widgetCode);
        ArrayList<GraphDataPointModel> lstValue = new ArrayList<GraphDataPointModel>();
        if (activeCallList.isEmpty()) {
            logger.info("Active Calls list is empty");
            lstValue.add(new GraphDataPointModel("Total Calls", Double.valueOf(0.0), null, null, "call_received", Boolean.valueOf(false)));
            lstValue.add(new GraphDataPointModel("BandWidth Utilized (MB)", Double.valueOf(0.0), null, null, "call_received", Boolean.valueOf(false)));
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("Active Calls bandWidth Data Response.");
            returnValue.setData(lstValue);
            return returnValue;
        }
        logger.info("Computing BandWidth  of Active Calls.");
        int totalCalls = activeCallList.size();
        double bandwidthUtilization = (double)totalCalls * 190.4 * this.randomMultiplier() / 1024.0;
        lstValue.add(new GraphDataPointModel("Total Calls", Double.valueOf(totalCalls), null, null, "call_received", Boolean.valueOf(false)));
        lstValue.add(new GraphDataPointModel("BandWidth Utilized (MB)", Double.valueOf(bandwidthUtilization), null, null, "call_received", Boolean.valueOf(false)));
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Active Calls bandWidth Data Response.");
        returnValue.setData(lstValue);
        return returnValue;
    }

    private double randomMultiplier() {
        return ThreadLocalRandom.current().nextDouble(0.9, 1.15);
    }
}

