/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.component.service.FieldMonitorService;
import com.coraltele.telemetry.component.service.PresenceAggregatorService;
import com.coraltele.telemetry.condition.EnableSubscriberMonitoring;
import com.coraltele.telemetry.helper.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableSubscriberMonitoring.class})
public class SubscriberMonitorProcess {
    private static final Logger logger = LoggerFactory.getLogger(SubscriberMonitorProcess.class);
    @Autowired
    private PresenceAggregatorService presenceAggregatorService;
    @Autowired
    private FieldMonitorService fieldMonitorService;

    @Scheduled(fixedRateString="#{T(com.coraltele.telemetry.helper.Constants).SUBSCRIBER_ALERTS_MONITOR_INTERVAL}")
    public void runAlertChecks() {
        logger.info("Running subscriber alert checks... {}", (Object)Constants.SUBSCRIBER_ALERTS_MONITOR_INTERVAL);
        if (Constants.SUBSCRIBER_ALERTS_PRESENCE_ENABLED) {
            try {
                this.presenceAggregatorService.checkPresence();
            }
            catch (Exception e) {
                logger.error("Error during presence aggregation check", (Throwable)e);
            }
        }
        if (Constants.SUBSCRIBER_ALERTS_FIELD_MONITOR_ENABLED) {
            try {
                this.fieldMonitorService.monitorFields();
            }
            catch (Exception e) {
                logger.error("Error during field monitoring check", (Throwable)e);
            }
        }
        logger.info("Finished subscriber alert checks.");
    }
}

