/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.service;

import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.UserCoordinate;
import com.coraltele.telemetry.db.telemetry.main.entity.UserZone;
import com.coraltele.telemetry.db.telemetry.main.repository.UserCoordinateRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.UserZoneRepository;
import com.coraltele.telemetry.db.telephony.billing.entity.Department;
import com.coraltele.telemetry.db.telephony.billing.repository.DepartmentRepository;
import com.coraltele.telemetry.db.telephony.entity.LocationInSwitch;
import com.coraltele.telemetry.db.telephony.main.entity.McxParticipant;
import com.coraltele.telemetry.db.telephony.main.entity.SipRegistrations;
import com.coraltele.telemetry.db.telephony.main.repository.McxParticipantRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.telemetry.db.telephony.repository.LocationInSwitchRepository;
import com.coraltele.telemetry.db.telephony.repository.SipRegistrationRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.geospatial.TagModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.IMSIDataModel;
import com.coraltele.telemetry.service.pbx.ExtensionService;
import com.coraltele.telemetry.service.user.service.UserService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UserCoordinateService {
    private static final Logger logger = LogManager.getLogger(UserCoordinateService.class);
    @Autowired
    UserService userService;
    @Autowired
    UserCoordinateRepository userCoordinateRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    ExtensionService extensionService;
    @Autowired
    UserZoneRepository userZoneRepository;
    @Autowired
    IMSIRepository imsiRepository;
    @Autowired
    DepartmentRepository departmentRepository;
    @Autowired
    SipRegistrationRepository sipRegistrationRepository;
    @Autowired
    LocationInSwitchRepository locationRepository;
    @Autowired
    McxParticipantRepository mcxParticipantRepository;

    public UserCoordinate getUserCoordinateData(String username) {
        try {
            List userCoordinates = this.userCoordinateRepository.findByUsername(username);
            if (!userCoordinates.isEmpty()) {
                return (UserCoordinate)userCoordinates.get(0);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Error fetching UserCoordinate by user: " + username, (Throwable)e);
            return null;
        }
    }

    public boolean checkUserExist(String username) {
        return this.userCoordinateRepository.existsByUsername(username);
    }

    public void createUser(String name) {
        Extension extData;
        UserCoordinate data = new UserCoordinate();
        if (this.userService.getContactNumber(name) != null && (extData = this.getExtensionDetail(this.userService.getContactNumber(name))) != null) {
            data.setDepartment(extData.getDepartment());
            data.setZone(extData.getZone());
        }
        data.setUsername(name);
        data.setExtensionNumber(this.userService.getContactNumber(name));
        data.setGeoX("0");
        data.setGeoY("0");
        data.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
        data.setUpdatedOn(Long.valueOf(Instant.now().getEpochSecond()));
        this.userCoordinateRepository.save((Object)data);
    }

    public void updateUserCoordinate(String username, String lat, String lang, Long updatedEpoch, String updatedBy, String extension, Integer batteryPercentage, String deviceId, Integer sim1, Integer sim2) {
        block8: {
            try {
                List getUserCoordinate = this.userCoordinateRepository.findByUsername(username);
                if (!getUserCoordinate.isEmpty()) {
                    for (UserCoordinate userCoordinate : getUserCoordinate) {
                        if (Boolean.FALSE.equals(Constants.DISABLE_IMSI_LOCATION_UPDATE)) {
                            userCoordinate.setGeoX(lat);
                            userCoordinate.setGeoY(lang);
                        }
                        userCoordinate.setUpdatedOn(updatedEpoch);
                        userCoordinate.setUpdatedBy(updatedBy);
                        userCoordinate.setBatteryPercentage(batteryPercentage);
                        userCoordinate.setDeviceId(deviceId);
                        userCoordinate.setRsRpSim1(sim1);
                        userCoordinate.setRsRpSim2(sim2);
                        try {
                            if (extension != null && this.getExtensionDetail(extension) != null) {
                                String currentZone = this.updateExtensionZone(lat, lang, extension);
                                userCoordinate.setZone(currentZone);
                            }
                        }
                        catch (Exception e) {
                            logger.error("Unable to update zone and department");
                        }
                        this.userCoordinateRepository.save((Object)userCoordinate);
                        logger.info("UserCoordinate updated successfully for user: {}", (Object)username);
                    }
                    break block8;
                }
                logger.error("No record found for user: {}", (Object)username);
            }
            catch (Exception e) {
                logger.error("Error while updating userCoordinate data for user: {}", (Object)username, (Object)e);
            }
        }
    }

    public Long getLastCoordinateUpdate(String username) {
        try {
            List getUserCoordinate = this.userCoordinateRepository.findByUsername(username);
            if (!getUserCoordinate.isEmpty()) {
                return ((UserCoordinate)getUserCoordinate.get(0)).getUpdatedOn();
            }
            return 0L;
        }
        catch (Exception e) {
            logger.error("Error retrieving last coordinate time of user: {}", (Object)username, (Object)e);
            return 0L;
        }
    }

    public UserCoordinate getUserCoordinate(String username) {
        List userData = this.userCoordinateRepository.findByUsername(username);
        if (!userData.isEmpty()) {
            return (UserCoordinate)userData.get(0);
        }
        return null;
    }

    public RequestResponse getGeoTagList(String value) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TagModel> data = new ArrayList<TagModel>();
        List userCoordinateList = this.userCoordinateRepository.findAll();
        HashSet<String> uniqueUsernames = new HashSet<String>();
        for (UserCoordinate userCoordinate : userCoordinateList) {
            String department = userCoordinate.getDepartment();
            String departmentColor = "";
            TagModel row = new TagModel();
            if (department != null) {
                departmentColor = this.getColorOfDepartment(department);
                row.setDepartmentPriority(this.getPriorityOfDepartment(department));
            }
            row.setUserCoordinateId(userCoordinate.getId());
            row.setTagType("imsi");
            row.setName(String.format("%s - %s", userCoordinate.getUsername(), userCoordinate.getExtensionNumber()));
            row.setExtensionNumber(userCoordinate.getExtensionNumber());
            row.setGeoX(userCoordinate.getGeoX());
            row.setGeoY(userCoordinate.getGeoY());
            row.setStatus(userCoordinate.getConnected());
            row.setEmergencyStatus(userCoordinate.getEmergencyStatus());
            row.setZone(userCoordinate.getZone());
            row.setDepartment(userCoordinate.getDepartment());
            row.setDesignation(this.extensionService.getDesignation(row.getExtensionNumber()));
            row.setDeviceId(userCoordinate.getDeviceId());
            row.setBatteryPercentage(userCoordinate.getBatteryPercentage());
            row.setRsRpSim1(userCoordinate.getRsRpSim1());
            row.setRsRpSim2(userCoordinate.getRsRpSim2());
            row.setUpdatedOn(userCoordinate.getUpdatedOn());
            if (this.getRegisteredExtension().contains(userCoordinate.getExtensionNumber())) {
                row.setRegistered(true);
            } else {
                row.setRegistered(false);
            }
            if (userCoordinate.getCreatedOn() != null) {
                row.setCreatedOn(userCoordinate.getEmergencyCreatedOn());
            }
            row.setDeviceType(userCoordinate.getDeviceType());
            if (userCoordinate.getData() != null && !userCoordinate.getData().isEmpty()) {
                try {
                    ObjectMapper om = new ObjectMapper();
                    IMSIDataModel imsiData = (IMSIDataModel)om.readValue(userCoordinate.getData(), IMSIDataModel.class);
                    row.setData((Object)imsiData);
                }
                catch (Exception om) {
                    // empty catch block
                }
            }
            List registeredExtensions = this.getRegisteredExtension();
            if (!StringUtils.hasText((String)userCoordinate.getUsername()) || !uniqueUsernames.add(userCoordinate.getUsername())) continue;
            if (userCoordinate.getExtensionNumber() != null && StringUtils.hasText((String)userCoordinate.getExtensionNumber())) {
                row.setUserName(row.getUserName());
            }
            if (!registeredExtensions.contains(userCoordinate.getExtensionNumber())) continue;
            if ("default".equals(value)) {
                if (!StringUtils.hasLength((String)row.getDepartmentPriority())) continue;
                data.add(row);
                continue;
            }
            if (department == null || !value.equals(department)) continue;
            data.add(row);
        }
        returnValue.setData(data);
        return returnValue;
    }

    public Extension getExtensionDetail(String extension) {
        Optional extensionData = this.extensionsRepository.findByExtension(extension);
        if (extensionData.isPresent()) {
            return (Extension)extensionData.get();
        }
        return null;
    }

    public void updateExtension(String userLatitude, String userLongitude, String extension) {
        double latitude = Double.parseDouble(userLatitude);
        double longitude = Double.parseDouble(userLongitude);
        List zoneList = this.userZoneRepository.findAll();
        if (!zoneList.isEmpty()) {
            GeometryFactory geometryFactory = new GeometryFactory();
            boolean isUpdated = false;
            for (UserZone zone : zoneList) {
                Optional extensionData;
                Point userPoint;
                if (zone.getCoordinate() == null) continue;
                ArrayList<Coordinate> areaCoordinates = new ArrayList<Coordinate>();
                for (Coordinate coordinate : zone.getCoordinate().getCoordinates()) {
                    areaCoordinates.add(new Coordinate(coordinate.x, coordinate.y));
                }
                Polygon zonePolygon = geometryFactory.createPolygon(areaCoordinates.toArray(new Coordinate[0]));
                if (!zonePolygon.contains((Geometry)(userPoint = geometryFactory.createPoint(new Coordinate(longitude, latitude)))) || !(extensionData = this.extensionsRepository.findByExtension(extension)).isPresent()) continue;
                ((Extension)extensionData.get()).setZone(zone.getName());
                this.extensionsRepository.save(extensionData.get());
                isUpdated = true;
                logger.info("User's location matches zone: " + zone.getName() + ". Extension updated.");
                break;
            }
            if (!isUpdated) {
                logger.info("No zone found for the given location. Extension not updated.");
            }
        } else {
            logger.error("No zones available in the database.");
        }
    }

    public String updateExtensionZone(String userLatitude, String userLongitude, String extension) {
        double latitude = Double.parseDouble(userLatitude);
        double longitude = Double.parseDouble(userLongitude);
        List zoneList = this.userZoneRepository.findAll();
        if (!zoneList.isEmpty()) {
            GeometryFactory geometryFactory = new GeometryFactory();
            boolean isUpdated = false;
            for (UserZone zone : zoneList) {
                Optional extensionData;
                Point userPoint;
                if (zone.getCoordinate() == null) continue;
                ArrayList<Coordinate> areaCoordinates = new ArrayList<Coordinate>();
                for (Coordinate coordinate : zone.getCoordinate().getCoordinates()) {
                    areaCoordinates.add(new Coordinate(coordinate.x, coordinate.y));
                }
                Polygon zonePolygon = geometryFactory.createPolygon(areaCoordinates.toArray(new Coordinate[0]));
                if (!zonePolygon.contains((Geometry)(userPoint = geometryFactory.createPoint(new Coordinate(longitude, latitude)))) || !(extensionData = this.extensionsRepository.findByExtension(extension)).isPresent()) continue;
                ((Extension)extensionData.get()).setZone(zone.getName());
                this.extensionsRepository.save(extensionData.get());
                isUpdated = true;
                logger.info("User's location matches zone: " + zone.getName() + ". Extension updated.");
                return zone.getName();
            }
            if (!isUpdated) {
                logger.info("No zone found for the given location. Extension not updated.");
            }
        } else {
            logger.error("No zones available in the database.");
        }
        return "";
    }

    public String getColorOfDepartment(String department) {
        List departmentColor = this.departmentRepository.findByDescriptionOrderByIdDesc(department);
        if (!departmentColor.isEmpty()) {
            Department data = (Department)departmentColor.get(0);
            if (data.getColor() != null) {
                return data.getColor();
            }
            return "";
        }
        return "";
    }

    public String getPriorityOfDepartment(String department) {
        List departmentColor = this.departmentRepository.findByDescriptionOrderByIdDesc(department);
        if (!departmentColor.isEmpty()) {
            Department data = (Department)departmentColor.get(0);
            if (data.getDepartmentPriority() != null) {
                return data.getDepartmentPriority();
            }
            return "";
        }
        return "";
    }

    public List<String> getRegisteredExtension() {
        if (Constants.CONFERENCE_PROVIDER == 4) {
            return this.mcxParticipantRepository.findByKeepAliveEpochGreaterThan(Instant.now().getEpochSecond() - (long)Constants.PARTICIPANT_KEEP_ALIVE_EXPIRE_PERIOD.intValue()).stream().map(McxParticipant::getParticipantNo).collect(Collectors.toList());
        }
        List locationUsers = this.locationRepository.findAll().stream().map(LocationInSwitch::getUsername).collect(Collectors.toList());
        List sipUsers = this.sipRegistrationRepository.findAll().stream().map(SipRegistrations::getSipUser).collect(Collectors.toList());
        Set distinctUsers = Stream.concat(locationUsers.stream(), sipUsers.stream()).collect(Collectors.toSet());
        return distinctUsers.stream().collect(Collectors.toList());
    }
}

