/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.outage.controller;

import com.coraltele.telemetry.db.telemetry.coralnms.repository.OutageRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/outage"})
@RestController
public class OutageController {
    @Autowired
    OutageRepository dataRepository;

    @GetMapping(value={"/list"})
    public ResponseEntity<RequestResponse> list() {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List data = this.dataRepository.findAll();
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/summary/all"})
    public ResponseEntity<RequestResponse> getOutageSummary() {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List data = this.dataRepository.categoryCountAll();
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/summary/pending"})
    public ResponseEntity<RequestResponse> getOutageSummaryPending() {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List data = this.dataRepository.categoryCountPending();
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/summary/calendar/{from}/{to}"})
    public ResponseEntity<RequestResponse> getOutageCalendar(@PathVariable(value="from") String fromDate, @PathVariable(value="to") String toDate) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List data = this.dataRepository.calendarOutput(fromDate, toDate);
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

