/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import java.beans.PropertyDescriptor;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Component;

@Component
public class SpringHelper
implements ApplicationContextAware {
    private static ApplicationContext context;
    @Autowired
    @Qualifier(value="telemetryEntityManagerFactory")
    public static EntityManager telemetryEntityManager;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static <T> T getBean(Class<T> beanClass) {
        return (T)context.getBean(beanClass);
    }

    public static Object getBean(String beanName) {
        return context.getBean(beanName);
    }

    public static <T> JpaRepository<T, ?> getRepository(Class<T> entityClass) {
        String repositoryBeanName = entityClass.getSimpleName() + "Repository";
        repositoryBeanName = Character.toLowerCase(repositoryBeanName.charAt(0)) + repositoryBeanName.substring(1);
        try {
            return (JpaRepository)context.getBean(repositoryBeanName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("No repository bean found for name: " + repositoryBeanName, e);
        }
    }

    public static void copyAllPropertiesExcept(Object source, Object target, List<String> excludedFields) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        BeanWrapperImpl trg = new BeanWrapperImpl(target);
        for (PropertyDescriptor propertyDescriptor : src.getPropertyDescriptors()) {
            String propName = propertyDescriptor.getName();
            if ("class".equals(propName) || excludedFields.contains(propName)) continue;
            Object value = src.getPropertyValue(propName);
            trg.setPropertyValue(propName, value);
        }
    }
}

