/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.coralapps.entity.AgentRealTime;
import com.coraltele.telemetry.db.coralapps.entity.RealTimeQueueCall;
import com.coraltele.telemetry.db.coralapps.repository.AgentRealTimeRepository;
import com.coraltele.telemetry.db.coralapps.repository.RealTimeQueueCallRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.QueuePerformance;
import com.coraltele.telemetry.db.telemetry.main.repository.QueuePerformanceRepository;
import com.coraltele.telemetry.helper.DateFormatUtility;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.ACDAgentSummaryModel;
import com.coraltele.telemetry.model.AgentRealTimeModel;
import com.coraltele.telemetry.model.GraphDataPointModel;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ACDRealTimeService {
    private static final Logger logger = LogManager.getLogger(ACDRealTimeService.class);
    @Autowired
    private AgentRealTimeRepository agentRealTimeRepository;
    @Autowired
    private QueuePerformanceRepository queuePerformanceRepository;
    @Autowired
    private RealTimeQueueCallRepository realTimeQueueCallRepository;
    @Autowired
    private DateFormatUtility dateFormatUtility;

    public List<AgentRealTimeModel> getAgentRealTime() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        Long epochCurrentTimestamp = currentDateTime.atZone(ZoneOffset.UTC).toEpochSecond();
        ArrayList<AgentRealTimeModel> returnValue = new ArrayList<AgentRealTimeModel>();
        List list = this.agentRealTimeRepository.findAllByOrderByQueueNameAscFullNameAsc();
        for (AgentRealTime agent : list) {
            try {
                AgentRealTimeModel data = new AgentRealTimeModel();
                data.setQueueName(agent.getQueueName() != null ? agent.getQueueName() : " ");
                data.setTierState(agent.getTierState() != null ? agent.getTierState() : " ");
                data.setAgent(agent.getAgentRealTimeKey().getAgent() != null ? agent.getAgentRealTimeKey().getAgent() : " ");
                data.setFullName(agent.getFullName() != null ? agent.getFullName() : "");
                data.setLiveState(agent.getLiveState() != null ? agent.getLiveState() : " ");
                data.setContactNumber(agent.getContactNumber() != null ? agent.getContactNumber() : "");
                data.setTalkingTo(agent.getTalkingTo() != null ? agent.getTalkingTo() : "");
                data.setSessionUuid(StringUtils.hasText((String)agent.getSessionUuid()) ? agent.getSessionUuid() : "");
                if (agent.getLastDateTime() != null) {
                    LocalDateTime lastDateTime = agent.getLastDateTime();
                    Long epochLastDateTime = lastDateTime.toEpochSecond(ZoneOffset.UTC);
                    LocalDateTime currentTime = LocalDateTime.ofEpochSecond(epochCurrentTimestamp, 0, ZoneOffset.UTC);
                    LocalDateTime changedStateTime = LocalDateTime.ofEpochSecond(epochLastDateTime, 0, ZoneOffset.UTC);
                    Duration duration = Duration.between(changedStateTime, currentTime);
                    data.setLastDateTime(this.dateFormatUtility.formatDuration(duration.getSeconds()));
                } else {
                    data.setLastDateTime("00:00:00");
                }
                data.setLastOfferedCall(agent.getLastOfferedCall() != null ? agent.getLastOfferedCall() : " ");
                data.setMemberState(agent.getMemberState() != null ? agent.getMemberState() : "");
                data.setAgentStatus(agent.getAgentStatus() != null ? agent.getAgentStatus() : " ");
                data.setAgentState(agent.getAgentState() != null ? agent.getAgentState() : "");
                data.setLoggedIn(Integer.valueOf(agent.getLoggedIn() != null ? agent.getLoggedIn() : 0));
                data.setOnBreak(Integer.valueOf(agent.getOnBreak() != null ? agent.getOnBreak() : 0));
                data.setLastBridgeEnd(agent.getLastBridgeEnd() != null ? agent.getLastBridgeEnd() : " ");
                returnValue.add(data);
            }
            catch (Exception e) {
                logger.error("Unable to compute record for agent : {} ", (Object)agent.getAgentRealTimeKey().getAgent());
                logger.error("{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return returnValue;
    }

    public RequestResponse getAllInBound() {
        Long epochTimestamp = this.dateFormatUtility.getMidNightEpochFromDateTime(LocalDateTime.now());
        ArrayList<GraphDataPointModel> lstValue = new ArrayList<GraphDataPointModel>();
        List lstQueuePerformance = this.queuePerformanceRepository.findByQueuePerformanceCompositeKeyCallDirectionAndQueuePerformanceCompositeKeyRecordEpoch("IN", epochTimestamp);
        RequestResponse returnValue = new RequestResponse();
        logger.info("InBound Data is ---{}", (Object)lstQueuePerformance);
        if (lstQueuePerformance.isEmpty()) {
            logger.info("the value of call direction record is empty");
            lstValue.add(new GraphDataPointModel("Received", Double.valueOf(0.0), null, null, "call_received", Boolean.valueOf(false)));
            lstValue.add(new GraphDataPointModel("Answered", Double.valueOf(0.0), null, null, "phone", Boolean.valueOf(false)));
            lstValue.add(new GraphDataPointModel("ABD Agent", Double.valueOf(0.0), null, null, "call_end", Boolean.valueOf(false)));
            lstValue.add(new GraphDataPointModel("ABD Queue", Double.valueOf(0.0), null, null, "call_end", Boolean.valueOf(false)));
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("InBound Data Response.");
            returnValue.setData(lstValue);
            return returnValue;
        }
        int totalAbandonedAtAgent = 0;
        int totalAnswered = 0;
        int totalJoined = 0;
        int totalAbandonedAtQueue = 0;
        for (QueuePerformance queuePerformance : lstQueuePerformance) {
            if (queuePerformance.getQueueName().startsWith("operator")) continue;
            totalAbandonedAtAgent += queuePerformance.getTotalAbandonedAtAgent() == null ? 0 : queuePerformance.getTotalAbandonedAtAgent();
            totalAnswered += queuePerformance.getTotalConnectedWithAgent() == null ? 0 : queuePerformance.getTotalConnectedWithAgent();
            totalJoined += queuePerformance.getTotalJoined() == null ? 0 : queuePerformance.getTotalJoined();
            totalAbandonedAtQueue += queuePerformance.getTotalAbandonedAtQueue() == null ? 0 : queuePerformance.getTotalAbandonedAtQueue();
        }
        lstValue.add(new GraphDataPointModel("Received", Double.valueOf(totalJoined), null, null, "call_received", Boolean.valueOf(false)));
        lstValue.add(new GraphDataPointModel("Answered", Double.valueOf(totalAnswered), null, null, "phone", Boolean.valueOf(false)));
        lstValue.add(new GraphDataPointModel("ABD Agent", Double.valueOf(totalAbandonedAtAgent), null, null, "call_end", Boolean.valueOf(false)));
        lstValue.add(new GraphDataPointModel("ABD Queue", Double.valueOf(totalAbandonedAtQueue), null, null, "call_end", Boolean.valueOf(false)));
        logger.info("the values are {}, {}, {}, {}", (Object)totalAnswered, (Object)totalJoined, (Object)totalAbandonedAtAgent, (Object)totalAbandonedAtQueue);
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("InBound Data Response.");
        returnValue.setData(lstValue);
        return returnValue;
    }

    public RequestResponse getAllOutBound() {
        Long epochTimestamp = this.dateFormatUtility.getMidNightEpochFromDateTime(LocalDateTime.now());
        ArrayList<GraphDataPointModel> lstValue = new ArrayList<GraphDataPointModel>();
        List lstQueuePerformance = this.queuePerformanceRepository.findByQueuePerformanceCompositeKeyCallDirectionAndQueuePerformanceCompositeKeyRecordEpoch("OUT", epochTimestamp);
        RequestResponse returnValue = new RequestResponse();
        if (lstQueuePerformance.isEmpty()) {
            logger.info("the value of call direction record is empty");
            lstValue.add(new GraphDataPointModel("Dialed", Double.valueOf(0.0), null, null, "arrow_outward", Boolean.valueOf(false)));
            lstValue.add(new GraphDataPointModel("Contacted", Double.valueOf(0.0), null, null, "phone", Boolean.valueOf(false)));
            lstValue.add(new GraphDataPointModel("Not Contacted", Double.valueOf(0.0), null, null, "call_end", Boolean.valueOf(false)));
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("OutBound Data Response.");
            returnValue.setData(lstValue);
            return returnValue;
        }
        int totalDialed = 0;
        int totalContact = 0;
        int totalNoContact = 0;
        for (QueuePerformance queuePerformance : lstQueuePerformance) {
            if (queuePerformance.getQueueName().startsWith("operator")) continue;
            totalContact += queuePerformance.getTotalConnectedWithAgent() == null ? 0 : queuePerformance.getTotalConnectedWithAgent();
            totalDialed += queuePerformance.getTotalJoined() == null ? 0 : queuePerformance.getTotalJoined();
            totalNoContact += queuePerformance.getTotalNoContact() == null ? 0 : queuePerformance.getTotalNoContact();
        }
        lstValue.add(new GraphDataPointModel("Dialed", Double.valueOf(totalDialed), null, null, "arrow_outward", Boolean.valueOf(false)));
        lstValue.add(new GraphDataPointModel("Contact", Double.valueOf(totalContact), null, null, "phone", Boolean.valueOf(false)));
        lstValue.add(new GraphDataPointModel("No Contact", Double.valueOf(totalNoContact), null, null, "call_end", Boolean.valueOf(false)));
        logger.info("the values are {}, {}, {}", (Object)totalDialed, (Object)totalContact, (Object)totalNoContact);
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("OutBound Data Response.");
        returnValue.setData(lstValue);
        return returnValue;
    }

    public RequestResponse getAllAgentRealTimeData() {
        HashMap<String, ACDAgentSummaryModel> acdSummary = new HashMap<String, ACDAgentSummaryModel>();
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        ArrayList queueCalls = new ArrayList();
        this.realTimeQueueCallRepository.findAll().forEach(queueCalls::add);
        Map<String, Integer> onQueueMap = queueCalls.stream().collect(Collectors.toMap(RealTimeQueueCall::getQueue, RealTimeQueueCall::getCallOnQueue));
        List allAgentRealTime = this.agentRealTimeRepository.findAllByOrderByQueueNameAscFullNameAsc();
        for (AgentRealTime agentRealTime : allAgentRealTime) {
            String queue;
            ACDAgentSummaryModel data = null;
            String string = queue = agentRealTime.getAgentRealTimeKey().getQueue() != null ? agentRealTime.getAgentRealTimeKey().getQueue() : "";
            if (acdSummary.containsKey(queue)) {
                data = (ACDAgentSummaryModel)acdSummary.get(queue);
            } else {
                data = new ACDAgentSummaryModel();
                data.setQueue(agentRealTime.getAgentRealTimeKey().getQueue() != null ? agentRealTime.getAgentRealTimeKey().getQueue() : "");
                data.setQueueName(agentRealTime.getQueueName() != null ? agentRealTime.getQueueName() : "");
                data.setAgentLogin(Integer.valueOf(0));
                data.setOnBreak(Integer.valueOf(0));
                data.setAcw(Integer.valueOf(0));
                data.setIdle(Integer.valueOf(0));
                data.setLogout(Integer.valueOf(0));
                data.setOnCall(Integer.valueOf(0));
                data.setRing(Integer.valueOf(0));
                data.setNtc(Integer.valueOf(0));
                data.setOnQueue(onQueueMap.getOrDefault(queue, 0));
                acdSummary.put(data.getQueue(), data);
            }
            data.setAgentLogin(Integer.valueOf(data.getAgentLogin() + (agentRealTime.getLoggedIn() == 1 ? 1 : 0)));
            data.setOnBreak(Integer.valueOf(data.getOnBreak() + (agentRealTime.getOnBreak() == 1 ? 1 : 0)));
            data.setAcw(Integer.valueOf(data.getAcw() + (agentRealTime.getLiveState().equals("ACW") ? 1 : 0)));
            data.setIdle(Integer.valueOf(data.getIdle() + (agentRealTime.getLiveState().equals("Idle") ? 1 : 0)));
            data.setLogout(Integer.valueOf(data.getLogout() + (agentRealTime.getLiveState().equals("Log Out") ? 1 : 0)));
            data.setOnCall(Integer.valueOf(data.getOnCall() + (agentRealTime.getLiveState().equals("Talk") ? 1 : 0)));
            data.setNtc(Integer.valueOf(data.getNtc() + (agentRealTime.getLiveState().equals("NTC") ? 1 : 0)));
            data.setRing(Integer.valueOf(data.getRing() + (agentRealTime.getLiveState().equals("Ring") ? 1 : 0)));
        }
        for (Map.Entry entry : acdSummary.entrySet()) {
            addValue.add(entry.getValue());
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("created successfully");
        returnValue.setData(addValue);
        return returnValue;
    }
}

