/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnableUpdateExtensionStatusProcess;
import com.coraltele.telemetry.db.telemetry.main.repository.RegistrationAlertRepository;
import com.coraltele.telemetry.thread.UpdateExtensionStatusThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableUpdateExtensionStatusProcess.class})
public class UpdateExtensionStatusProcess {
    private static final Logger logger = LogManager.getLogger(UpdateExtensionStatusProcess.class);
    @Autowired
    private RegistrationAlertRepository registrationAlertRepository;
    private static final Integer MAX_THREADS = 1;
    ExecutorService threadPool = Executors.newFixedThreadPool(MAX_THREADS);

    @Scheduled(fixedRate=5000L)
    public void startCounterCollection() {
        logger.info("Maximum Threads: {}, Active Threads: {}", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting Update Extension Status Alert Thread");
            this.threadPool.execute((Runnable)new UpdateExtensionStatusThread(this.registrationAlertRepository));
        }
        logger.info("{} Update Extension Status Threads started", (Object)threadsStarted);
    }
}

