/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.component.service.SystemAlertGenerate;
import com.coraltele.telemetry.helper.SystemHealthHelper;
import com.coraltele.telemetry.thread.SystemHealthMonitorThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class SystemHealthMonitorProcess {
    private static final Logger logger = LogManager.getLogger(SystemHealthMonitorProcess.class);
    private static final Integer MAX_THREADS = 1;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);
    @Autowired
    private SystemHealthHelper systemHealthHelper;
    @Autowired
    private SystemAlertGenerate systemAlertGenerate;

    @Scheduled(fixedRate=10000L)
    public void startHealthCheck() throws InterruptedException {
        logger.info("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting System Health  Monitoring");
            this.threadPool.execute((Runnable)new SystemHealthMonitorThread(this.systemHealthHelper, this.systemAlertGenerate));
        }
        logger.info("{} Threads started", (Object)threadsStarted);
    }
}

