/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry;

import com.coraltele.telemetry.helper.Bootstrap;
import com.coraltele.telemetry.helper.Constants;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.IniPreferences;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableScheduling
public class TelemetryApplication {
    private static final Logger logger = LogManager.getLogger(TelemetryApplication.class);
    private static final String EMAIL_SECTION = "EMAIL";
    private static final String SMS_SECTION = "SMS";
    private static final String CLUSTER_SECTION = "CLUSTER";
    private static final String NMS_SECTION = "NMS";
    private static final String LDAP_SECTION = "LDAP";
    private static final String TR069_SECTION = "TR069";
    private static final String RECORDING_SECTION = "RECORDING-SERVER";
    private static final String BANDWIDTH_SECTION = "BANDWIDTH";
    private static final String COUNTER_SECTION = "COUNTER";
    private static final String TASK_SECTION = "TASK";
    private static final String MAP_SECTION = "MAP";
    private static final String PPDR_CONFERENCE_SECTION = "PPDR-CONFERENCE";
    private static final String SUBSCRIBER_ALERTS_SECTION = "SUBSCRIBER-ALERTS";
    private static final String SNMP_AGENT_SECTION = "SNMP-AGENT";

    public static void main(String[] args) {
        try {
            InetAddress id = InetAddress.getLocalHost();
            Constants.hostName = id.getHostName();
            logger.info("Current Machine hostname : {}", (Object)Constants.hostName);
        }
        catch (UnknownHostException e) {
            logger.error("Unable to get hostname", (Throwable)e);
        }
        Bootstrap.checkTelemetryDatabase();
        Bootstrap.createCoralNMSSchema(null, (String)"tables");
        Bootstrap.createSwitchSchemas(null, (String)"tables");
        Bootstrap.createCoralAppsSchemas(null, (String)"tables");
        logger.info("Starting Telemetry gateway.");
        TelemetryApplication.readProperties();
        SpringApplication app = new SpringApplication(new Class[]{TelemetryApplication.class});
        try {
            ConfigurableApplicationContext ctx = app.run(args);
            ctx.registerShutdownHook();
        }
        catch (Throwable ex) {
            System.err.println("Application failed to start: " + ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        TelemetryApplication.logAllConfigurations();
        Bootstrap.deployFiles();
    }

    private static void logAllConfigurations() {
        logger.info("============================ Configuration Values : Start ============================");
        String scadaServers = String.join((CharSequence)",", Constants.getScadaServers());
        logger.info("DEFAULT ==> HOSTNAME : {}", (Object)Constants.hostName);
        logger.info("DEFAULT ==> ACTIVEMQ-IP-ADDRESS : {}", (Object)Constants.ACTIVEMQ_IP_ADDRESS);
        logger.info("CLUSTER ==> CLUSTER-KEY : {}", (Object)Constants.CLUSTER_KEY);
        logger.info("CLUSTER ==> NODE-MODE : {}", (Object)Constants.NODE_MODE);
        logger.info("CLUSTER ==> CLUSTER-SSL-ENABLED : {}", (Object)Constants.CLUSTER_SSL_ENABLED);
        logger.info("CLUSTER ==> WEBSOCKET-KEY : {}", (Object)Constants.WEBSOCKET_KEY);
        logger.info("CLUSTER ==> CLUSTER-AUDIT-LOG-ENABLED : {}", (Object)Constants.CLUSTER_AUDIT_LOG_ENABLED);
        logger.info("CLUSTER ==> SEND-CHANNELS-DATA-IN-VOICE-LOGGER : {}", (Object)Constants.SEND_CHANNELS_DATA_IN_VOICE_LOGGER);
        logger.info("CLUSTER ==> SEND-CHANNELS-DATA-IN-BILLING-CDR : {}", (Object)Constants.SEND_CHANNELS_DATA_IN_BILLING_CDR);
        logger.info("CLUSTER ==> SIP-TRUNK-CDR : {}", (Object)Constants.SIP_TRUNK_CDR);
        logger.info("CLUSTER ==> SEND-CDR-DATA-IN-VOICE-LOGGER : {}", (Object)Constants.SEND_CDR_DATA_IN_VOICE_LOGGER);
        logger.info("CLUSTER ==> CLUSTER-CALL-RECORD-DISTRIBUTION : {}", (Object)Constants.CLUSTER_CALL_RECORD_DISTRIBUTION);
        logger.info("CLUSTER ==> BATTERY-RSRP-EXTENSION-UPDATE-IN-SWITCH-DB : {}", (Object)Constants.BATTERY_RSRP_EXTENSION_UPDATE_IN_SWITCH_DB);
        logger.info("CLUSTER ==> TIME-ZONE-FOR-SUMMARY : {}", (Object)Constants.TIME_ZONE_FOR_SUMMARY);
        logger.info("CLUSTER ==> BILLING-ENABLE-THIRD-PARTY-BILLING : {}", (Object)Constants.BILLING_ENABLE_THIRD_PARTY_BILLING);
        logger.info("CLUSTER ==> ENABLE-FREE-SWITCH-ESL-SERVICE : {}", (Object)Constants.ENABLE_FREE_SWITCH_ESL_SERVICE);
        logger.info("NMS ==> PPDR-SOCKET-URL : {}", (Object)Constants.PPDR_SOCKET_URL);
        logger.info("NMS ==> SCADA-SERVERS : {}", (Object)scadaServers);
        logger.info("NMS ==> SCADA-PORT : {}", (Object)Constants.SCADA_PORT);
        logger.info("NMS ==> SNMP-TRAP-RECEIVE-IP : {}", (Object)Constants.SNMP_TRAP_RECEIVE_IP);
        logger.info("NMS ==> SNMP-TRAP-RECEIVE-PORT : {}", (Object)Constants.SNMP_TRAP_RECEIVE_PORT);
        logger.info("NMS ==> SNMP-TRAP-SEND-IP : {}", (Object)Constants.SNMP_TRAP_SEND_SOURCE_IP);
        logger.info("NMS ==> SNMP-TRAP-SEND-PORT : {}", (Object)Constants.SNMP_TRAP_SEND_SOURCE_PORT);
        logger.info("NMS ==> SNMP-EVENT-SEND-URL : {}", (Object)Constants.SNMP_EVENT_SEND_URL);
        logger.info("NMS ==> TELEMETRY-VERSION : {}", (Object)Constants.TELEMETRY_VERSION);
        logger.info("NMS ==> ASSET-SOURCE : {}", (Object)Constants.ASSET_SOURCE);
        logger.info("NMS ==> ENABLE-NMS : {}", (Object)Constants.ENABLE_NMS);
        logger.info("NMS ==> ENABLE-TELEMETRY : {}", (Object)Constants.ENABLE_TELEMETRY);
        logger.info("NMS ==> ENABLE-SNMP : {}", (Object)Constants.ENABLE_SNMP);
        logger.info("NMS ==> ENABLE-PING-CHECK : {}", (Object)Constants.ENABLE_PING_CHECK);
        logger.info("NMS ==> PING-COUNT-FOR-NOT-REACHABLE : {}", (Object)Constants.PING_COUNT_FOR_NOT_REACHABLE);
        logger.info("NMS ==> ENABLE-PING-DISCOVERY : {}", (Object)Constants.ENABLE_PING_DISCOVERY);
        logger.info("NMS ==> ENABLE-MEDIA-GATEWAY-HEALTH-CHECK : {}", (Object)Constants.ENABLE_MEDIA_GATEWAY_HEALTH_CHECK);
        logger.info("NMS ==> SEND-SMS-BY-SERVICE : {}", (Object)Constants.SEND_SMS_BY_SERVICE);
        logger.info("NMS ==> SEND-SMS-BY-CASQ : {}", (Object)Constants.SEND_SMS_BY_CASQ);
        logger.info("NMS ==> REMOTE-NMS-IP : {}", (Object)Constants.REMOTE_NMS_IP);
        logger.info("NMS ==> REMOTE-NMS-PORT : {}", (Object)Constants.REMOTE_NMS_PORT);
        logger.info("NMS ==> ENABLE-REDIS-PUB-SUB : {}", (Object)Constants.ENABLE_REDIS_PUB_SUB);
        logger.info("NMS ==> ENABLE-SCADA-MESSAGE : {}", (Object)Constants.ENABLE_SCADA_MESSAGE);
        logger.info("NMS ==> CENTRAL-NMS-REDIS-IP : {}", (Object)Constants.CENTRAL_NMS_REDIS_IP);
        logger.info("NMS ==> CENTRAL-NMS-REDIS-PORT : {}", (Object)Constants.CENTRAL_NMS_REDIS_PORT);
        logger.info("NMS ==> CENTRAL-NMS-DOMAIN : {}", (Object)Constants.CENTRAL_NMS_DOMAIN);
        logger.info("NMS ==> CENTRAL-NMS-PROTOCOL : {}", (Object)Constants.CENTRAL_NMS_PROTOCOL);
        logger.info("NMS ==> CENTRAL-NMS-THIS-LOCATION : {}", (Object)Constants.CENTRAL_NMS_THIS_LOCATION);
        logger.info("NMS ==> MAXIMUM-NESTING : {}", (Object)Constants.MAXIMUM_NESTING);
        logger.info("NMS ==> WEB-SOCKET-URL : {}", (Object)Constants.WEB_SOCKET_URL);
        logger.info("NMS ==> DISCOVERY-DURATION : {}", (Object)Constants.DISCOVERY_DURATION);
        logger.info("NMS ==> DISCOVERY-TIMEOUT : {}", (Object)Constants.DISCOVERY_TIMEOUT);
        logger.info("NMS ==> ICMP-CHECK-THREADS : {}", (Object)Constants.ICMP_CHECK_THREADS);
        logger.info("NMS ==> IP-COUNT-EACH-THREAD : {}", (Object)Constants.IP_COUNT_EACH_THREAD);
        logger.info("NMS ==> ENABLE-OPEN-NMS-OUTAGES-TO-SCADA : {}", (Object)Constants.ENABLE_OPEN_NMS_OUTAGES_TO_SCADA);
        logger.info("NMS ==> TIME-SERIES-DB-URL: {}", (Object)Constants.TIME_SERIES_DB_URL);
        logger.info("NMS ==> CALL-SERVER-IP: {}", (Object)Constants.CALL_SERVER_IP);
        logger.info("NMS ==> ADDITIONAL-CALL-SERVERS: {}", (Object)Constants.ADDITIONAL_CALL_SERVERS);
        logger.info("NMS ==> DISABLE-IMSI-LOCATION-UPDATE : {}", (Object)Constants.DISABLE_IMSI_LOCATION_UPDATE);
        logger.info("NMS ==> ENABLE-REGISTRATION-MONITORING : {}", (Object)Constants.ENABLE_REGISTRATION_MONITORING);
        logger.info("NMS ==> ENABLE-LOCATION-FILTER : {}", (Object)Constants.ENABLE_LOCATION_FILTER);
        logger.info("NMS ==> ENABLE-PORT-MONITORING : {}", (Object)Constants.ENABLE_PORT_MONITORING);
        logger.info("NMS ==> SWITCH-TOPOLOGY-SCAN-INTERVAL : {}", (Object)Constants.SWITCH_TOPOLOGY_SCAN_INTERVAL);
        logger.info("NMS ==> NMS-UPDATE-EXTENSION-STATUS-PROCESS : {}", (Object)Constants.NMS_UPDATE_EXTENSION_STATUS_PROCESS);
        logger.info("NMS ==> ENABLE-SWITCH-CDR-COLLECTION : {}", (Object)Constants.ENABLE_SWITCH_CDR_COLLECTION);
        logger.info("NMS ==> NMS-REGISTRATION-ALERT-PROCESS : {}", (Object)Constants.NMS_REGISTRATION_ALERT_PROCESS);
        logger.info("NMS ==> ENABLE-SWITCH-CDR-COLLECTION : {}", (Object)Constants.ENABLE_SWITCH_CDR_COLLECTION);
        logger.info("VERSION ==> CALLCENTER-VERION-CONTROL-PROCESS : {}", (Object)Constants.CALLCENTER_VERION_CONTROL_PROCESS);
        logger.info("VERSION ==> CALLCENTER-VERSION-CONTROL : {}", (Object)Constants.CALLCENTER_VERSION_CONTROL);
        logger.info("NMS ==> ENABLE_SEND_ALERT_EMAIL : {}", (Object)Constants.ENABLE_SEND_ALERT_EMAIL);
        logger.info("NMS ==> ENABLE_SEND_ALERT_SMS : {}", (Object)Constants.ENABLE_SEND_ALERT_SMS);
        logger.info("TR069 ==> SERVER-IP : {}", (Object)Constants.TR069_SERVER_IP);
        logger.info("TR069 ==> DEVICE-MANAGER-FILES-PATH : {}", (Object)Constants.DEVICE_MANAGER_FILES_PATH);
        logger.info("TR069 ==> SAMPLE-FILE-NAME : {}", (Object)Constants.DEVICE_MANAGER_TFTP_SAMPLE_FILE_NAME);
        logger.info("TR069 ==> ENABLE-DEVICE-MANAGER-THREAD : {}", (Object)Constants.ENABLE_DEVICE_MANAGER_GET_ACS_TOKEN);
        logger.info("RECORDING-SERVER ==> RECORDING-ENABLE : {}", (Object)Constants.RECORDING_ENABLE);
        logger.info("RECORDING-SERVER ==> RECORDING-ACCOUNT-NO : {}", (Object)Constants.RECORDING_ACCOUNT_NO);
        logger.info("RECORDING-SERVER ==> RECORDING-USER-ID : {}", (Object)Constants.RECORDING_USER_ID);
        logger.info("LDAP ==> NAME-FILTER : {}", (Object)Constants.LDAP_NAME_FILTER);
        logger.info("LDAP ==> NUMBER-FILTER : {}", (Object)Constants.LDAP_NUMBER_FILTER);
        logger.info("LDAP ==> TLS-MODE : {}", (Object)Constants.LDAP_TLS_MODE);
        logger.info("LDAP ==> PORT : {}", (Object)Constants.LDAP_PORT);
        logger.info("LDAP ==> BASE-DN : {}", (Object)Constants.LDAP_BASE_DN);
        logger.info("LDAP ==> USERNAME : {}", (Object)Constants.LDAP_USER_NAME);
        logger.info("LDAP ==> PLAIN-TEXT-PASSWORD : {}", (Object)Constants.LDAP_PASSWORD);
        logger.info("LDAP ==> MAX-HITS : {}", (Object)Constants.LDAP_MAX_HITS);
        logger.info("LDAP ==> NAME-ATTRIBUTES : {}", (Object)Constants.LDAP_NAME_ATTRIBUTES);
        logger.info("LDAP ==> NUMBER-ATTRIBUTES : {}", (Object)Constants.LDAP_NUMBER_ATTRIBUTES);
        logger.info("LDAP ==> DISPLAY-NAME : {}", (Object)Constants.LDAP_DISPLAY_NAME);
        logger.info("LDAP ==> SEARCH-DELAY : {}", (Object)Constants.LDAP_SEARCH_DELAY);
        logger.info("LDAP ==> PROTOCOL : {}", (Object)Constants.LDAP_PROTOCOL);
        logger.info("LDAP ==> LOOKUP-FOR-INCOMING-CALL : {}", (Object)Constants.LDAP_LOOKUP_FOR_INCOMING_CALL);
        logger.info("LDAP ==> SORTING-RESULTS : {}", (Object)Constants.LDAP_SORTING_RESULTS);
        logger.info("LDAP ==> LOOKUP-FOR-DIAL : {}", (Object)Constants.LDAP_LOOKUP_FOR_DIAL);
        logger.info("LDAP ==> SYNC-TIME : {}", (Object)Constants.LDAP_SYNC_TIME);
        logger.info("LDAP ==> GROUP-ATTRIBUTE : {}", (Object)Constants.LDAP_GROUP_ATTRIBUTE);
        logger.info("LDAP ==> DISPLAY-MODE : {}", (Object)Constants.LDAP_DISPLAY_MODE);
        logger.info("NMS ==> SIP-PORT : {}", (Object)Constants.SIP_PORT);
        logger.info("NMS ==> REMOTE-NMS-IP : {}", (Object)Constants.REMOTE_NMS_IP);
        logger.info("NMS ==> REMOTE-NMS-PORT : {}", (Object)Constants.REMOTE_NMS_PORT);
        logger.info("NMS ==> ENABLE-ESCALATION : {}", (Object)Constants.ENABLE_ESCALATION);
        logger.info("NMS ==> ESCALATION-1 : {}", (Object)Constants.ESCALATION_1);
        logger.info("NMS ==> ESCALATION-2 : {}", (Object)Constants.ESCALATION_2);
        logger.info("NMS ==> ESCALATION-3 : {}", (Object)Constants.ESCALATION_3);
        logger.info("NMS ==> REMOTE-NFS-SERVER : {}", (Object)Constants.REMOTE_NFS_SERVER);
        logger.info("NMS ==> ENABLE-ALERT-ON-ASSET-ATTRIBUTE-CHANGE : {}", (Object)Constants.ENABLE_ALERT_ON_ASSET_ATTRIBUTE_CHANGE);
        logger.info("EMAIL ==> EMAIL-SERVER-NAME : {}", (Object)Constants.EMAIL_SERVER_NAME);
        logger.info("EMAIL ==> EMAIL-SERVER-PORT : {}", (Object)Constants.EMAIL_SERVER_PORT);
        logger.info("EMAIL ==> EMAIL-SERVER-USERNAME : {}", (Object)Constants.EMAIL_SERVER_USERNAME);
        logger.info("EMAIL ==> EMAIL-SERVER-FROM : {}", (Object)Constants.EMAIL_SERVER_FROM);
        logger.info("EMAIL ==> EMAIL-SERVER-DEFAULT-TO : {}", (Object)Constants.EMAIL_SERVER_DEFAULT_TO);
        logger.info("EMAIL ==> EMAIL-SERVER-DEFAULT-CC : {}", (Object)Constants.EMAIL_SERVER_DEFAULT_CC);
        logger.info("SMS ==> SMS-SERVER-URL : {}", (Object)Constants.SMS_SERVER_URL);
        logger.info("SMS ==> SMS-SERVER-USERNAME : {}", (Object)Constants.SMS_SERVER_USERNAME);
        logger.info("SMS ==> SMS-SERVER-DEFAULT-TO : {}", (Object)Constants.SMS_SERVER_DEFAULT_TO);
        logger.info("SMS ==> SMS-SENDER : {}", (Object)Constants.SMS_SENDER);
        logger.info("SMS ==> SMS-TEMPLATE-ID : {}", (Object)Constants.SMS_TEMPLATE_ID);
        logger.info("TASK ==> TASK-ALERT : {}", (Object)Constants.TASK_ALERT);
        logger.info("TASK ==> TASK-ALERT-RECEIVER : {}", (Object)Constants.TASK_ALERT_RECEIVER);
        logger.info("ENABLE_TIME_SERIES_DATABASE : {}", (Object)Constants.ENABLE_TIME_SERIES_DATABASE);
        logger.info("BANDWIDTH ==> CAPTURE-ENABLED : {}", (Object)Constants.BANDWIDTH_CAPTURE_ENABLED);
        logger.info("BANDWIDTH ==> CAPTURE-INTERFACE : {}", (Object)Constants.BANDWIDTH_CAPTURE_INTERFACE);
        logger.info("BANDWIDTH ==> CAPTURE-SUB-NET : {}", (Object)Constants.BANDWIDTH_CAPTURE_SUB_NET);
        logger.info("BANDWIDTH ==> CAPTURE-GATEWAY : {}", (Object)Constants.BANDWIDTH_CAPTURE_GATEWAY);
        logger.info("BANDWIDTH ==> CAPTURE-INTERVAL : {}", (Object)Constants.BANDWIDTH_CAPTURE_INTERVAL);
        logger.info("COUNTER ==> FILE-DIRECTORY : {}", (Object)Constants.COUNTER_FILE_DIRECTORY);
        logger.info("COUNTER ==> READ-INTERVAL : {}", (Object)Constants.COUNTER_READ_INTERVAL);
        logger.info("COUNTER ==> COUNTERS_ENABLE_RESONOUS : {}", (Object)Constants.COUNTERS_ENABLE_RESONOUS);
        logger.info("CLUSTER ==> TIME-ZONE-FOR-SUMMARY : {}", (Object)Constants.TIME_ZONE_FOR_SUMMARY);
        logger.info("MAP ==> MAP_URL: {}", (Object)Constants.MAP_URL);
        logger.info("EXTENSION ALERT TYPE LIST ==> EXTENSION-TYPE-LIST-TO-SENT-ALERT : {}", (Object)Constants.EXTENSION_TYPE_LIST_TO_SENT_ALERT);
        logger.info("EXTENSION ALERT TIME INTERVAL ==>  : {}", (Object)Constants.EXTENSION_DELAY_TIME_FOR_ALERT);
        logger.info("TIME-DIFFERENCE-FOR-NOT-PROCESSING-CDR ==>  : {}", (Object)Constants.TIME_DIFFERENCE_FOR_NOT_PROCESSING_CDR);
        logger.info("{} ==> PRESENCE-ENABLED: {}", (Object)"SUBSCRIBER-ALERTS", (Object)Constants.SUBSCRIBER_ALERTS_PRESENCE_ENABLED);
        logger.info("{} ==> FIELD-MONITOR-ENABLED: {}", (Object)"SUBSCRIBER-ALERTS", (Object)Constants.SUBSCRIBER_ALERTS_FIELD_MONITOR_ENABLED);
        logger.info("{} ==> MONITOR-INTERVAL: {}", (Object)"SUBSCRIBER-ALERTS", (Object)Constants.SUBSCRIBER_ALERTS_MONITOR_INTERVAL);
        logger.info("{} ==> PRESENCE-SOURCES-ENABLED-FS: {}", (Object)"SUBSCRIBER-ALERTS", (Object)Constants.PRESENCE_SOURCES_ENABLED_FS);
        logger.info("{} ==> PRESENCE-SOURCES-ENABLED-IMSv2: {}", (Object)"SUBSCRIBER-ALERTS", (Object)Constants.PRESENCE_SOURCES_ENABLED_IMSv2);
        logger.info("{} ==> PRESENCE-SOURCES-ENABLED-PROXY: {}", (Object)"SUBSCRIBER-ALERTS", (Object)Constants.PRESENCE_SOURCES_ENABLED_PROXY);
        logger.info("{} ==> PRESENCE-SOURCES-ENABLED-MCX: {}", (Object)"SUBSCRIBER-ALERTS", (Object)Constants.PRESENCE_SOURCES_ENABLED_MCX);
        logger.info("{} ==> PRESENCE-SOURCES-ENABLED-IMSI: {}", (Object)"SUBSCRIBER-ALERTS", (Object)Constants.PRESENCE_SOURCES_ENABLED_IMSI);
        logger.info("{} ==> PRESENCE-MCX-HEARTBEAT: {}", (Object)"SUBSCRIBER-ALERTS", (Object)Constants.PRESENCE_MCX_HEARTBEAT);
        logger.info("{} ==> target {}", (Object)"SNMP-AGENT", (Object)Constants.SNMP_AGENT_TARGET_IP);
        logger.info("{} ==> port {}", (Object)"SNMP-AGENT", (Object)Constants.SNMP_AGENT_TARGET_PORT);
        logger.info("{} ==> community {}", (Object)"SNMP-AGENT", (Object)Constants.SNMP_AGENT_TARGET_COMMUNITY);
        logger.info("{} ==> CONFERENCE-PROVIDER : {}", (Object)"PPDR-CONFERENCE", (Object)Constants.CONFERENCE_PROVIDER);
        logger.info("{} ==> WEBSOCKET-CORES : {}", (Object)"PPDR-CONFERENCE", (Object)Constants.WEBSOCKET_CORES);
        logger.info("{} ==> PARTICIPANT-KEEP-ALIVE-EXPIRE-PERIOD : {}", (Object)"PPDR-CONFERENCE", (Object)Constants.PARTICIPANT_KEEP_ALIVE_EXPIRE_PERIOD);
        logger.info("BILLING ==> BILLING-CACHE-DAYS : {}", (Object)Constants.BILLING_CACHE_DAYS);
        if (Constants.BILLING_PEERS.isEmpty()) {
            logger.warn("No billing peers configured");
        } else {
            Constants.BILLING_PEERS.forEach(peer -> logger.info("BILLING ==> BILLING-PEER : NodeName={}, NodeIP={}", (Object)peer.getNodeName(), (Object)peer.getNodeIP()));
        }
        logger.info("============================ Configuration Values : End   ============================");
    }

    private static void readProperties() {
        String activeProfile = System.getProperty("spring.profiles.active", System.getenv("SPRING_PROFILES_ACTIVE"));
        logger.info("Application Starting with Profile profiles={}", (Object)activeProfile);
        Properties properties = TelemetryApplication.loadPropertiesForProfile((String)activeProfile);
        String clusterConfiguration = properties.getProperty("default.config", "/etc/default/coral");
        try {
            Ini ini = new Ini(new File(clusterConfiguration));
            IniPreferences configuration = new IniPreferences(ini);
            String[] scadaServers = configuration.node("NMS").get("SCADA-SERVERS", "").split(",");
            Constants.CLUSTER_KEY = configuration.node("CLUSTER").get("CLUSTER-KEY", "");
            Constants.WEBSOCKET_KEY = configuration.node("CLUSTER").get("WEBSOCKET-KEY", "");
            Constants.NODE_MODE = configuration.node("CLUSTER").get("NODE-MODE", "");
            Constants.CLUSTER_SSL_ENABLED = configuration.node("CLUSTER").getBoolean("CLUSTER-SSL-ENABLED", false);
            Constants.CLUSTER_SSL_ENABLED = configuration.node("CLUSTER").getBoolean("CLUSTER-SSL-ENABLED", false);
            Constants.CLUSTER_AUDIT_LOG_ENABLED = configuration.node("CLUSTER").getBoolean("CLUSTER-AUDIT-LOG-ENABLED", false);
            Constants.CLUSTER_CALL_RECORD_DISTRIBUTION = configuration.node("CLUSTER").getBoolean("CLUSTER-CALL-RECORD-DISTRIBUTION", false);
            Constants.ENABLE_FREE_SWITCH_ESL_SERVICE = configuration.node("CLUSTER").getBoolean("ENABLE-FREE-SWITCH-ESL-SERVICE", false);
            Constants.SIP_TRUNK_CDR = configuration.node("CLUSTER").getBoolean("SIP-TRUNK-CDR", false);
            Constants.CALLCENTER_VERSION_CONTROL = configuration.node("VERSION").get("CALLCENTER-VERSION-CONTROL", "O");
            Constants.CALLCENTER_VERION_CONTROL_PROCESS = configuration.node("VERSION").getBoolean("CALLCENTER-VERION-CONTROL-PROCESS", true);
            Constants.SEND_CDR_DATA_IN_VOICE_LOGGER = configuration.node("CLUSTER").getBoolean("SEND-CDR-DATA-IN-VOICE-LOGGER", true);
            Constants.TIME_ZONE_FOR_SUMMARY = configuration.node("CLUSTER").get("TIME-ZONE-FOR-SUMMARY", "Asia/Kolkata");
            Constants.TIME_DIFFERENCE_FOR_NOT_PROCESSING_CDR = configuration.node("CLUSTER").getLong("TIME-DIFFERENCE-FOR-NOT-PROCESSING-CDR", 2L);
            Constants.SEND_CHANNELS_DATA_IN_VOICE_LOGGER = configuration.node("CLUSTER").getBoolean("SEND-CHANNELS-DATA-IN-VOICE-LOGGER", false);
            Constants.SEND_CHANNELS_DATA_IN_BILLING_CDR = configuration.node("CLUSTER").getBoolean("SEND-CHANNELS-DATA-IN-BILLING-CDR", false);
            Constants.PPDR_SOCKET_URL = configuration.node("CLUSTER").get("PPDR-SOCKET-URL", "http://127.0.0.1/ppdr/api/v2/messaging/send-event");
            Constants.BILLING_ENABLE_THIRD_PARTY_BILLING = configuration.node("CLUSTER").getBoolean("BILLING-ENABLE-THIRD-PARTY-BILLING", false);
            Constants.GATE_ANNOUNCEMENT_FILE = configuration.node("CLUSTER").get("GATE-ANNOUNCEMENT-FILE", "/etc/coraltele/sounds/music/8000/moh.wav");
            Constants.IMS_V2_IP = configuration.node("IMS-V2").get("LISTEN-IP-ADDRESS", "127.0.0.1");
            Constants.SCADA_PORT = configuration.node("NMS").getInt("SCADA-PORT", 162);
            Constants.SNMP_TRAP_RECEIVE_IP = configuration.node("NMS").get("SNMP-TRAP-RECEIVE-IP", "0.0.0.0");
            Constants.SNMP_TRAP_RECEIVE_PORT = configuration.node("NMS").getInt("SNMP-TRAP-RECEIVE-PORT", 162);
            Constants.SNMP_TRAP_SEND_SOURCE_IP = configuration.node("NMS").get("SNMP-TRAP-SEND-IP", "0.0.0.0");
            Constants.SNMP_TRAP_SEND_SOURCE_PORT = configuration.node("NMS").getInt("SNMP-TRAP-SEND-PORT", 163);
            Constants.SNMP_EVENT_SEND_URL = configuration.node("NMS").get("SNMP-EVENT-SEND-URL", "");
            Constants.TELEMETRY_VERSION = configuration.node("NMS").getInt("TELEMETRY-VERSION", 1);
            Constants.ASSET_SOURCE = configuration.node("NMS").getInt("ASSET-SOURCE", 1);
            Constants.ENABLE_NMS = configuration.node("NMS").getBoolean("ENABLE-NMS", true);
            Constants.ENABLE_TELEMETRY = configuration.node("NMS").getBoolean("ENABLE-TELEMETRY", false);
            Constants.ENABLE_SNMP = configuration.node("NMS").getBoolean("ENABLE-SNMP", true);
            Constants.ENABLE_PING_CHECK = configuration.node("NMS").getBoolean("ENABLE-PING-CHECK", true);
            Constants.ENABLE_PING_DISCOVERY = configuration.node("NMS").getBoolean("ENABLE-PING-DISCOVERY", true);
            Constants.ENABLE_MEDIA_GATEWAY_HEALTH_CHECK = configuration.node("NMS").getBoolean("ENABLE-MEDIA-GATEWAY-HEALTH-CHECK", true);
            Constants.SEND_SMS_BY_SERVICE = configuration.node("NMS").getBoolean("SEND-SMS-BY-SERVICE", false);
            Constants.SEND_SMS_BY_CASQ = configuration.node("NMS").getBoolean("SEND-SMS-BY-CASQ", false);
            Constants.NMS_UPDATE_EXTENSION_STATUS_PROCESS = configuration.node("NMS").getBoolean("NMS-UPDATE-EXTENSION-STATUS-PROCESS", false);
            Constants.REMOTE_NMS_IP = configuration.node("NMS").get("REMOTE-NMS-IP", "127.0.0.1");
            Constants.REMOTE_NMS_PORT = configuration.node("NMS").getInt("REMOTE-NMS-PORT", 8998);
            Constants.ENABLE_REDIS_PUB_SUB = configuration.node("NMS").getBoolean("ENABLE-REDIS-PUB-SUB", true);
            Constants.ENABLE_SCADA_MESSAGE = configuration.node("NMS").getBoolean("ENABLE-SCADA-MESSAGE", true);
            Constants.CENTRAL_NMS_REDIS_IP = configuration.node("NMS").get("CENTRAL-NMS-REDIS-IP", "");
            Constants.CENTRAL_NMS_REDIS_PORT = configuration.node("NMS").getInt("CENTRAL-NMS-REDIS-PORT", 0);
            Constants.CENTRAL_NMS_DOMAIN = configuration.node("NMS").get("CENTRAL-NMS-DOMAIN", "");
            Constants.CENTRAL_NMS_PROTOCOL = configuration.node("NMS").get("CENTRAL-NMS-PROTOCOL", "http");
            Constants.CENTRAL_NMS_THIS_LOCATION = configuration.node("NMS").get("CENTRAL-NMS-THIS-LOCATION", "");
            Constants.CENTRAL_NMS_API_KEY = configuration.node("NMS").get("CENTRAL-NMS-API-KEY", "");
            Constants.MAXIMUM_NESTING = configuration.node("NMS").getInt("MAXIMUM-NESTING", 5);
            Constants.WEB_SOCKET_URL = configuration.node("NMS").get("WEB-SOCKET-URL", "http://127.0.0.1:8989");
            Constants.DISCOVERY_DURATION = configuration.node("NMS").getInt("DISCOVERY-DURATION", 1);
            Constants.DISCOVERY_TIMEOUT = configuration.node("NMS").getInt("DISCOVERY-TIMEOUT", 500);
            Constants.ICMP_CHECK_THREADS = configuration.node("NMS").getInt("ICMP-CHECK-THREADS", 10);
            Constants.IP_COUNT_EACH_THREAD = configuration.node("NMS").getInt("IP-COUNT-EACH-THREAD", 5);
            Constants.PING_COUNT_FOR_NOT_REACHABLE = configuration.node("NMS").getInt("PING-COUNT-FOR-NOT-REACHABLE", 1);
            Constants.TR069_SERVER_IP = configuration.node("TR069").get("SERVER-IP", "127.0.0.1:3000");
            Constants.DEVICE_MANAGER_FILES_PATH = configuration.node("TR069").get("FILES-PATH", "");
            Constants.DEVICE_MANAGER_TFTP_SAMPLE_FILE_NAME = configuration.node("TR069").get("SAMPLE-FILE-NAME", "IP2LP_IP6LP_AVP6LP.template.xml");
            Constants.SIP_PORT = configuration.node("CLUSTER").get("SBC_USERS_PORT", "5060");
            Constants.ENABLE_DEVICE_MANAGER_GET_ACS_TOKEN = configuration.node("TR069").getBoolean("ENABLE-DEVICE-MANAGER-THREAD", false);
            Constants.RECORDING_ENABLE = configuration.node("RECORDING-SERVER").getBoolean("RECORDING-ENABLE", false);
            Constants.RECORDING_ACCOUNT_NO = configuration.node("RECORDING-SERVER").get("RECORDING-ACCOUNT-NO", "0");
            Constants.RECORDING_USER_ID = configuration.node("RECORDING-SERVER").get("RECORDING-USER-ID", "");
            Constants.LDAP_NAME_FILTER = configuration.node("LDAP").get("NAME-FILTER", "(displayName=%)");
            Constants.LDAP_NUMBER_FILTER = configuration.node("LDAP").get("NUMBER-FILTER", "(telephoneNumber=%)");
            Constants.LDAP_TLS_MODE = configuration.node("LDAP").getInt("TLS-MODE", 0);
            Constants.LDAP_PORT = configuration.node("LDAP").getInt("PORT", 389);
            Constants.LDAP_BASE_DN = configuration.node("LDAP").get("BASE-DN", "dc=coraltele,dc=com");
            Constants.LDAP_USER_NAME = configuration.node("LDAP").get("USERNAME", "cn=coral-ldap,dc=coraltele,dc=com");
            Constants.LDAP_PASSWORD = configuration.node("LDAP").get("PLAIN-TEXT-PASSWORD", "Coral@1234");
            Constants.LDAP_MAX_HITS = configuration.node("LDAP").getInt("MAX-HITS", 499);
            Constants.LDAP_NAME_ATTRIBUTES = configuration.node("LDAP").get("NAME-ATTRIBUTES", "displayName");
            Constants.LDAP_NUMBER_ATTRIBUTES = configuration.node("LDAP").get("NUMBER-ATTRIBUTES", "telephoneNumber");
            Constants.LDAP_DISPLAY_NAME = configuration.node("LDAP").get("DISPLAY-NAME", "displayName");
            Constants.LDAP_SEARCH_DELAY = configuration.node("LDAP").getInt("SEARCH-DELAY", 200);
            Constants.LDAP_PROTOCOL = configuration.node("LDAP").getInt("PROTOCOL", 0);
            Constants.LDAP_LOOKUP_FOR_INCOMING_CALL = configuration.node("LDAP").getBoolean("LOOKUP-FOR-INCOMING-CALL", true);
            Constants.LDAP_SORTING_RESULTS = configuration.node("LDAP").getInt("SORTING-RESULTS", 0);
            Constants.LDAP_LOOKUP_FOR_DIAL = configuration.node("LDAP").getBoolean("LOOKUP-FOR-DIAL", true);
            Constants.LDAP_SYNC_TIME = configuration.node("LDAP").get("SYNC-TIME", "");
            Constants.LDAP_GROUP_ATTRIBUTE = configuration.node("LDAP").get("GROUP-ATTRIBUTE", "");
            Constants.LDAP_DISPLAY_MODE = configuration.node("LDAP").getInt("DISPLAY-MODE", 0);
            Constants.NMS_REGISTRATION_ALERT_PROCESS = configuration.node("NMS").getBoolean("NMS-REGISTRATION-ALERT-PROCESS", false);
            Constants.ENABLE_OPEN_NMS_OUTAGES_TO_SCADA = configuration.node("NMS").getInt("ENABLE-OPEN-NMS-OUTAGES-TO-SCADA", 0);
            Constants.TIME_SERIES_DB_URL = configuration.node("NMS").get("TIME-SERIES-DB-URL", "http://127.0.0.1:9090");
            Constants.CALL_SERVER_IP = configuration.node("NMS").get("CALL-SERVER-IP", "http://127.0.0.1:8989");
            Constants.ADDITIONAL_CALL_SERVERS = configuration.node("NMS").get("ADDITIONAL-CALL-SERVERS", "");
            Constants.DISABLE_IMSI_LOCATION_UPDATE = configuration.node("NMS").getBoolean("DISABLE-IMSI-LOCATION-UPDATE", false);
            Constants.ENABLE_REGISTRATION_MONITORING = configuration.node("NMS").getBoolean("ENABLE-REGISTRATION-MONITORING", false);
            Constants.ENABLE_LOCATION_FILTER = configuration.node("NMS").getBoolean("ENABLE-LOCATION-FILTER", false);
            Constants.ENABLE_PORT_MONITORING = configuration.node("NMS").getBoolean("ENABLE-PORT-MONITORING", false);
            Constants.SWITCH_TOPOLOGY_SCAN_INTERVAL = configuration.node("NMS").getLong("SWITCH-TOPOLOGY-SCAN-INTERVAL", 1440L);
            Constants.ENABLE_SEND_ALERT_EMAIL = configuration.node("NMS").getBoolean("ENABLE_SEND_ALERT_EMAIL", false);
            Constants.ENABLE_SEND_ALERT_SMS = configuration.node("NMS").getBoolean("ENABLE_SEND_ALERT_SMS", false);
            Constants.ENABLE_SWITCH_CDR_COLLECTION = configuration.node("NMS").getBoolean("ENABLE-SWITCH-CDR-COLLECTION", false);
            Constants.ENABLE_TIME_SERIES_DATABASE = configuration.node("NMS").getBoolean("ENABLE_TIME_SERIES_DATABASE", false);
            Constants.ENABLE_ALERT_ON_ASSET_ATTRIBUTE_CHANGE = configuration.node("NMS").getBoolean("ENABLE-ALERT-ON-ASSET-ATTRIBUTE-CHANGE", true);
            Constants.BANDWIDTH_CAPTURE_ENABLED = configuration.node("BANDWIDTH").getBoolean("CAPTURE-ENABLED", false);
            Constants.BANDWIDTH_CAPTURE_INTERFACE = configuration.node("BANDWIDTH").get("CAPTURE-INTERFACE", "ogstun");
            Constants.BANDWIDTH_CAPTURE_SUB_NET = configuration.node("BANDWIDTH").get("CAPTURE-SUB-NET", "10.45");
            Constants.BANDWIDTH_CAPTURE_GATEWAY = configuration.node("BANDWIDTH").get("CAPTURE-GATEWAY", "10.45.0.1");
            Constants.BANDWIDTH_CAPTURE_INTERVAL = configuration.node("BANDWIDTH").getInt("CAPTURE-INTERVAL", 1);
            Constants.COUNTER_FILE_DIRECTORY = configuration.node("COUNTER").get("FILE-DIRECTORY", "/var/lib/radio-resources");
            Constants.EXTENSION_TYPE_LIST_TO_SENT_ALERT = configuration.node("SUBSCRIBER-ALERTS").get("EXTENSION-TYPE-LIST-TO-SENT-ALERT", "");
            Constants.COUNTER_READ_INTERVAL = configuration.node("COUNTER").getLong("READ-INTERVAL", 300000L);
            Constants.EXTENSION_DELAY_TIME_FOR_ALERT = configuration.node("SUBSCRIBER-ALERTS").getLong("EXTENSION-DELAY-TIME-FOR-ALERT", 15L);
            Constants.COUNTERS_ENABLE_RESONOUS = configuration.node("COUNTER").getBoolean("COUNTERS-ENABLE-RESONOUS", false);
            Constants.BATTERY_RSRP_EXTENSION_UPDATE_IN_SWITCH_DB = configuration.node("CLUSTER").getBoolean("BATTERY-RSRP-EXTENSION-UPDATE-IN-SWITCH-DB", false);
            Constants.CONFERENCE_NUMBER = configuration.node("CLUSTER").get("CONFERENCE-NUMBER", "0000");
            Constants.EMAIL_SERVER_NAME = configuration.node("EMAIL").get("EMAIL-SERVER-NAME", "");
            Constants.EMAIL_SERVER_PORT = configuration.node("EMAIL").getInt("EMAIL-SERVER-PORT", 0);
            Constants.EMAIL_SERVER_USERNAME = configuration.node("EMAIL").get("EMAIL-SERVER-USERNAME", "");
            Constants.EMAIL_SERVER_PASSWORD = configuration.node("EMAIL").get("EMAIL-SERVER-PASSWORD", "");
            Constants.EMAIL_SERVER_FROM = configuration.node("EMAIL").get("EMAIL-SERVER-FROM", "");
            TelemetryApplication.getListItems((List)Constants.EMAIL_SERVER_DEFAULT_TO, (String)configuration.node("EMAIL").get("EMAIL-SERVER-DEFAULT-TO", ""), (String)",");
            TelemetryApplication.getListItems((List)Constants.EMAIL_SERVER_DEFAULT_CC, (String)configuration.node("EMAIL").get("EMAIL-SERVER-DEFAULT-CC", ""), (String)",");
            Constants.SMS_SERVER_URL = configuration.node("SMS").get("SMS-SERVER-URL", "");
            Constants.SMS_SERVER_USERNAME = configuration.node("SMS").get("SMS-SERVER-USERNAME", "");
            Constants.SMS_SERVER_PASSWORD = configuration.node("SMS").get("SMS-SERVER-PASSWORD", "");
            TelemetryApplication.getListItems((List)Constants.SMS_SERVER_DEFAULT_TO, (String)configuration.node("SMS").get("SMS-SERVER-DEFAULT-TO", ""), (String)",");
            Constants.SMS_SENDER = configuration.node("SMS").get("SMS-SENDER", "");
            Constants.SMS_TEMPLATE_ID = configuration.node("SMS").get("SMS-TEMPLATE-ID", "");
            Constants.TASK_ALERT = configuration.node("TASK").getBoolean("TASK-ALERT", false);
            Constants.TASK_ALERT_RECEIVER = configuration.node("TASK").get("TASK-ALERT-RECEIVER", "");
            Constants.ENABLE_ESCALATION = configuration.node("NMS").getBoolean("ENABLE-ESCALATION", false);
            Constants.ESCALATION_1 = configuration.node("NMS").get("ESCALATION-1", "");
            Constants.ESCALATION_2 = configuration.node("NMS").get("ESCALATION-2", "");
            Constants.ESCALATION_3 = configuration.node("NMS").get("ESCALATION-3", "");
            Constants.REMOTE_NFS_SERVER = configuration.node("NMS").get("REMOTE-NFS-SERVER", "");
            Constants.WEBSOCKET_CORES = configuration.node("PPDR-CONFERENCE").getInt("WEBSOCKET-CORES", 0);
            if (!StringUtils.hasText((String)Constants.SNMP_TRAP_RECEIVE_IP)) {
                Constants.SNMP_TRAP_RECEIVE_IP = "0.0.0.0";
            }
            if (!StringUtils.hasText((String)Constants.SNMP_TRAP_SEND_SOURCE_IP)) {
                Constants.SNMP_TRAP_SEND_SOURCE_IP = "0.0.0.0";
            }
            if (Constants.SNMP_EVENT_SEND_URL.contains("null")) {
                Constants.SNMP_EVENT_SEND_URL = "";
            }
            if (Boolean.TRUE.equals(Constants.ENABLE_ESCALATION)) {
                if (Constants.ESCALATION_1 == null || Constants.ESCALATION_1.isEmpty()) {
                    Constants.ESCALATION_1 = "60;" + Constants.SMS_SERVER_DEFAULT_TO.stream().collect(Collectors.joining(",")) + ";" + Constants.EMAIL_SERVER_DEFAULT_TO.stream().collect(Collectors.joining(",")) + ";" + Constants.EMAIL_SERVER_DEFAULT_CC.stream().collect(Collectors.joining(","));
                }
                if (Constants.ESCALATION_2 == null || Constants.ESCALATION_2.isEmpty()) {
                    Constants.ESCALATION_2 = "60;" + Constants.SMS_SERVER_DEFAULT_TO.stream().collect(Collectors.joining(",")) + ";" + Constants.EMAIL_SERVER_DEFAULT_TO.stream().collect(Collectors.joining(",")) + ";" + Constants.EMAIL_SERVER_DEFAULT_CC.stream().collect(Collectors.joining(","));
                }
                if (Constants.ESCALATION_3 == null || Constants.ESCALATION_3.isEmpty()) {
                    Constants.ESCALATION_3 = "60;" + Constants.SMS_SERVER_DEFAULT_TO.stream().collect(Collectors.joining(",")) + ";" + Constants.EMAIL_SERVER_DEFAULT_TO.stream().collect(Collectors.joining(",")) + ";" + Constants.EMAIL_SERVER_DEFAULT_CC.stream().collect(Collectors.joining(","));
                }
            }
            Constants.MAP_URL = configuration.node("MAP").get("MAP-URL", "");
            Constants.SUBSCRIBER_ALERTS_PRESENCE_ENABLED = configuration.node("SUBSCRIBER-ALERTS").getBoolean("PRESENCE-ENABLED", false);
            Constants.SUBSCRIBER_ALERTS_FIELD_MONITOR_ENABLED = configuration.node("SUBSCRIBER-ALERTS").getBoolean("FIELD-MONITOR-ENABLED", false);
            Constants.SUBSCRIBER_ALERTS_MONITOR_INTERVAL = configuration.node("SUBSCRIBER-ALERTS").getLong("MONITOR-INTERVAL", 60000L);
            Constants.PRESENCE_SOURCES_ENABLED_FS = configuration.node("SUBSCRIBER-ALERTS").getBoolean("PRESENCE-SOURCES-ENABLED-FS", false);
            Constants.PRESENCE_SOURCES_ENABLED_IMSv2 = configuration.node("SUBSCRIBER-ALERTS").getBoolean("PRESENCE-SOURCES-ENABLED-IMSv2", true);
            Constants.PRESENCE_SOURCES_ENABLED_PROXY = configuration.node("SUBSCRIBER-ALERTS").getBoolean("PRESENCE-SOURCES-ENABLED-PROXY", true);
            Constants.PRESENCE_SOURCES_ENABLED_MCX = configuration.node("SUBSCRIBER-ALERTS").getBoolean("PRESENCE-SOURCES-ENABLED-MCX", false);
            Constants.PRESENCE_SOURCES_ENABLED_IMSI = configuration.node("SUBSCRIBER-ALERTS").getBoolean("PRESENCE-SOURCES-ENABLED-IMSI", false);
            Constants.PRESENCE_MCX_HEARTBEAT = configuration.node("SUBSCRIBER-ALERTS").getInt("PRESENCE-MCX-HEARTBEAT", 30);
            Constants.CONFERENCE_PROVIDER = configuration.node("PPDR-CONFERENCE").getInt("CONFERENCE-PROVIDER", 1);
            Constants.PARTICIPANT_KEEP_ALIVE_EXPIRE_PERIOD = configuration.node("PPDR-CONFERENCE").getInt("PARTICIPANT-KEEP-ALIVE-EXPIRE-PERIOD", 600);
            if (configuration.node("SNMP-AGENT") != null) {
                Constants.SNMP_AGENT_TARGET_IP = configuration.node("SNMP-AGENT").get("target", "");
                Constants.SNMP_AGENT_TARGET_PORT = configuration.node("SNMP-AGENT").getInt("port", 162);
                Constants.SNMP_AGENT_TARGET_COMMUNITY = configuration.node("SNMP-AGENT").get("community", "public");
                if (!StringUtils.hasText((String)Constants.SNMP_AGENT_TARGET_IP)) {
                    Constants.SNMP_AGENT_TARGET_IP = Constants.SNMP_TRAP_RECEIVE_IP;
                    Constants.SNMP_AGENT_TARGET_PORT = Constants.SNMP_TRAP_RECEIVE_PORT;
                    logger.warn("SNMP Agent IP is not configured, using default: {}", (Object)Constants.SNMP_AGENT_TARGET_IP);
                }
            }
            if (!StringUtils.hasText((String)Constants.SIP_PORT)) {
                Constants.SIP_PORT = "5060";
            }
            if (!StringUtils.hasText((String)Constants.LDAP_NAME_FILTER)) {
                Constants.LDAP_NAME_FILTER = "(displayName=%)";
            }
            if (!StringUtils.hasText((String)Constants.LDAP_NUMBER_FILTER)) {
                Constants.LDAP_NUMBER_FILTER = "(telephoneNumber=%)";
            }
            if (Constants.LDAP_PORT == 0) {
                Constants.LDAP_PORT = Integer.parseInt("389");
            }
            if (Constants.LDAP_MAX_HITS == 0) {
                Constants.LDAP_MAX_HITS = Integer.parseInt("499");
            }
            if (!StringUtils.hasText((String)Constants.LDAP_BASE_DN)) {
                Constants.LDAP_BASE_DN = "dc=coraltele,dc=com";
            }
            if (!StringUtils.hasText((String)Constants.LDAP_USER_NAME)) {
                Constants.LDAP_USER_NAME = "cn=coral-ldap,dc=coraltele,dc=com";
            }
            if (!StringUtils.hasText((String)Constants.LDAP_PASSWORD)) {
                Constants.LDAP_PASSWORD = "Coral@1234";
            }
            if (!StringUtils.hasText((String)Constants.LDAP_NAME_ATTRIBUTES)) {
                Constants.LDAP_NAME_ATTRIBUTES = "displayName";
            }
            if (!StringUtils.hasText((String)Constants.DEVICE_MANAGER_TFTP_SAMPLE_FILE_NAME)) {
                Constants.DEVICE_MANAGER_TFTP_SAMPLE_FILE_NAME = "IP2LP_IP6LP_AVP6LP.template.xml";
            }
            if (!StringUtils.hasText((String)Constants.TIME_ZONE_FOR_SUMMARY)) {
                Constants.TIME_ZONE_FOR_SUMMARY = "Asia/Kolkata";
            }
            if (!StringUtils.hasText((String)Constants.DEVICE_MANAGER_FILES_PATH)) {
                try {
                    String desPath;
                    String fileName = "IP2LP_IP6LP_AVP6LP.template.xml";
                    Constants.DEVICE_MANAGER_FILES_PATH = desPath = "/opt";
                    File destDir = new File(desPath);
                    if (!destDir.exists()) {
                        destDir.mkdirs();
                    }
                    ClassPathResource resource = new ClassPathResource("auto_provisioning/" + fileName);
                    File targetFile = new File(destDir, fileName);
                    try (InputStream in = resource.getInputStream();){
                        Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    Constants.DEVICE_MANAGER_FILES_PATH = desPath;
                    logger.info("File copied to: " + targetFile.getAbsolutePath());
                    logger.info("Auto Provisioning Directory Path: " + Constants.DEVICE_MANAGER_FILES_PATH);
                }
                catch (IOException e) {
                    logger.error("Unable to load or copy file from auto_provisioning folder", (Throwable)e);
                }
            }
            if (!StringUtils.hasText((String)Constants.LDAP_NUMBER_ATTRIBUTES)) {
                Constants.LDAP_NUMBER_ATTRIBUTES = "telephoneNumber";
            }
            if (!StringUtils.hasText((String)Constants.LDAP_DISPLAY_NAME)) {
                Constants.LDAP_DISPLAY_NAME = "displayName";
            }
            for (String scadaServer : scadaServers) {
                Constants.getScadaServers().add(scadaServer);
            }
        }
        catch (IOException e) {
            logger.error("Unable to read property file");
        }
    }

    private static void getListItems(List<String> data, String value, String delimiter) {
        String[] items;
        if (value == null || value.isEmpty()) {
            return;
        }
        for (String item : items = value.split(delimiter)) {
            if (item == null || item.isEmpty()) continue;
            data.add(item.trim());
        }
    }

    private static Properties loadPropertiesForProfile(String profile) {
        Properties properties = new Properties();
        String fileName = StringUtils.hasText((String)profile) ? "application-" + profile + ".properties" : "application.properties";
        try {
            properties.load(new ClassPathResource(fileName).getInputStream());
        }
        catch (IOException e) {
            logger.error("Could not load properties file: {}", (Object)fileName, (Object)e);
        }
        return properties;
    }
}

