/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.messaging.service;

import com.coraltele.telemetry.background.MetricsCollectionProcess;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.IMSI;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.PDUSessionInfo;
import com.coraltele.telemetry.db.telemetry.main.repository.PDUSessionInfoRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.model.DataRate;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import com.coraltele.telemetry.service.messaging.model.IMSIMessageModel;
import com.coraltele.telemetry.service.messaging.model.NodeMessageModel;
import com.coraltele.telemetry.service.messaging.service.SubscribedMessage;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessagingService {
    private static final Logger logger = LogManager.getLogger(MessagingService.class);
    @Autowired
    IMSIRepository dataRepository;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    @Autowired
    SCADAAssetService scadaAssetService;
    @Autowired
    MetricsCollectionProcess metricsCollectionProcess;
    @Autowired
    PDUSessionInfoRepository pduSessionInfoRepository;

    public MessagingService() {
        logger.info("Started");
        Constants.messagingService = this;
    }

    public void updateIMSI(SubscribedMessage message) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String messageData = objectMapper.writeValueAsString(message.getData());
        logger.info("Reverse data {}", (Object)messageData);
        IMSIMessageModel data = (IMSIMessageModel)objectMapper.readValue(messageData, IMSIMessageModel.class);
        data.setUe(data.getUe().replace("imsi-", ""));
        Optional asset = this.scadaAssetService.getNodeByCellId(data.getCellId());
        if (asset.isPresent()) {
            Optional imsi = this.dataRepository.findById((Object)data.getUe());
            IMSI dataToSave = null;
            if (imsi.isPresent()) {
                dataToSave = (IMSI)imsi.get();
            } else {
                dataToSave = new IMSI();
                dataToSave.setImsiNumber(data.getUe());
                dataToSave.setUuid(UUID.randomUUID());
            }
            dataToSave.setAsset((SCADAAsset)asset.get());
            dataToSave.setCellId(data.getCellId());
            dataToSave.setExtensionNumber(data.getExtensionNumber());
            dataToSave.setExtensionName(data.getExtensionName());
            if (message.getEvent().equals(Constants.Message.UE_ATTACH_UPDATE)) {
                dataToSave.setConnected(Boolean.valueOf(true));
            } else if (message.getEvent().equals(Constants.Message.UE_DETACH_UPDATE)) {
                dataToSave.setConnected(Boolean.valueOf(false));
            }
            dataToSave.setLastConnectionOn(Long.valueOf(Instant.now().getEpochSecond()));
            dataToSave.setUlData(Long.valueOf(0L));
            dataToSave.setDlData(Long.valueOf(0L));
            dataToSave.setUpdatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            this.dataRepository.save((Object)dataToSave);
        } else {
            logger.info("Unable to locate node with cell id {}", (Object)data.getCellId());
        }
    }

    public void updateDataRate(SubscribedMessage message) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String messageData = objectMapper.writeValueAsString(message.getData());
        logger.info("Reverse data {}", (Object)messageData);
        DataRate data = (DataRate)objectMapper.readValue(messageData, DataRate.class);
        if (data.getIpAddress().equals("core")) {
            Constants.TotalBandwidth.setData((double)data.getUlDataRate(), (double)data.getDlDataRate());
        } else {
            List imsi = this.dataRepository.findByIpAddress(data.getIpAddress());
            for (IMSI dataToSave : imsi) {
                dataToSave.setDataRateEpoch(Long.valueOf(data.getEpoch() / 1000L));
                dataToSave.setUlDataRate(Double.valueOf(data.getUlDataRate()));
                dataToSave.setDlDataRate(Double.valueOf(data.getDlDataRate()));
                dataToSave.setUlData(Long.valueOf(dataToSave.getUlData() + data.getUlData()));
                dataToSave.setDlData(Long.valueOf(dataToSave.getDlData() + data.getDlData()));
                this.dataRepository.save((Object)dataToSave);
                logger.info("Updating Data to Metrics Collection Service For IMSI {} with UL={} DL={}", (Object)dataToSave.getImsiNumber(), (Object)data.getUlDataRate(), (Object)data.getDlDataRate());
                double dlrate = data.getDlDataRate() * 1048576.0;
                double ulrate = data.getUlDataRate() * 1048576.0;
                this.metricsCollectionProcess.submitImsiDataRate(dataToSave.getImsiNumber(), ulrate, dlrate);
            }
        }
    }

    public void update5GUEIP(SubscribedMessage message) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String messageData = objectMapper.writeValueAsString(message.getData());
        logger.info("Reverse data {}", (Object)messageData);
        IMSIMessageModel data = (IMSIMessageModel)objectMapper.readValue(messageData, IMSIMessageModel.class);
        data.setUe(data.getFiveGSupi().replace("imsi-", ""));
        Optional imsiOpt = this.dataRepository.findById((Object)data.getUe());
        if (imsiOpt.isPresent()) {
            IMSI dataToSave = (IMSI)imsiOpt.get();
            if ("internet".equalsIgnoreCase(data.getDnn())) {
                dataToSave.setIpAddress(data.getIpAddress());
            } else if ("ims".equalsIgnoreCase(data.getDnn())) {
                dataToSave.setImsIpAddress(data.getIpAddress());
            }
            dataToSave.setUlData(Long.valueOf(0L));
            dataToSave.setDlData(Long.valueOf(0L));
            dataToSave.setUpdatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            dataToSave.setUpdatedBy(Constants.hostName);
            dataToSave.setLastConnectionOn(Long.valueOf(Instant.now().getEpochSecond()));
            this.dataRepository.save((Object)dataToSave);
            logger.info("Updated IMSI {} with IP={} IMS-IP={}", (Object)data.getUe(), (Object)dataToSave.getIpAddress(), (Object)dataToSave.getImsIpAddress());
            this.pduSessionInfoRepository.deleteByImsiAndPduType(data.getUe(), data.getDnn());
            PDUSessionInfo pduSession = new PDUSessionInfo();
            pduSession.setImsi(data.getUe());
            pduSession.setExtensionNumber(dataToSave.getExtensionNumber());
            pduSession.setExtensionName(dataToSave.getExtensionName());
            pduSession.setPduType(data.getDnn());
            pduSession.setIpAddress(data.getIpAddress());
            pduSession.setActiveSince(Long.valueOf(Instant.now().getEpochSecond()));
            pduSession.setBaseStation(dataToSave.getCellId());
            pduSession.setBaseStation(dataToSave.getAsset().getNodeName());
            this.pduSessionInfoRepository.save((Object)pduSession);
        } else {
            logger.warn("No IMSI record found for {}", (Object)data.getUe());
        }
    }

    public void remove5GUEIP(SubscribedMessage message) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String messageData = objectMapper.writeValueAsString(message.getData());
        logger.info("Reverse data {}", (Object)messageData);
        IMSIMessageModel data = (IMSIMessageModel)objectMapper.readValue(messageData, IMSIMessageModel.class);
        data.setUe(data.getFiveGSupi().replace("imsi-", ""));
        Optional imsiOpt = this.dataRepository.findById((Object)data.getUe());
        if (imsiOpt.isPresent()) {
            IMSI dataToSave = (IMSI)imsiOpt.get();
            if ("internet".equalsIgnoreCase(data.getDnn())) {
                logger.info("Removing IP Address for IMSI {} DNN {}", (Object)data.getUe(), (Object)data.getDnn());
                dataToSave.setIpAddress(null);
                logger.info("Removed IP Address for IMSI {} DNN {}", (Object)data.getUe(), (Object)data.getDnn());
            } else if ("ims".equalsIgnoreCase(data.getDnn())) {
                logger.info("Removing IP Address for IMSI {} DNN {}", (Object)data.getUe(), (Object)data.getDnn());
                dataToSave.setImsIpAddress(null);
                logger.info("Removed IP Address for IMSI {} DNN {}", (Object)data.getUe(), (Object)data.getDnn());
            }
            dataToSave.setUpdatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            dataToSave.setUlData(Long.valueOf(0L));
            dataToSave.setDlData(Long.valueOf(0L));
            dataToSave.setLastConnectionOn(Long.valueOf(Instant.now().getEpochSecond()));
            dataToSave.setUpdatedBy(Constants.hostName);
            logger.info("Removing Data from IMSI Table is : {}", (Object)dataToSave);
            this.dataRepository.save((Object)dataToSave);
            logger.info("Removed Data from IMSI Table is : {}", (Object)dataToSave);
            long deletedCount = this.pduSessionInfoRepository.deleteByImsiAndPduType(data.getUe(), data.getDnn());
            logger.info("Deleted {} PDU Session Info records for IMSI {} and DNN {}", (Object)deletedCount, (Object)data.getUe(), (Object)data.getDnn());
        } else {
            logger.warn("No IMSI record found for {}", (Object)data.getUe());
        }
    }

    public void updateNode(SubscribedMessage message) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String messageData = objectMapper.writeValueAsString(message.getData());
        logger.info("Reverse data {}", (Object)messageData);
        NodeMessageModel data = (NodeMessageModel)objectMapper.readValue(messageData, NodeMessageModel.class);
        Optional asset = this.scadaAssetService.getNodeByIPAddress(data.getIpAddress());
        if (asset.isPresent()) {
            SCADAAsset dataToSave = (SCADAAsset)asset.get();
            if (message.getEvent().equals(Constants.Message.NODE_ATTACH)) {
                dataToSave.setStatus(true);
            } else if (message.getEvent().equals(Constants.Message.NODE_DETACH)) {
                dataToSave.setStatus(false);
            }
            this.scadaAssetRepository.save((Object)dataToSave);
        } else {
            logger.info("Unable to locate node with ip address {}", (Object)data.getIpAddress());
        }
    }

    public void updateNode5G(SubscribedMessage message) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        String messageData = objectMapper.writeValueAsString(message.getData());
        logger.info("Reverse data {}", (Object)messageData);
        NodeMessageModel data = (NodeMessageModel)objectMapper.readValue(messageData, NodeMessageModel.class);
        Optional asset = this.scadaAssetService.getNodeByIPAddress(data.getIpAddress());
        if (asset.isPresent()) {
            SCADAAsset dataToSave = (SCADAAsset)asset.get();
            if (message.getEvent().equals(Constants.Message.NODE_ATTACH_5G)) {
                dataToSave.setStatus(true);
                dataToSave.setNgapStatus(Boolean.valueOf(true));
                dataToSave.setNgapStatusEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                logger.info("Setting gNodeB to ATTACHED - status: true, ngapStatus: true");
            } else if (message.getEvent().equals(Constants.Message.NODE_DETACH_5G)) {
                dataToSave.setStatus(false);
                dataToSave.setNgapStatus(Boolean.valueOf(false));
                dataToSave.setNgapStatusEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                this.disconnectAllUEsForNode(dataToSave);
                logger.info("Setting gNodeB to DETACHED - status: false, ngapStatus: false");
            }
            this.scadaAssetRepository.save((Object)dataToSave);
        } else {
            logger.info("Unable to locate gNodeB with ip address {}", (Object)data.getIpAddress());
        }
    }

    public void disconnectAllUEsForNode(SCADAAsset node) {
        String cellId = node.getCellId();
        if (cellId != null && !cellId.isEmpty()) {
            List imsiList = this.dataRepository.findByCellId(cellId);
            for (IMSI imsi : imsiList) {
                imsi.setConnected(Boolean.valueOf(false));
                imsi.setIpAddress(null);
                imsi.setImsIpAddress(null);
                imsi.setUpdatedOn(Long.valueOf(Instant.now().getEpochSecond()));
                imsi.setUlData(Long.valueOf(0L));
                imsi.setDlData(Long.valueOf(0L));
                imsi.setUpdatedBy(Constants.hostName);
                this.dataRepository.save((Object)imsi);
                this.pduSessionInfoRepository.deleteByImsi(imsi.getImsiNumber());
                logger.info("Disconnected IMSI: {} for cellId: {}", (Object)imsi.getImsiNumber(), (Object)cellId);
            }
            logger.info("Disconnected {} UEs for cellId: {}", (Object)imsiList.size(), (Object)cellId);
        } else {
            logger.warn("Node has no cellId configured: {}", (Object)node.getId());
        }
    }
}

