/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.messaging.controller;

import com.coraltele.telemetry.helper.Messaging;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.SnmpService;
import com.coraltele.telemetry.model.ExtensionModel;
import com.coraltele.telemetry.service.coralnms.outage.model.OutageModel;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.SensorAttributeModel;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.TelemetryModel;
import com.coraltele.telemetry.service.coralnms.sensor_data.service.SensorDataService;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/message/request"})
@RestController
public class MessageController {
    private static final Logger logger = LogManager.getLogger(MessageController.class);
    @Autowired
    SensorDataService sensorDataService;
    @Autowired
    SCADAAssetService scadaAssetService;
    @Autowired
    SnmpService snmpService;

    public MessageController(SimpMessagingTemplate simpMessagingTemplate) {
        Messaging.setMessagingTemplate((SimpMessagingTemplate)simpMessagingTemplate);
    }

    @PostMapping(value={"/sendExtensionEvent"})
    public ResponseEntity<RequestResponse> sendEvent(@RequestBody ExtensionModel extension) {
        logger.info("Received Extension event");
        try {
            this.snmpService.sendExtensionUpdate(extension);
        }
        catch (Exception ex) {
            logger.error("Sending message", (Throwable)ex);
        }
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(0);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/sendMessage"})
    public ResponseEntity<RequestResponse> sendEvent(@RequestBody OutageModel message) {
        logger.info("Sending message : 1");
        try {
            ObjectMapper obj = new ObjectMapper();
            String data = obj.writeValueAsString((Object)message);
            logger.info("Sending message : {}", (Object)data);
            Messaging.getMessagingTemplate().convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", "events"), (Object)data);
        }
        catch (Exception ex) {
            logger.error("Sending message", (Throwable)ex);
        }
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(0);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/sendTelemetry"})
    public ResponseEntity<RequestResponse> sendEvent(@RequestBody TelemetryModel message) {
        logger.info("Sending message : 1");
        try {
            this.sensorDataService.saveTelemetryData(message);
            for (SensorAttributeModel attribute : message.getAttributes()) {
                attribute.setStatus(Integer.valueOf(0));
                attribute.setMessage("OK");
            }
            ObjectMapper obj = new ObjectMapper();
            String data = obj.writeValueAsString((Object)message);
            logger.info("Sending message : {}", (Object)data);
            Messaging.getMessagingTemplate().convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", "telemetry"), (Object)data);
        }
        catch (Exception ex) {
            logger.error("Sending message", (Throwable)ex);
        }
        RequestResponse returnValue = new RequestResponse();
        returnValue.setStatus(0);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

