/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.ManualAlertClose;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertHistoryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertViewRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.CategoryServiceRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.ManualAlertCloseRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.discovery.ServiceStatus;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import com.coraltele.telemetry.service.main.model.AlertModel;
import com.coraltele.telemetry.service.main.model.AlertWithImageModel;
import com.coraltele.telemetry.service.main.model.IAlertSummary;
import com.coraltele.telemetry.service.main.model.ManualAlertCloseModel;
import com.coraltele.telemetry.service.main.severity.service.SeverityService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AlertService {
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    @Autowired
    AlertRepository alertRepository;
    @Autowired
    AlertViewRepository alertViewRepository;
    @Autowired
    AlertHistoryRepository alertHistoryRepository;
    @Autowired
    ManualAlertCloseRepository manualAlertCloseRepository;
    @Autowired
    SCADAAssetService scadaAssetService;
    @Autowired
    CategoryServiceRepository categoryServiceRepository;
    private static final Logger logger = LogManager.getLogger(SeverityService.class);

    public List<AlertModel> getActiveAlerts() {
        ArrayList<AlertModel> returnValue = new ArrayList<AlertModel>();
        this.alertViewRepository.findByStatusOrderBySeverityDescAlertGeneratedOnAsc(false).forEach(alert -> returnValue.add(new AlertModel(alert.getId(), alert.getAssetId(), alert.getCategoryName(), StringUtils.hasLength((String)alert.getAlias()) ? alert.getAlias() : alert.getServiceCode(), alert.isStatus(), alert.getAlertGeneratedOn(), alert.getAlertClosedOn(), alert.getIpAddress(), alert.getName(), alert.getAlias(), alert.getSeverity(), alert.getLocationCode(), alert.getAlertDescription(), alert.getServiceNumber())));
        return returnValue;
    }

    public List<AlertModel> getActiveAlertsForAsset(String assetId) {
        ArrayList<AlertModel> returnValue = new ArrayList<AlertModel>();
        Optional asset = this.scadaAssetRepository.findByUuid(UUID.fromString(assetId));
        if (asset.isPresent()) {
            this.alertRepository.findByAssetId(((SCADAAsset)asset.get()).getId()).forEach(alert -> returnValue.add(new AlertModel(alert.getId(), alert.getAssetId(), alert.getCategoryCode(), alert.getServiceCode(), alert.isStatus(), alert.getAlertGeneratedOn(), alert.getAlertClosedOn(), alert.getIpAddress(), alert.getName(), alert.getAlias(), alert.getSeverity(), alert.getLocationCode(), alert.getAlertDescription(), alert.getServiceNumber())));
        }
        return returnValue;
    }

    public List<AlertModel> getAlertHistoryForAsset(String assetId) {
        ArrayList<AlertModel> returnValue = new ArrayList<AlertModel>();
        Optional asset = this.scadaAssetRepository.findByUuid(UUID.fromString(assetId));
        if (asset.isPresent()) {
            this.alertHistoryRepository.findByAssetId(((SCADAAsset)asset.get()).getId()).forEach(alert -> returnValue.add(new AlertModel(alert.getId(), alert.getAssetId(), alert.getCategoryCode(), alert.getServiceCode(), alert.isStatus(), alert.getAlertGeneratedOn(), alert.getAlertClosedOn(), alert.getIpAddress(), alert.getName(), alert.getAlias(), alert.getSeverity(), alert.getLocationCode(), alert.getAlertDescription(), alert.getServiceNumber())));
        }
        return returnValue;
    }

    public List<IAlertSummary> getActiveAlertSummary() {
        return this.alertRepository.alertActiveSummary();
    }

    public List<AlertWithImageModel> getAlertNotification() {
        return this.alertRepository.selectAlertsWithImageName();
    }

    public RequestResponse getAll() {
        List list = (List)this.manualAlertCloseRepository.findAll();
        ArrayList<ManualAlertCloseModel> addValue = new ArrayList<ManualAlertCloseModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ManualAlertClose severity : list) {
            ManualAlertCloseModel data = new ManualAlertCloseModel();
            data.setAlertClosedOn(severity.getAlertClosedOn());
            data.setAssetId(severity.getAssetId());
            data.setCloseReason(severity.getCloseReason());
            data.setId(severity.getId());
            data.setUserId(severity.getUserId());
            data.setRemark(severity.getRemark());
            data.setServiceCode(severity.getServiceCode());
            addValue.add(data);
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse createAlertManualClose(ManualAlertCloseModel data) {
        logger.debug("manually create new alert : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            ManualAlertClose alertClose = new ManualAlertClose();
            alertClose.setAlertClosedOn(data.getAlertClosedOn());
            alertClose.setAssetId(data.getAssetId());
            alertClose.setCloseReason(data.getCloseReason());
            alertClose.setId(data.getId());
            alertClose.setUserId(data.getUserId());
            alertClose.setRemark(data.getRemark());
            alertClose.setServiceCode(data.getServiceCode());
            this.manualAlertCloseRepository.save((Object)alertClose);
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("manually alert created successfully");
            logger.info(returnValue.getMessage());
            List allScadaAssets = this.scadaAssetRepository.findAll();
            for (SCADAAsset asset : allScadaAssets) {
                ServiceStatus serviceStatus = new ServiceStatus();
                serviceStatus.setAssetId(data.getAssetId());
                serviceStatus.setAlias("");
                serviceStatus.setCategory(asset.getCategory());
                serviceStatus.setIpAddress(asset.getIpAddress());
                serviceStatus.setName(asset.getNodeName());
                serviceStatus.setService(data.getServiceCode());
                serviceStatus.setSeverity(asset.getSeverity());
                serviceStatus.setSlot(null);
                serviceStatus.setStatus(Boolean.valueOf(true));
                serviceStatus.setStatusDetail("");
                this.scadaAssetService.updateServiceStatus(serviceStatus);
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to create manually alert");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(ManualAlertCloseModel data) {
        logger.debug("Update category {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional closeAlert = this.manualAlertCloseRepository.findById((Object)data.getId());
        if (!closeAlert.isPresent()) {
            returnValue.setStatus(0);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("category not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getAlertClosedOn() != null) {
            ((ManualAlertClose)closeAlert.get()).setAlertClosedOn(data.getAlertClosedOn());
        }
        if (data.getAssetId() != null) {
            ((ManualAlertClose)closeAlert.get()).setAssetId(data.getAssetId());
        }
        if (data.getCloseReason() != null) {
            ((ManualAlertClose)closeAlert.get()).setCloseReason(data.getCloseReason());
        }
        if (data.getId() != null) {
            ((ManualAlertClose)closeAlert.get()).setId(data.getId());
        }
        if (data.getUserId() != null) {
            ((ManualAlertClose)closeAlert.get()).setUserId(data.getUserId());
        }
        if (data.getRemark() != null) {
            ((ManualAlertClose)closeAlert.get()).setRemark(data.getRemark());
        }
        if (data.getServiceCode() != null) {
            ((ManualAlertClose)closeAlert.get()).setServiceCode(data.getServiceCode());
        }
        this.manualAlertCloseRepository.save(closeAlert.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("category Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteManualAlert(String id) {
        logger.debug("Delete alert id {}", (Object)id);
        RequestResponse returnValue = new RequestResponse();
        Optional manualclose = this.manualAlertCloseRepository.findById((Object)id);
        if (manualclose.isPresent()) {
            try {
                this.manualAlertCloseRepository.deleteById((Object)id);
                returnValue.setStatus(0);
                returnValue.setMessage("manual alert deleted");
                logger.info(returnValue.getMessage());
            }
            catch (Exception ex) {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to delete alert");
                returnValue.setMessageDetail("Contact with your administrator");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to delete record");
            returnValue.setMessageDetail("Record Not found");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse getById(String id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional location = this.manualAlertCloseRepository.findById((Object)id);
            if (location.isPresent()) {
                ManualAlertCloseModel data = new ManualAlertCloseModel();
                data.setId(((ManualAlertClose)location.get()).getId());
                data.setAlertClosedOn(((ManualAlertClose)location.get()).getAlertClosedOn());
                data.setAssetId(((ManualAlertClose)location.get()).getAssetId());
                data.setCloseReason(((ManualAlertClose)location.get()).getCloseReason());
                data.setUserId(((ManualAlertClose)location.get()).getUserId());
                data.setRemark(((ManualAlertClose)location.get()).getRemark());
                data.setServiceCode(((ManualAlertClose)location.get()).getServiceCode());
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
        }
        return returnValue;
    }
}

