/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.model.ICC4Card;
import com.coraltele.telemetry.model.ICC4Packet;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class MediaGateway {
    private static final Logger logger = LogManager.getLogger(MediaGateway.class);

    private MediaGateway() {
    }

    public static String connectPacket() {
        String returnValue = "";
        returnValue = returnValue + "<CAcd>" + System.lineSeparator();
        returnValue = returnValue + "<Connect>" + System.lineSeparator();
        returnValue = returnValue + "        <Client Name=\"Coral telecom\"/>" + System.lineSeparator();
        returnValue = returnValue + "        <Invoke Value=\"abc\" />" + System.lineSeparator();
        returnValue = returnValue + "        <Password Value=\" \"/>" + System.lineSeparator();
        returnValue = returnValue + "</Connect>" + System.lineSeparator();
        returnValue = returnValue + "</CAcd>" + System.lineSeparator();
        return returnValue;
    }

    public static ICC4Packet parseXML(List<String> xmlLines, String mediaGatewayIP) throws ParserConfigurationException, SAXException, IOException {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        xml.append("<Ngx_ACD_Server>");
        logger.info("XML to be parsed {} {}", (Object)mediaGatewayIP, xmlLines);
        ICC4Packet returnValue = new ICC4Packet();
        for (String line : xmlLines) {
            logger.info("XML to be parsed {} {}", (Object)mediaGatewayIP, (Object)line);
            if ((line = line.trim()).startsWith("*") || line.trim().isEmpty() || line.startsWith("<?xml") || line.startsWith("<Ngx_ACD_Server>") || line.startsWith("</Ngx_ACD_Server>") || line.startsWith("<Sacd>") || line.startsWith("</Sacd>")) continue;
            if (line.trim().equals("<Acdpktg/>")) {
                returnValue.setHasHandshakeComplete(Boolean.valueOf(true));
                continue;
            }
            xml.append(line);
        }
        xml.append("</Ngx_ACD_Server>");
        logger.info("XML to be parsed {} {}", (Object)mediaGatewayIP, (Object)xml);
        ByteArrayInputStream targetStream = new ByteArrayInputStream(xml.toString().getBytes());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(targetStream);
        document.getDocumentElement().normalize();
        Element rootNode = document.getDocumentElement();
        NodeList nList = rootNode.getChildNodes();
        for (int packets = 0; packets < nList.getLength(); ++packets) {
            Node node = nList.item(packets);
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("AcdpktA")) {
                ICC4Card card = new ICC4Card();
                NodeList properties = node.getChildNodes();
                for (int property = 0; property < properties.getLength(); ++property) {
                    Node cardProperty = properties.item(property);
                    if (cardProperty.getNodeType() != 1) continue;
                    if (cardProperty.getNodeName().equals("Slot")) {
                        card.setSlot(cardProperty.getAttributes().getNamedItem("Value").getTextContent());
                        continue;
                    }
                    if (cardProperty.getNodeName().equals("Card_name")) {
                        card.setCardName(cardProperty.getAttributes().getNamedItem("Value").getTextContent());
                        continue;
                    }
                    if (cardProperty.getNodeName().equals("State")) {
                        card.setState(cardProperty.getAttributes().getNamedItem("Value").getTextContent());
                        continue;
                    }
                    if (!cardProperty.getNodeName().equals("SName")) continue;
                    card.setStateName(cardProperty.getAttributes().getNamedItem("Value").getTextContent());
                }
                returnValue.getCards().add(card);
                continue;
            }
            if (!node.getNodeName().equals("AcdpktB")) continue;
            NodeList properties = node.getChildNodes();
            for (int property = 0; property < properties.getLength(); ++property) {
                Node resourceProperty = properties.item(property);
                ICC4Card card = new ICC4Card();
                if (resourceProperty.getNodeType() != 1) continue;
                if (resourceProperty.getNodeName().equals("Cpu0")) {
                    card.setCardName("CPU1");
                    card.setSlot("-10");
                    MediaGateway.setCPUAvailability((ICC4Card)card, (String)resourceProperty.getAttributes().getNamedItem("Value").getTextContent());
                    returnValue.getCards().add(card);
                    continue;
                }
                if (resourceProperty.getNodeName().equals("Cpu1")) {
                    card.setCardName("CPU2");
                    card.setSlot("-9");
                    MediaGateway.setCPUAvailability((ICC4Card)card, (String)resourceProperty.getAttributes().getNamedItem("Value").getTextContent());
                    returnValue.getCards().add(card);
                    continue;
                }
                if (resourceProperty.getNodeName().equals("PS1_Stat")) {
                    card.setCardName("PS1");
                    card.setSlot("-8");
                    MediaGateway.setAvailability((ICC4Card)card, (String)resourceProperty.getAttributes().getNamedItem("Value").getTextContent());
                    returnValue.getCards().add(card);
                    continue;
                }
                if (!resourceProperty.getNodeName().equals("PS2_Stat")) continue;
                card.setCardName("PS2");
                card.setSlot("-7");
                MediaGateway.setAvailability((ICC4Card)card, (String)resourceProperty.getAttributes().getNamedItem("Value").getTextContent());
                returnValue.getCards().add(card);
            }
        }
        ObjectMapper objectMapper = new ObjectMapper();
        String data = objectMapper.writeValueAsString((Object)returnValue);
        logger.info("Processing individual packet {} {}", (Object)mediaGatewayIP, (Object)data);
        return returnValue;
    }

    private static void setCPUAvailability(ICC4Card card, String value) {
        String[] parameters = value.split(" ");
        if (parameters[2].equals("PRESENT")) {
            card.setState("7");
            if (parameters[1].equals("M")) {
                card.setStateName("MASTER");
            } else {
                card.setStateName("SLAVE");
            }
        } else if (parameters[2].equals("ABSENT")) {
            card.setState("7");
            card.setStateName(parameters[2]);
        } else {
            card.setState("5");
            card.setStateName(parameters[2]);
        }
    }

    private static void setAvailability(ICC4Card card, String value) {
        String[] parameters = value.split(" ");
        if (parameters[1].equals("PRESENT") || parameters[1].equals("ABSENT")) {
            card.setState("7");
        } else {
            card.setState("5");
        }
        card.setStateName(parameters[1]);
    }
}

