/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.telemetry.main.repository;

import com.coraltele.telemetry.db.telemetry.main.entity.Alert;
import com.coraltele.telemetry.service.main.model.AlertWithImageModel;
import com.coraltele.telemetry.service.main.model.IAlertSummary;
import com.coraltele.telemetry.service.main.model.IAssetAlertStatus;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface AlertRepository
extends CrudRepository<Alert, Long> {
    public Optional<Alert> findByAssetIdAndServiceCode(Long var1, String var2);

    public Optional<Alert> findByAssetIdAndServiceCodeAndServiceNumber(Long var1, String var2, String var3);

    public List<Alert> findByStatus(boolean var1);

    public Optional<Alert> findByUuid(String var1);

    public List<Alert> findByAssetIdAndPendingForSync(Long var1, Integer var2);

    public List<Alert> findByAssetId(Long var1);

    @Query(value="SELECT coalesce(alias,servicecode) as service, COUNT(*) as count FROM alert WHERE status = false GROUP BY coalesce(alias,servicecode) ORDER BY coalesce(alias,servicecode)", nativeQuery=true)
    public List<IAlertSummary> alertActiveSummary();

    @Query(value="SELECT  count(*) as alerts, max(severity) as severity FROM alert where assetid=?1 and status = false", nativeQuery=true)
    public IAssetAlertStatus getAssetAlertStatus(Long var1);

    @Query(value="SELECT a.id,a.alertgeneratedon,a.name,a.severity,a.categorycode,a.servicecode,c.image_name AS imageName FROM public.alert AS a INNER JOIN coralnms.m_category AS c ON a.categoryCode = c.code WHERE a.status = false", nativeQuery=true)
    public List<AlertWithImageModel> selectAlertsWithImageName();

    @Modifying
    @Transactional
    @Query(value="UPDATE Alert a SET a.uuid = gen_random_uuid() WHERE a.uuid is null OR a.uuid = ''")
    public void updateUUID();

    @Modifying
    @Transactional
    @Query(value="UPDATE Alert a SET a.escalationLevel = :escalationLevel, a.escalationEpoch = :escalationEpoch WHERE a.id = :id")
    public void updateEscalationLevel(@Param(value="id") Long var1, @Param(value="escalationLevel") Integer var2, @Param(value="escalationEpoch") Long var3);
}

