/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.bootstrap;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.coraltele.telemetry.db.telemetry.coralnms.repository", "com.coraltele.telemetry.db.telemetry.main.repository", "com.coraltele.telemetry.db.telemetry.chat.repository"}, entityManagerFactoryRef="telemetryEntityManagerFactory", transactionManagerRef="telemetryTransactionManager")
public class TelemetryDataSourceConfiguration {
    @Bean
    @ConfigurationProperties(value="spring.datasource.telemetry")
    public DataSource telemetryDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"telemetryEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean telemetryEntityManagerFactory() {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.telemetryDataSource());
        em.setPackagesToScan(new String[]{"com.coraltele.telemetry.db.telemetry"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.dialect", "org.hibernate.spatial.dialect.postgis.PostgisDialect");
        properties.put("hibernate.hbm2ddl.auto", "update");
        em.setJpaPropertyMap(properties);
        return em;
    }

    @Bean(name={"telemetryTransactionManager"})
    public PlatformTransactionManager telemetryTransactionManager(@Qualifier(value="telemetryEntityManagerFactory") EntityManagerFactory telemetryEntityManagerFactory) {
        return new JpaTransactionManager(telemetryEntityManagerFactory);
    }

    @Bean(name={"telemetryJdbcTemplate"})
    public JdbcTemplate telemetryJdbcTemplate(@Qualifier(value="telemetryDataSource") DataSource telemetryDataSource) {
        return new JdbcTemplate(telemetryDataSource);
    }
}

