/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnablePortMonitoring;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.MonitorService;
import com.coraltele.telemetry.db.telemetry.main.repository.CategoryServiceRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.MonitorServiceRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.model.discovery.ServiceStatus;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Conditional(value={EnablePortMonitoring.class})
public class MonitorServiceProcess {
    private static final Logger logger = LogManager.getLogger(MonitorServiceProcess.class);
    private final RestTemplate restTemplate;
    private final HttpEntity<String> entity;
    private final HttpHeaders headers;
    @Autowired
    MonitorServiceRepository monitorServiceRepository;
    @Autowired
    CategoryServiceRepository categoryServiceRepository;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    @Autowired
    SCADAAssetService scadaAssetService;
    private final int INITIAL_CORE_POOL_SIZE = 10;
    private final int MAX_POOL_SIZE = 100;
    private final long KEEP_ALIVE_TIME = 10L;
    private final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 100, 10L, this.TIME_UNIT, new LinkedBlockingQueue<Runnable>());
    private final Map<String, Future<?>> portMonitors = new ConcurrentHashMap();

    public MonitorServiceProcess(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
        this.headers = new HttpHeaders();
        this.headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
        this.headers.setContentType(MediaType.APPLICATION_JSON);
        this.headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        this.entity = new HttpEntity((MultiValueMap)this.headers);
    }

    @Scheduled(fixedRate=5000L)
    public void startService() {
        HashMap serviceList = new HashMap();
        this.monitorServiceRepository.findAllWithPortNumberMethodAndDuration().forEach(service -> serviceList.put(service.getCode(), service));
        for (Map.Entry entry : this.portMonitors.entrySet()) {
            String port = (String)entry.getKey();
            Future future = (Future)entry.getValue();
            if (future.isDone()) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    logger.info("Port monitoring service for {} is not active", (Object)port, (Object)e);
                }
                this.portMonitors.remove(port);
            }
            if (serviceList.containsKey(port)) continue;
            future.cancel(true);
            this.portMonitors.remove(port);
            logger.info("Port monitoring service for {} is removed", (Object)port);
        }
        for (Map.Entry service2 : serviceList.entrySet()) {
            if (this.portMonitors.containsKey(service2.getKey())) continue;
            logger.info("Port monitoring service for {} is starting", (Object)((MonitorService)service2.getValue()).getCode());
            this.monitorServicePort((MonitorService)service2.getValue());
            logger.info("Port monitoring service for {} is started", (Object)((MonitorService)service2.getValue()).getCode());
        }
    }

    private void monitorServicePort(MonitorService service) {
        Future<?> future = this.executor.submit(() -> {
            try {
                while (true) {
                    logger.info("Categories for service {}", (Object)service.getCode());
                    this.categoryServiceRepository.findAllByServiceCode(service.getCode()).forEach(category -> {
                        logger.info("Assets for service {}, category {}", (Object)service.getCode(), (Object)category.getCategoryCode());
                        this.scadaAssetRepository.findAllByCategory(category.getCategoryCode()).forEach(asset -> {
                            String restURL;
                            logger.info("Assets for service {}, category {}, asset {} ", (Object)service.getCode(), (Object)category.getCategoryCode(), (Object)asset.getNodeName());
                            boolean status = false;
                            if (service.getMethod().equals("PORT")) {
                                status = this.checkPort(asset.getIpAddress(), service.getPortNumber().intValue());
                            } else if (service.getMethod().equals("GET")) {
                                try {
                                    restURL = service.getUrl().replace("$$ip", asset.getIpAddress());
                                    ResponseEntity response = this.restTemplate.exchange(restURL, HttpMethod.GET, null, String.class, new Object[0]);
                                    if (response.getStatusCode() == HttpStatus.OK || response.getStatusCode() == HttpStatus.ACCEPTED) {
                                        status = true;
                                    }
                                }
                                catch (Exception e) {
                                    logger.error("Unable to validate service {}, category {}, asset {} ", (Object)service.getCode(), (Object)category.getCategoryCode(), (Object)asset.getNodeName(), (Object)e);
                                }
                            } else if (service.getMethod().equals("GET-NODE")) {
                                try {
                                    restURL = service.getUrl().replace("$$ip", asset.getIpAddress());
                                    ResponseEntity response = this.restTemplate.exchange(restURL, HttpMethod.GET, this.entity, String.class, new Object[0]);
                                    if (response.getStatusCode() == HttpStatus.OK || response.getStatusCode() == HttpStatus.ACCEPTED) {
                                        status = true;
                                    }
                                }
                                catch (Exception e) {
                                    logger.error("Unable to validate service {}, category {}, asset {} ", (Object)service.getCode(), (Object)category.getCategoryCode(), (Object)asset.getNodeName(), (Object)e);
                                }
                            } else if (service.getMethod().equals("POST-NODE")) {
                                String ipAddress = asset.getIpAddress();
                                String restURL2 = service.getUrl().replace("$$ip", ipAddress);
                                String data = service.getData().replace("$$ip", ipAddress);
                                data = data.replace("$$port", service.getPortNumber().toString());
                                try {
                                    HttpEntity dataToPost = new HttpEntity((Object)data, (MultiValueMap)this.headers);
                                    ResponseEntity response = this.restTemplate.exchange(restURL2, HttpMethod.POST, dataToPost, String.class, new Object[0]);
                                    if (response.getStatusCode() == HttpStatus.OK || response.getStatusCode() == HttpStatus.ACCEPTED) {
                                        status = true;
                                    }
                                }
                                catch (Exception e) {
                                    logger.error("Unable to validate service {}, category {}, asset {}, url {} ", (Object)service.getCode(), (Object)category.getCategoryCode(), (Object)asset.getNodeName(), (Object)restURL2, (Object)e);
                                }
                            }
                            ServiceStatus serviceStatus = new ServiceStatus();
                            serviceStatus.setAlias(service.getServiceName());
                            serviceStatus.setAssetId(asset.getId());
                            serviceStatus.setCategory(category.getCategoryCode());
                            serviceStatus.setIpAddress(asset.getIpAddress());
                            serviceStatus.setName(asset.getNodeName());
                            serviceStatus.setService(service.getCode());
                            serviceStatus.setSeverity(category.getSeverity());
                            serviceStatus.setStatus(Boolean.valueOf(status));
                            this.scadaAssetService.updateServiceStatus(serviceStatus);
                        });
                    });
                    Thread.sleep((long)service.getDuration().intValue() * 1000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        });
        this.portMonitors.put(service.getCode(), future);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkPort(String ip, int port) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(ip, port), 1000);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }
}

