/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.messaging.service;

import com.coraltele.telemetry.db.telemetry.main.entity.RegistrationAlert;
import com.coraltele.telemetry.db.telemetry.main.repository.RegistrationAlertRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.ExtensionRegistrationsEventModel;
import java.time.Instant;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ExtensionDetailsService {
    private static final Logger logger = LogManager.getLogger(ExtensionDetailsService.class);
    @Autowired
    private RegistrationAlertRepository registrationAlertRepository;
    @Autowired
    private ExtensionRepository extensionRepository;

    public ExtensionDetailsService() {
        logger.info("Extension Registration Details Service Started");
        Constants.extensionDetailsService = this;
    }

    public void createRegisteredExtension(ExtensionRegistrationsEventModel data) {
        logger.info("Extension Registered data : {}", (Object)data);
        Optional isExtensionPresent = this.registrationAlertRepository.findByExtension(data.getExtension());
        if (isExtensionPresent.isPresent()) {
            RegistrationAlert updatedExtension = (RegistrationAlert)isExtensionPresent.get();
            updatedExtension.setRegistrationExpiresEpoch(Long.valueOf(Instant.now().getEpochSecond() + (long)data.getExpireTime().intValue()));
            updatedExtension.setExtensionStatus(Boolean.valueOf(true));
            updatedExtension.setAlertStatusUpdatedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            updatedExtension.setIpAddress(data.getIpAddress());
            updatedExtension.setPort(data.getPort());
            this.registrationAlertRepository.save((Object)updatedExtension);
            logger.info("Update Extension Details Success for : {}", (Object)data.getExtension());
        } else {
            RegistrationAlert newExtension = new RegistrationAlert();
            newExtension.setExtension(data.getExtension());
            newExtension.setAlertCreatedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            newExtension.setExtensionStatus(Boolean.valueOf(true));
            newExtension.setIpAddress(data.getIpAddress());
            newExtension.setRegistrationExpiresEpoch(Long.valueOf(Instant.now().getEpochSecond() + (long)data.getExpireTime().intValue()));
            newExtension.setAlertStatusUpdatedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            newExtension.setPort(data.getPort());
            Optional extensionPresent = this.extensionRepository.findByExtension(newExtension.getExtension());
            if (extensionPresent.isPresent() && StringUtils.hasText((String)((Extension)extensionPresent.get()).getExtensionType())) {
                newExtension.setExtensionType(((Extension)extensionPresent.get()).getExtensionType());
            } else {
                newExtension.setExtensionType("");
            }
            this.registrationAlertRepository.save((Object)newExtension);
            logger.info("Extension Details Created Success for : {}", (Object)data.getExtension());
        }
    }

    public void updateRegisteredExtension(ExtensionRegistrationsEventModel data) {
        logger.info("Extension De Registered data : {}", (Object)data.getExtension());
        Optional isExtensionPresent = this.registrationAlertRepository.findByExtension(data.getExtension());
        if (isExtensionPresent.isPresent()) {
            RegistrationAlert updatedExtension = (RegistrationAlert)isExtensionPresent.get();
            updatedExtension.setExtensionStatus(Boolean.valueOf(false));
            updatedExtension.setAlertStatusUpdatedEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            this.registrationAlertRepository.save((Object)updatedExtension);
        } else {
            logger.info("Extension is not present with extension no :{}", (Object)data.getExtension());
        }
    }
}

