/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.pbx;

import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtensionService {
    @Autowired
    ExtensionRepository extensionRepository;
    @Autowired
    UserRepository userRepository;

    public String getDepartment(String extension) {
        Optional data = this.extensionRepository.findByExtension(extension);
        if (data.isPresent()) {
            return ((Extension)data.get()).getDepartment();
        }
        return "";
    }

    public String getExtensionOfUser(String username) {
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            String contactNo = ((User)user.get()).getContactNo();
            return contactNo;
        }
        return "";
    }

    public void updateDepartment(String extension, String department) {
        Optional getExt = this.extensionRepository.findByExtension(extension);
        if (getExt.isPresent()) {
            ((Extension)getExt.get()).setDepartment(department);
            this.extensionRepository.save(getExt.get());
        }
    }

    public String getDesignation(String extension) {
        if (extension != null) {
            Optional extensionData = this.extensionRepository.findByExtension(extension);
            if (extensionData.isPresent()) {
                String designation = ((Extension)extensionData.get()).getDesignation();
                return designation;
            }
            return "";
        }
        return "";
    }

    public String getDesignationByUsername(String username) {
        return this.userRepository.findByUsername(username).map(User::getContactNo).flatMap(arg_0 -> ((ExtensionRepository)this.extensionRepository).findByExtension(arg_0)).map(Extension::getDesignation).orElse("");
    }
}

