/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.EventNotification;
import com.coraltele.telemetry.helper.HttpUtils;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.ChatModel;
import com.coraltele.telemetry.model.NFStatusDetailsModel;
import com.coraltele.telemetry.service.coralnms.data.model.CallData;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.ChannelMessage;
import com.coraltele.telemetry.service.main.eventNotification.model.EventNotifyModel;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ini4j.Ini;
import org.ini4j.Profile;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpUtils {
    private static final Logger logger = LogManager.getLogger(HttpUtils.class);
    private static final String[] IP_HEADERS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};

    private HttpUtils() {
    }

    public static String getWebsocketAPI() {
        String returnValue = MessageFormat.format("http://{0}:8989", "127.0.0.1");
        return returnValue;
    }

    public static String getSysConfigAPI() {
        String returnValue = MessageFormat.format("http://{0}", "127.0.0.1");
        return returnValue;
    }

    public static String getRequestIp(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-ORIG-IP");
        if (xForwardedFor != null) {
            return xForwardedFor.split(",")[0];
        }
        return "Invalid IP";
    }

    public static String getIpHolder(HttpServletRequest request) {
        String ip = HttpUtils.getRequestIp((HttpServletRequest)request);
        if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0:0:0:0:1")) {
            return "Internal";
        }
        return "External";
    }

    public static Long searchPhoneNumber(Long phoneNumber) {
        String value = "           " + phoneNumber.toString();
        value = value.substring(value.length() - 10, value.length());
        return Long.valueOf(value.trim());
    }

    public static Long searchPhoneNumber(String phoneNumber) {
        String value = "           " + phoneNumber.replace("+", "");
        value = value.substring(value.length() - 10, value.length());
        return Long.valueOf(value.trim());
    }

    public static String sendToWebSocket(ChannelMessage message) {
        String result = "";
        try {
            String url = Constants.WEB_SOCKET_URL + "/sendEvent";
            logger.info("Send event to websocket {}", (Object)url);
            HttpPost post = new HttpPost(url);
            ObjectMapper objectMapper = new ObjectMapper();
            String data = objectMapper.writeValueAsString((Object)message);
            post.addHeader("content-type", "application/json");
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        catch (Exception E) {
            return null;
        }
        return result;
    }

    public static String sendNotificationToWebSocket(EventNotification message) {
        String result = "";
        String data = "";
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            data = objectMapper.writeValueAsString((Object)message);
        }
        catch (Exception e) {
            logger.error("Unable to parse the message");
        }
        try {
            String url = Constants.WEB_SOCKET_URL + "/sendUserNotification";
            logger.info("Send event to websocket {}", (Object)url);
            HttpPost post = new HttpPost(url);
            post.addHeader("content-type", "application/json");
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            logger.error("HTTP Called : for {}", (Object)data);
        }
        catch (Exception E) {
            logger.error("Unable to send data event : {}", (Object)data, (Object)E);
        }
        return result;
    }

    public static String sendAlertToWebSocket(EventNotifyModel message) {
        String result = "";
        String data = "";
        String clusterKey = HttpUtils.getClusterKey();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            data = objectMapper.writeValueAsString((Object)message);
        }
        catch (Exception e) {
            logger.error("Unable to parse the message");
        }
        try {
            String url = Constants.PPDR_SOCKET_URL;
            System.out.println("Send event to websocket: " + url);
            HttpPost post = new HttpPost(url);
            post.addHeader("Content-Type", "application/json");
            post.addHeader("Authorization", "CLUSTER " + clusterKey);
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            logger.info("Send event to websocket {}", (Object)url);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            logger.error("HTTP Called : for {}", (Object)data);
        }
        catch (Exception E) {
            logger.error("Unable to send data event : {}", (Object)data, (Object)E);
        }
        return result;
    }

    public static String sendTextMessage(ChatModel.OutboundMessage message) {
        String result = "";
        String data = "";
        String clusterKey = HttpUtils.getClusterKey();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            data = objectMapper.writeValueAsString((Object)message);
        }
        catch (Exception e) {
            logger.error("Unable to parse the message");
        }
        try {
            String url = "http://127.0.0.1/ppdr/api/v2/broadcast/sendTextMessage";
            logger.info("Send text message to PPDR {}", (Object)url);
            HttpPost post = new HttpPost(url);
            post.addHeader("Content-Type", "application/json");
            post.addHeader("Authorization", "Cluster " + clusterKey);
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            logger.error("HTTP Called : for {}", (Object)data);
        }
        catch (Exception E) {
            logger.error("Unable to send data event : {}", (Object)data, (Object)E);
        }
        return result;
    }

    public static List<NFStatusDetailsModel> getRemoteNFServices(String ipAddress) {
        List<Object> returnValue = null;
        try {
            String url = "http://" + ipAddress + "/telemetry/api/v2/data/nf-status";
            logger.info("Fetching NF services from {}", (Object)url);
            HttpGet get = new HttpGet(url);
            get.addHeader("Content-Type", "application/json");
            get.addHeader("Authorization", "Cluster " + Constants.CLUSTER_KEY);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                ObjectMapper objectMapper = new ObjectMapper();
                1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
                RequestResponse responseObj = (RequestResponse)objectMapper.readValue(result, (TypeReference)typeRef);
                if (responseObj != null && responseObj.getData() != null) {
                    returnValue = (List)objectMapper.convertValue(responseObj.getData(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, NFStatusDetailsModel.class));
                }
                logger.info("HTTP Called successfully for {}", (Object)url);
            }
            catch (Exception E) {
                logger.error("Unable to fetch NF services from {}: {}", (Object)ipAddress, (Object)E.getMessage(), (Object)E);
                returnValue = new ArrayList();
            }
        }
        catch (Exception E) {
            logger.error("Unable to fetch NF services from {}: {}", (Object)ipAddress, (Object)E.getMessage(), (Object)E);
            returnValue = new ArrayList<NFStatusDetailsModel>();
        }
        return returnValue;
    }

    public static List<CallData> getRemoteCalls(String ipAddress) {
        List<Object> returnValue = null;
        try {
            String url = "http://" + ipAddress + "/telemetry/api/v2/data/ims-v2/active-calls";
            logger.info("Fetching Active calls from {}", (Object)url);
            HttpGet get = new HttpGet(url);
            get.addHeader("Content-Type", "application/json");
            get.addHeader("Authorization", "Cluster " + Constants.CLUSTER_KEY);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                ObjectMapper objectMapper = new ObjectMapper();
                2 typeRef = new /* Unavailable Anonymous Inner Class!! */;
                RequestResponse responseObj = (RequestResponse)objectMapper.readValue(result, (TypeReference)typeRef);
                if (responseObj != null && responseObj.getData() != null) {
                    returnValue = (List)objectMapper.convertValue(responseObj.getData(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, CallData.class));
                }
                logger.info("HTTP Called successfully for {}", (Object)url);
            }
            catch (Exception E) {
                logger.error("Unable to fetch NF services from {}: {}", (Object)ipAddress, (Object)E.getMessage(), (Object)E);
                returnValue = new ArrayList();
            }
        }
        catch (Exception E) {
            logger.error("Unable to fetch NF services from {}: {}", (Object)ipAddress, (Object)E.getMessage(), (Object)E);
            returnValue = new ArrayList<CallData>();
        }
        return returnValue;
    }

    public static String sendStreamStatus(ChatModel.VideoStreamStatus message) {
        String result = "";
        String data = "";
        String clusterKey = HttpUtils.getClusterKey();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            data = objectMapper.writeValueAsString((Object)message);
        }
        catch (Exception e) {
            logger.error("Unable to parse the message");
        }
        try {
            String url = "http://127.0.0.1/ppdr/api/v2/broadcast/updateGroupStreamStatus";
            logger.info("Send text message to PPDR {}", (Object)url);
            HttpPost post = new HttpPost(url);
            post.addHeader("Content-Type", "application/json");
            post.addHeader("Authorization", "Cluster " + clusterKey);
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                result = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            logger.error("HTTP Called : for {}", (Object)data);
        }
        catch (Exception E) {
            logger.error("Unable to send data event : {}", (Object)data, (Object)E);
        }
        return result;
    }

    public static String getClusterKey() {
        String clusterKey;
        block3: {
            String coralFilePath = "/etc/default/coral";
            clusterKey = "";
            try {
                Ini ini;
                File file = new File(coralFilePath);
                if (!file.exists() || !(ini = new Ini(file)).containsKey((Object)"CLUSTER")) break block3;
                Profile.Section cscfSection = (Profile.Section)ini.get((Object)"CLUSTER");
                if (cscfSection.containsKey((Object)"CLUSTER-KEY")) {
                    clusterKey = (String)cscfSection.get((Object)"CLUSTER-KEY");
                    break block3;
                }
                return "";
            }
            catch (Exception e) {
                e.getMessage();
            }
        }
        return clusterKey;
    }
}

