/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.model.BillingPeer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Base64;
import javax.annotation.PostConstruct;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Component;

@Component
public class ActiveMQProducer {
    private static final Logger logger = LoggerFactory.getLogger(ActiveMQProducer.class);
    private JmsTemplate jmsTemplate;
    private long timeToLiveMs;

    @PostConstruct
    public void init() {
        String brokerUrl = "tcp://" + Constants.ACTIVEMQ_IP_ADDRESS + ":9890";
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("admin", "admin", brokerUrl);
        this.jmsTemplate = new JmsTemplate((ConnectionFactory)connectionFactory);
        this.jmsTemplate.setDeliveryPersistent(true);
        this.timeToLiveMs = this.calculateTimeToLive();
        logger.debug("Setting message TTL to {} ms ({} days)", (Object)this.timeToLiveMs, (Object)Constants.BILLING_CACHE_DAYS);
        this.jmsTemplate.setTimeToLive(this.timeToLiveMs);
        logger.info("ActiveMQProducer initialized with broker URL: {}", (Object)brokerUrl);
    }

    public <T> void sendMessageToQueue(String dataType, T data) {
        ArrayList<String> queueNames = new ArrayList<String>();
        if (!Constants.BILLING_PEERS.isEmpty()) {
            for (BillingPeer peer : Constants.BILLING_PEERS) {
                String peerQueueName = dataType + "-" + peer.getNodeName();
                queueNames.add(peerQueueName);
                logger.debug("Added billing peer queue [{}] for node [{}]", (Object)peerQueueName, (Object)peer.getNodeName());
            }
        }
        if (Constants.BILLING_ENABLE_THIRD_PARTY_BILLING.booleanValue()) {
            queueNames.add(dataType + "-third-party");
            logger.debug("Added external billing queue due to third-party billing being enabled");
        }
        String jsonMessage = this.convertToJson(data);
        String encodedMessage = Base64.getEncoder().encodeToString(jsonMessage.getBytes());
        for (String queueName : queueNames) {
            try {
                this.jmsTemplate.convertAndSend(queueName, (Object)encodedMessage);
                logger.debug("Sent message to queue [{}] with TTL {} ms: {}", new Object[]{queueName, this.timeToLiveMs, jsonMessage});
            }
            catch (Exception e) {
                logger.error("Failed to send message to queue [{}] - Error: {}", new Object[]{queueName, e.getMessage(), e});
            }
        }
        if (!queueNames.isEmpty()) {
            logger.info("Billing data sent to {} queue(s): {}", (Object)queueNames.size(), (Object)String.join((CharSequence)", ", queueNames));
        } else {
            logger.warn("No queues configured for dataType: {}", (Object)dataType);
        }
    }

    private long calculateTimeToLive() {
        if (Constants.BILLING_CACHE_DAYS == null || Constants.BILLING_CACHE_DAYS <= 0) {
            logger.debug("No valid billing cache days configured, messages will not expire");
            return 0L;
        }
        long ttlMs = (long)Constants.BILLING_CACHE_DAYS.intValue() * 24L * 60L * 60L * 1000L;
        logger.debug("Calculated TTL: {} days = {} ms", (Object)Constants.BILLING_CACHE_DAYS, (Object)ttlMs);
        return ttlMs;
    }

    private <T> String convertToJson(T data) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString(data);
        }
        catch (Exception e) {
            logger.error("Error converting data to JSON", (Throwable)e);
            return "{}";
        }
    }
}

