/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.billing.entity.Channel;
import com.coraltele.telemetry.db.billing.entity.ChannelForBillingCdr;
import com.coraltele.telemetry.db.billing.entity.UcNotification;
import com.coraltele.telemetry.db.billing.entity.UserStatus;
import com.coraltele.telemetry.db.billing.entity.VoiceLogger;
import com.coraltele.telemetry.db.billing.repository.ChannelForBillingCdrRepository;
import com.coraltele.telemetry.db.billing.repository.ChannelRepository;
import com.coraltele.telemetry.db.billing.repository.UcNotificationRepository;
import com.coraltele.telemetry.db.billing.repository.UserStatusRepository;
import com.coraltele.telemetry.db.billing.repository.VoiceLoggerRepository;
import com.coraltele.telemetry.db.coralapps.entity.Agent;
import com.coraltele.telemetry.db.coralapps.entity.AgentRealTime;
import com.coraltele.telemetry.db.coralapps.entity.CallDataRecord;
import com.coraltele.telemetry.db.coralapps.entity.DynamicPopUpData;
import com.coraltele.telemetry.db.coralapps.entity.OperatorMaster;
import com.coraltele.telemetry.db.coralapps.entity.Queue;
import com.coraltele.telemetry.db.coralapps.entity.Tiers;
import com.coraltele.telemetry.db.coralapps.entity.UploadLeadData;
import com.coraltele.telemetry.db.coralapps.repository.AgentRealTimeRepository;
import com.coraltele.telemetry.db.coralapps.repository.AgentRepository;
import com.coraltele.telemetry.db.coralapps.repository.CallDataRecordRepository;
import com.coraltele.telemetry.db.coralapps.repository.DynamicPopUpDataRepository;
import com.coraltele.telemetry.db.coralapps.repository.OperatorMasterRepository;
import com.coraltele.telemetry.db.coralapps.repository.QueueRepository;
import com.coraltele.telemetry.db.coralapps.repository.TiersRepository;
import com.coraltele.telemetry.db.coralapps.repository.UploadLeadDataRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.ACDSummary;
import com.coraltele.telemetry.db.telemetry.main.entity.AgentCDR;
import com.coraltele.telemetry.db.telemetry.main.entity.AgentPerformance;
import com.coraltele.telemetry.db.telemetry.main.entity.BillingCDR;
import com.coraltele.telemetry.db.telemetry.main.entity.BillingCDRSummary;
import com.coraltele.telemetry.db.telemetry.main.entity.CampaignPerformance;
import com.coraltele.telemetry.db.telemetry.main.entity.CustomerCDR;
import com.coraltele.telemetry.db.telemetry.main.entity.LastAbandonedCdr;
import com.coraltele.telemetry.db.telemetry.main.entity.LastNAgentCDR;
import com.coraltele.telemetry.db.telemetry.main.entity.LeadPerformance;
import com.coraltele.telemetry.db.telemetry.main.entity.OperatorDailyBreakTime;
import com.coraltele.telemetry.db.telemetry.main.entity.PACDR;
import com.coraltele.telemetry.db.telemetry.main.entity.QueuePerformance;
import com.coraltele.telemetry.db.telemetry.main.entity.UcUserDetails;
import com.coraltele.telemetry.db.telemetry.main.entity.UserStatusDetails;
import com.coraltele.telemetry.db.telemetry.main.entity.WssUsers;
import com.coraltele.telemetry.db.telemetry.main.key.ACDSummaryCompositeKey;
import com.coraltele.telemetry.db.telemetry.main.key.AgentPerformanceCompositeKey;
import com.coraltele.telemetry.db.telemetry.main.key.BillingCDRSummaryCompositeKey;
import com.coraltele.telemetry.db.telemetry.main.key.CampaignPerformanceCompositeKey;
import com.coraltele.telemetry.db.telemetry.main.key.LastAbandonedCdrCompositeKey;
import com.coraltele.telemetry.db.telemetry.main.key.LeadPerformanceCompositeKey;
import com.coraltele.telemetry.db.telemetry.main.key.QueuePerformanceCompositeKey;
import com.coraltele.telemetry.db.telemetry.main.repository.ACDSummaryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AgentCDRRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AgentPerformanceRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.BillingCDRSummaryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.CampaignPerformanceRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.CustomerCDRRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.LastAbandonedCdrRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.LastNAgentCDRRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.LeadPerformanceRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.OperatorDailyBreakTimeRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.PACDRRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.QueuePerformanceRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.UcUserDetailsRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.UserStatusDetailsRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.WssUserRepository;
import com.coraltele.telemetry.db.telephony.billing.entity.Department;
import com.coraltele.telemetry.db.telephony.billing.repository.DepartmentRepository;
import com.coraltele.telemetry.db.telephony.main.entity.SipRegistrations;
import com.coraltele.telemetry.db.telephony.pbx.entity.DialCodeList;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.pbx.entity.GatewayMaster;
import com.coraltele.telemetry.db.telephony.pbx.entity.InboundGateway;
import com.coraltele.telemetry.db.telephony.pbx.repository.DialCodeListRepository;
import com.coraltele.telemetry.db.telephony.pbx.repository.GatewayMasterRepository;
import com.coraltele.telemetry.db.telephony.pbx.repository.InboundGatewayRepository;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.db.telephony.repository.SipRegistrationRepository;
import com.coraltele.telemetry.db.users.main.entity.Role;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.entity.UserRole;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRoleRepository;
import com.coraltele.telemetry.helper.ActiveMQProducer;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.DateFormatUtility;
import com.coraltele.telemetry.helper.GetAgentFullName;
import com.coraltele.telemetry.model.CDRSetAgentNameModel;
import com.coraltele.telemetry.model.UcUserDataModel;
import com.coraltele.telemetry.model.UserDetailsDataModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CallDataCollectionService {
    private static final Logger logger = LogManager.getLogger(CallDataCollectionService.class);
    @Autowired
    private CallDataRecordRepository cdrRepository;
    @Autowired
    private AgentCDRRepository agentCDRRepository;
    @Autowired
    private CustomerCDRRepository memberCDRRepository;
    @Autowired
    private LastNAgentCDRRepository lastNAgentCDRRepository;
    @Autowired
    private AgentPerformanceRepository agentPerformanceRepository;
    @Autowired
    private QueuePerformanceRepository queuePerformanceRepository;
    @Autowired
    private CampaignPerformanceRepository campaignPerformanceRepository;
    @Autowired
    private LeadPerformanceRepository leadPerformanceRepository;
    @Autowired
    private UploadLeadDataRepository uploadLeadDataRepository;
    @Autowired
    private QueueRepository queueRepository;
    @Autowired
    private AgentRepository agentRepository;
    @Autowired
    private OperatorMasterRepository callCenterOperatorMasterRepository;
    @Autowired
    private ACDSummaryRepository acdSummaryRepository;
    @Autowired
    private AgentRealTimeRepository agentRealTimeRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ExtensionRepository extensionsRepository;
    @Autowired
    private PACDRRepository pacdrRepository;
    @Autowired
    private VoiceLoggerRepository voiceLoggerRepository;
    @Autowired
    private ChannelRepository channelRepository;
    @Autowired
    private UserStatusRepository userStatusRepository;
    @Autowired
    private DateFormatUtility dateFormatUtility;
    @Autowired
    private WssUserRepository wssUsersRepository;
    @Autowired
    private SipRegistrationRepository sipRegistraionRepository;
    @Autowired
    private DynamicPopUpDataRepository dynamicPopUpDataRepository;
    @Autowired
    private BillingCDRRepository billingCDRRepository;
    @Autowired
    private BillingCDRSummaryRepository billingCDRSummaryRepository;
    @Autowired
    private GetAgentFullName getAgentFullName;
    @Autowired
    private UcUserDetailsRepository ucUserDetailsRepository;
    @Autowired
    private LastAbandonedCdrRepository lastAbandonedCdrRepository;
    @Autowired
    private UcNotificationRepository ucNotificationRepository;
    @Autowired
    private TiersRepository tiersRepository;
    @Autowired
    private OperatorDailyBreakTimeRepository operatorDailyBreakTimeRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;
    @Autowired
    private UserStatusDetailsRepository userStatusDetailsRepository;
    @Autowired
    private ChannelForBillingCdrRepository channelForBillingCdrRepository;
    @Autowired
    private DialCodeListRepository dialCodeListRepository;
    @Autowired
    private DepartmentRepository departmentRepository;
    @Autowired
    private GatewayMasterRepository gatewayMasterRepository;
    @Autowired
    private InboundGatewayRepository inboundGatewayRepository;
    @Autowired
    private ActiveMQProducer activeMQProducer;
    private Integer lastNRecords = 10;
    private static final String MEMBER = "member";
    private static final String AGENT = "agent";
    private static final String DIAL_OUT = "dial-out";
    private static final String ANNOUNCER = "announcer";
    private static final String CALLCENTERVERSION = Constants.CALLCENTER_VERSION_CONTROL;
    private static final ZoneId zoneId = ZoneId.of(Constants.TIME_ZONE_FOR_SUMMARY);
    private static final String CONFERENCE_NO = Constants.CONFERENCE_NUMBER;
    private static final Boolean sendCdrDataIntoVoiceLogger = Constants.SEND_CDR_DATA_IN_VOICE_LOGGER;

    public void processWssUsersMapping() {
        List sipRegistrationsList = this.sipRegistraionRepository.findAll();
        if (!sipRegistrationsList.isEmpty()) {
            for (SipRegistrations sipRegistrations : sipRegistrationsList) {
                String userValue = sipRegistrations.getContact().split("sip:")[1].split("@")[0].trim();
                Optional wssUserData = this.wssUsersRepository.findByUserValue(userValue);
                if (wssUserData.isPresent()) {
                    WssUsers existingWssUser = (WssUsers)wssUserData.get();
                    existingWssUser.setUserCreateTimeEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                    this.wssUsersRepository.save((Object)existingWssUser);
                    continue;
                }
                WssUsers newWssUser = new WssUsers();
                newWssUser.setUserValue(userValue);
                newWssUser.setUserId(sipRegistrations.getSipUser());
                newWssUser.setUserCreateTimeEpoch(Long.valueOf(Instant.now().getEpochSecond()));
                this.wssUsersRepository.save((Object)newWssUser);
            }
        } else {
            logger.info("Wss user List is Empty");
        }
    }

    public List<CallDataRecord> processCoralAppCdrData() {
        List cdrDataList = null;
        cdrDataList = this.cdrRepository.getDataToSync(Long.valueOf(Instant.now().getEpochSecond() - 60L));
        ArrayList<CallDataRecord> agentAndBridgeUuidEmptyData = new ArrayList<CallDataRecord>();
        if (!cdrDataList.isEmpty()) {
            for (CallDataRecord toProcess : cdrDataList) {
                try {
                    List agentRealTimeData;
                    CallDataRecord callDataRecord;
                    List callDataRecords;
                    String[] cdrCoralAppDataSplitList;
                    Iterator extensionsDetails;
                    String[] cdrLastArgDataSplitList;
                    Optional wssUserData;
                    String destinationValue;
                    int index;
                    ObjectMapper cdr = new ObjectMapper();
                    String cdrCache = cdr.writeValueAsString((Object)toProcess);
                    CallDataRecord cdrData = (CallDataRecord)cdr.readValue(cdrCache, CallDataRecord.class);
                    long recordEpoch = cdrData.getStartTime();
                    boolean isAcd = false;
                    logger.info("Processing CDR Data for UUID: {} ", (Object)cdrData.getUuid());
                    boolean readData = false;
                    boolean operatorCaseCDRData = false;
                    boolean isAgent = false;
                    String paNumber = "";
                    String queue = "";
                    String queueName = "";
                    long midnightEpoch = this.dateFormatUtility.getMidnightEpochFromEpoch(recordEpoch);
                    logger.info("Cdr Data Process for {} {}", (Object)cdrData.getUuid().toString(), (Object)cdrData.getStartTime());
                    if (!StringUtils.hasText((String)cdrData.getContext())) {
                        cdrData.setContext("default");
                    }
                    if (StringUtils.hasText((String)cdrData.getBridgeUUID()) && StringUtils.hasText((String)cdrData.getUuid().toString()) && cdrData.getBridgeUUID().equalsIgnoreCase(cdrData.getUuid().toString())) {
                        cdrData.setBridgeUUID("");
                    }
                    if ((index = (destinationValue = cdrData.getDestinationNumber()).indexOf("''")) != -1) {
                        cdrData.setDestinationNumber(destinationValue.substring(0, index));
                    }
                    if (StringUtils.hasText((String)destinationValue) && destinationValue.matches("^[A-Za-z].*") && (wssUserData = this.wssUsersRepository.findByUserValue(destinationValue)).isPresent()) {
                        cdrData.setDestinationNumber(((WssUsers)wssUserData.get()).getUserId());
                    }
                    if (StringUtils.hasText((String)cdrData.getDestinationNumber())) {
                        cdrData.setDestinationNumber(cdrData.getDestinationNumber().split("@", 2)[0].trim());
                    }
                    if (!StringUtils.hasText((String)cdrData.getCallerIDNumber())) {
                        if (StringUtils.hasText((String)cdrData.getContext()) && cdrData.getContext().equalsIgnoreCase("public")) {
                            List cdrListValueForBridgeUuid = this.cdrRepository.findByBridgeUUID(cdrData.getUuid().toString());
                            if (!cdrListValueForBridgeUuid.isEmpty()) {
                                for (CallDataRecord cdrDataWithCaller : cdrListValueForBridgeUuid) {
                                    if (!StringUtils.hasText((String)cdrDataWithCaller.getCallerIDNumber())) continue;
                                    cdrData.setCallerIDNumber(cdrDataWithCaller.getCallerIDNumber());
                                    break;
                                }
                            }
                        } else {
                            List cdrListValueForBridgeUuid;
                            UcUserDataModel destIsUcData = this.checkUcUser(cdrData.getDestinationNumber());
                            if (Boolean.FALSE.equals(destIsUcData.getIsUcUser()) && !(cdrListValueForBridgeUuid = this.cdrRepository.findByBridgeUUID(cdrData.getUuid().toString())).isEmpty()) {
                                CallDataRecord cdrDataWithCaller;
                                cdrDataWithCaller = cdrListValueForBridgeUuid.iterator();
                                while (cdrDataWithCaller.hasNext()) {
                                    CallDataRecord cdrDataWithCaller2 = (CallDataRecord)cdrDataWithCaller.next();
                                    if (!StringUtils.hasText((String)cdrDataWithCaller2.getCallerIDNumber())) continue;
                                    cdrData.setCallerIDNumber(cdrDataWithCaller2.getCallerIDNumber());
                                    break;
                                }
                            }
                        }
                    }
                    if (StringUtils.hasText((String)cdrData.getRecordType()) && cdrData.getRecordType().equalsIgnoreCase(AGENT) && StringUtils.hasText((String)cdrData.getHangupCause()) && (cdrData.getAnswerTime() == null || cdrData.getAnswerTime() == 0L) && cdrData.getEndTime() - cdrData.getStartTime() < Constants.TIME_DIFFERENCE_FOR_NOT_PROCESSING_CDR) {
                        toProcess.setIsDataSynced(Integer.valueOf(-4));
                        this.cdrRepository.save((Object)toProcess);
                        continue;
                    }
                    if (StringUtils.hasText((String)cdrData.getAgentName()) && cdrData.getAgentName().equalsIgnoreCase(AGENT) && cdrData.getDirection().equalsIgnoreCase("outbound") && !StringUtils.hasText((String)cdrData.getBridgeUUID()) && cdrData.getBillsec() != null && cdrData.getBillsec() == 0L) {
                        operatorCaseCDRData = true;
                        toProcess.setIsDataSynced(Integer.valueOf(-2));
                    }
                    if (StringUtils.hasText((String)cdrData.getCoralApp())) {
                        if (cdrData.getCoralApp().startsWith("ec")) {
                            cdrData.setCoralApp("ec");
                        } else if (cdrData.getCoralApp().startsWith("pa")) {
                            cdrData.setCoralApp("pa");
                        } else {
                            cdrData.setCoralApp(cdrData.getCoralApp());
                        }
                    } else {
                        cdrData.setCoralApp("");
                    }
                    if (!StringUtils.hasText((String)cdrData.getRecordType()) && StringUtils.hasText((String)cdrData.getLastArg()) && cdrData.getLastApp().equalsIgnoreCase("conference") && (cdrLastArgDataSplitList = cdrData.getLastArg().split("@")).length > 1 && ((Optional)((Object)(extensionsDetails = this.extensionsRepository.findByExtension(paNumber = cdrLastArgDataSplitList[0])))).isPresent() && ((Extension)((Optional)((Object)extensionsDetails)).get()).getExtensionType().equalsIgnoreCase("pa")) {
                        cdrData.setRecordType("pa");
                    }
                    if (!StringUtils.hasText((String)cdrData.getRecordType()) && StringUtils.hasText((String)cdrData.getCoralApp()) && (cdrCoralAppDataSplitList = cdrData.getCoralApp().split("@")).length > 1 && cdrCoralAppDataSplitList[0].equalsIgnoreCase("pa")) {
                        paNumber = cdrCoralAppDataSplitList[1];
                        cdrData.setRecordType("pa");
                    }
                    if (!StringUtils.hasText((String)cdrData.getRecordingFile())) {
                        cdrData.setRecordingFile("");
                    }
                    if (StringUtils.hasText((String)cdrData.getRecordType()) && cdrData.getRecordType().equalsIgnoreCase(AGENT) && !StringUtils.hasText((String)cdrData.getRecordingFile()) && !(callDataRecords = this.cdrRepository.findByBridgeUUID(cdrData.getUuid().toString())).isEmpty()) {
                        extensionsDetails = callDataRecords.iterator();
                        while (extensionsDetails.hasNext()) {
                            callDataRecord = (CallDataRecord)extensionsDetails.next();
                            if (!StringUtils.hasText((String)callDataRecord.getRecordType()) || !callDataRecord.getRecordType().equals(MEMBER) || !StringUtils.hasText((String)callDataRecord.getRecordingFile())) continue;
                            cdrData.setRecordingFile(callDataRecord.getRecordingFile());
                            break;
                        }
                    }
                    if (!StringUtils.hasText((String)cdrData.getAgentType())) {
                        cdrData.setAgentType("");
                    }
                    if (cdrData.getAnswerTime() == 0L) {
                        cdrData.setBridgeUUID(null);
                    }
                    if (!StringUtils.hasText((String)cdrData.getCallerIDName())) {
                        cdrData.setCallerIDName(cdrData.getCallerIDNumber());
                    }
                    if (!(operatorCaseCDRData || StringUtils.hasText((String)cdrData.getRecordType()) || StringUtils.hasText((String)cdrData.getQueue()) || StringUtils.hasText((String)cdrData.getAgentName()) || !StringUtils.hasText((String)cdrData.getCallerIDNumber()) || (agentRealTimeData = this.agentRealTimeRepository.findByContactNumber(cdrData.getCallerIDNumber())).isEmpty())) {
                        isAgent = true;
                        cdrData.setAgentName(((AgentRealTime)agentRealTimeData.get(0)).getAgentRealTimeKey().getAgent());
                        cdrData.setQueue(((AgentRealTime)agentRealTimeData.get(0)).getDefaultQueue());
                        if (cdrData.getDirection().equalsIgnoreCase("inbound") && StringUtils.hasText((String)toProcess.getContext()) && toProcess.getContext().equalsIgnoreCase("default")) {
                            cdrData.setRecordType(AGENT);
                            readData = true;
                        }
                        if (cdrData.getDirection().equalsIgnoreCase("outbound")) {
                            cdrData.setRecordType(MEMBER);
                            readData = true;
                        }
                        cdrData.setAgentType("manual");
                    }
                    if (!operatorCaseCDRData && !StringUtils.hasText((String)cdrData.getRecordType()) || StringUtils.hasText((String)cdrData.getAgentName()) && !StringUtils.hasText((String)cdrData.getQueue()) || StringUtils.hasText((String)cdrData.getQueue()) && cdrData.getQueue().equals(DIAL_OUT)) {
                        Optional operatorMasterData;
                        if (StringUtils.hasText((String)cdrData.getAgentName())) {
                            operatorMasterData = this.callCenterOperatorMasterRepository.findByExtension(cdrData.getAgentName());
                            if (operatorMasterData.isPresent()) {
                                cdrData.setQueue("ACD_" + ((OperatorMaster)operatorMasterData.get()).getLandingExtension() + "_OUT");
                            }
                        } else if (StringUtils.hasText((String)cdrData.getInitialCallerIdNumber())) {
                            operatorMasterData = this.callCenterOperatorMasterRepository.findByExtension(cdrData.getInitialCallerIdNumber());
                            if (operatorMasterData.isPresent()) {
                                cdrData.setQueue("ACD_" + ((OperatorMaster)operatorMasterData.get()).getLandingExtension() + "_OUT");
                            }
                        } else {
                            operatorMasterData = this.callCenterOperatorMasterRepository.findByExtension(cdrData.getCallerIDNumber());
                            if (operatorMasterData.isPresent()) {
                                cdrData.setQueue("ACD_" + ((OperatorMaster)operatorMasterData.get()).getLandingExtension() + "_OUT");
                            }
                        }
                    }
                    if (!operatorCaseCDRData && StringUtils.hasText((String)cdrData.getRecordType()) && cdrData.getRecordType().equalsIgnoreCase(AGENT) && !StringUtils.hasText((String)cdrData.getBridgeUUID()) && cdrData.getMemberSessionUUID() == null && !readData && StringUtils.hasText((String)toProcess.getQueue()) && !toProcess.getQueue().equalsIgnoreCase(DIAL_OUT) && StringUtils.hasText((String)cdrData.getCoralGateway())) {
                        agentAndBridgeUuidEmptyData.add(cdrData);
                    }
                    if (!operatorCaseCDRData && isAgent && !StringUtils.hasText((String)cdrData.getRecordType()) && !(callDataRecords = this.cdrRepository.findByBridgeUUID(cdrData.getUuid().toString())).isEmpty()) {
                        extensionsDetails = callDataRecords.iterator();
                        while (extensionsDetails.hasNext()) {
                            callDataRecord = (CallDataRecord)extensionsDetails.next();
                            if (!StringUtils.hasText((String)callDataRecord.getRecordType()) || !callDataRecord.getRecordType().equals(MEMBER) || !StringUtils.hasText((String)callDataRecord.getQueue())) continue;
                            cdrData.setQueue(callDataRecord.getQueue());
                            cdrData.setRecordType(AGENT);
                            cdrData.setAgentName(callDataRecord.getAgentName());
                            cdrData.setRecordingFile(callDataRecord.getRecordingFile());
                        }
                    }
                    String recordingTypeValue = this.typeOfRecording(cdrData.getRecordingFile());
                    if (!operatorCaseCDRData && cdrData.getRecordType() == null) {
                        this.updateDialer(Long.valueOf(midnightEpoch), cdrData);
                        toProcess.setIsDataSynced(Integer.valueOf(-1));
                    } else if (!StringUtils.hasText((String)cdrData.getCallerIDNumber()) || Boolean.TRUE.equals(Constants.SIP_TRUNK_CDR) && StringUtils.hasText((String)cdrData.getContext()) && cdrData.getContext().equalsIgnoreCase("resourcecall")) {
                        this.updateDialer(Long.valueOf(midnightEpoch), cdrData);
                        toProcess.setIsDataSynced(Integer.valueOf(-5));
                    } else if (!operatorCaseCDRData && cdrData.getRecordType().equalsIgnoreCase("pa")) {
                        logger.info("Updating information for PACDR {} {}", (Object)cdrData.getUuid().toString(), (Object)midnightEpoch);
                        PACDR pacdr = new PACDR();
                        pacdr.setUuid(cdrData.getUuid().toString());
                        pacdr.setStartTime(cdrData.getStartTime());
                        pacdr.setAnswerTime(cdrData.getAnswerTime());
                        pacdr.setEndTime(cdrData.getEndTime());
                        pacdr.setTalkTime(cdrData.getBillsec());
                        pacdr.setCallStatus(cdrData.getBillsec() > 0L);
                        if (cdrData.getDestinationNumber().equalsIgnoreCase(paNumber)) {
                            pacdr.setParticipantType(ANNOUNCER);
                            pacdr.setParticipantNumber(cdrData.getCallerIDNumber());
                        } else {
                            pacdr.setParticipantType(MEMBER);
                            pacdr.setParticipantNumber(cdrData.getDestinationNumber());
                        }
                        pacdr.setPaNumber(paNumber);
                        pacdr.setRecordingFile(cdrData.getRecordingFile());
                        pacdr.setRecordingFileType(recordingTypeValue);
                        this.pacdrRepository.save((Object)pacdr);
                        toProcess.setIsDataSynced(Integer.valueOf(1));
                    } else if (!operatorCaseCDRData && cdrData.getRecordType().equals(MEMBER)) {
                        List listCdr;
                        CDRSetAgentNameModel getAgentDetails;
                        logger.info("Updating information for Member.");
                        String agentId = "";
                        String agentName = "";
                        String agentFullName = "";
                        CustomerCDR memberCdr = new CustomerCDR();
                        memberCdr.setUuid(cdrData.getUuid().toString());
                        memberCdr.setBridgeUUID(cdrData.getBridgeUUID());
                        memberCdr.setStartTime(cdrData.getStartTime());
                        memberCdr.setAnswerTime(cdrData.getAnswerTime());
                        memberCdr.setEndTime(cdrData.getEndTime());
                        memberCdr.setDuration(cdrData.getDuration());
                        memberCdr.setCampaign(cdrData.getCampaign());
                        memberCdr.setMos(cdrData.getRtpAudioInMos());
                        memberCdr.setPulse(Long.valueOf(cdrData.getPulse() != null && cdrData.getPulse() > 0L ? cdrData.getPulse() : 0L));
                        memberCdr.setPulseRate(Long.valueOf(cdrData.getPulseRate() != null && cdrData.getPulseRate() > 0L ? cdrData.getPulseRate() : 0L));
                        boolean isStrategyIsRingAll = false;
                        Optional queueData = this.queueRepository.findBySystemName(cdrData.getQueue());
                        if (queueData.isPresent()) {
                            String[] queueDataSplitList = ((Queue)queueData.get()).getSystemName().split("_");
                            if (StringUtils.hasText((String)((Queue)queueData.get()).getSystemName())) {
                                memberCdr.setQueue(((Queue)queueData.get()).getSystemName());
                                memberCdr.setQueueName(((Queue)queueData.get()).getDescription());
                            } else {
                                memberCdr.setQueue(cdrData.getQueue());
                                if (StringUtils.hasText((String)((Queue)queueData.get()).getDescription())) {
                                    memberCdr.setQueueName(((Queue)queueData.get()).getDescription());
                                } else {
                                    memberCdr.setQueueName(cdrData.getQueue());
                                }
                            }
                            if (queueDataSplitList[0].equalsIgnoreCase("acd") && queueDataSplitList.length >= 3) {
                                memberCdr.setQueue(queueDataSplitList[1]);
                                memberCdr.setQueueName("operator " + queueDataSplitList[1]);
                                memberCdr.setQueueType(queueDataSplitList[2]);
                                isAcd = true;
                            }
                            if (StringUtils.hasText((String)((Queue)queueData.get()).getStrategy())) {
                                memberCdr.setQueueStrategy(((Queue)queueData.get()).getStrategy());
                                isStrategyIsRingAll = "ring-all".equalsIgnoreCase(memberCdr.getQueueStrategy());
                            }
                        } else {
                            String[] cdrQueueDataSplitList;
                            if (!StringUtils.hasText((String)cdrData.getQueue()) || StringUtils.hasText((String)cdrData.getCoralCallDirection()) && cdrData.getCoralCallDirection().equalsIgnoreCase("dialout")) {
                                cdrData.setQueue(DIAL_OUT);
                            }
                            if ((cdrQueueDataSplitList = cdrData.getQueue().split("_"))[0].equalsIgnoreCase("acd") && cdrQueueDataSplitList.length >= 3) {
                                memberCdr.setQueue(cdrQueueDataSplitList[1]);
                                memberCdr.setQueueName("operator " + cdrQueueDataSplitList[1]);
                                memberCdr.setQueueType(cdrQueueDataSplitList[2]);
                                if (cdrQueueDataSplitList[2].equals("OUT")) {
                                    memberCdr.setQueueStrategy("Dial");
                                    memberCdr.setCallDirection("OUT");
                                } else {
                                    memberCdr.setQueueStrategy("Pickup");
                                }
                                isAcd = true;
                            } else {
                                memberCdr.setQueue(cdrData.getQueue());
                                memberCdr.setQueueName(cdrData.getQueue());
                                memberCdr.setQueueStrategy("");
                            }
                        }
                        queue = memberCdr.getQueue();
                        queueName = memberCdr.getQueueName();
                        if (StringUtils.hasText((String)cdrData.getAgentName())) {
                            getAgentDetails = this.getAgentFullName.getAgentName(cdrData.getAgentName());
                        } else {
                            cdrData.setAgentName("");
                            getAgentDetails = new CDRSetAgentNameModel("", "");
                        }
                        agentName = StringUtils.hasText((String)getAgentDetails.getAgent()) ? getAgentDetails.getAgent() : cdrData.getAgentName();
                        agentFullName = getAgentDetails.getAgentName();
                        agentId = cdrData.getAgentName();
                        memberCdr.setHangupCause(cdrData.getHangupCause());
                        memberCdr.setCoralApp(cdrData.getCoralApp());
                        memberCdr.setCallType(null);
                        memberCdr.setCallback(null);
                        memberCdr.setCustomerFeedback(null);
                        memberCdr.setDtmf(null);
                        memberCdr.setLead(null);
                        memberCdr.setRetry(null);
                        memberCdr.setAgentRemark(null);
                        memberCdr.setRingDuration(Integer.valueOf(0));
                        memberCdr.setWaitTime(Long.valueOf(0L));
                        if (StringUtils.hasText((String)cdrData.getQueueJoinedEpoch())) {
                            memberCdr.setQueueJoinedEpoch(Long.valueOf(Long.parseLong(cdrData.getQueueJoinedEpoch())));
                        } else {
                            memberCdr.setQueueJoinedEpoch(Long.valueOf(0L));
                        }
                        memberCdr.setTransferTo(cdrData.getTransferTo());
                        memberCdr.setTransferBy(cdrData.getTransferBy());
                        memberCdr.setTransferStatus(StringUtils.hasText((String)cdrData.getTransferType()) ? "success" : "");
                        memberCdr.setTransferType(cdrData.getTransferType());
                        if (!StringUtils.hasText((String)memberCdr.getCallDirection())) {
                            memberCdr.setCallDirection(this.getDirection(cdrData));
                        }
                        if (StringUtils.hasText((String)memberCdr.getBridgeUUID())) {
                            memberCdr.setFinalStatus(Integer.valueOf(1));
                            memberCdr.setFinalStatusName("Contacted");
                            memberCdr.setStatus("answered");
                            memberCdr.setCcAgent(agentId);
                            memberCdr.setAnsweredBy(agentId);
                            memberCdr.setAnsweredByName(agentName);
                            memberCdr.setAgentFullName(agentFullName);
                        } else if (memberCdr.getAnswerTime() > 0L) {
                            List cdrDataForAbandonedList = this.cdrRepository.findByMemberSessionUUIDOrderById(UUID.fromString(memberCdr.getUuid()));
                            if (!cdrDataForAbandonedList.isEmpty() && Boolean.FALSE.equals(isStrategyIsRingAll)) {
                                memberCdr.setFinalStatus(Integer.valueOf(-1));
                                memberCdr.setFinalStatusName("ABD at Agent");
                                memberCdr.setStatus("ABD at Agent");
                                agentId = ((CallDataRecord)cdrDataForAbandonedList.get(0)).getAgentName();
                                CDRSetAgentNameModel agentDetails = this.getAgentFullName.getAgentName(agentId);
                                memberCdr.setCcAgent(agentId);
                                memberCdr.setAnsweredBy(agentId);
                                memberCdr.setAnsweredByName(agentDetails.getAgent());
                                memberCdr.setAgentFullName(agentDetails.getAgentName());
                            } else {
                                memberCdr.setFinalStatus(Integer.valueOf(-2));
                                memberCdr.setFinalStatusName("ABD at Queue");
                                memberCdr.setStatus("ABD at Queue");
                                memberCdr.setCcAgent("");
                                memberCdr.setAnsweredBy("");
                                memberCdr.setAnsweredByName("");
                                memberCdr.setAgentFullName("");
                            }
                        } else {
                            memberCdr.setFinalStatus(Integer.valueOf(-3));
                            memberCdr.setFinalStatusName("Not Contacted");
                            memberCdr.setStatus("Not Contacted");
                            memberCdr.setCcAgent(agentId);
                            memberCdr.setAnsweredBy(agentId);
                            memberCdr.setAnsweredByName(agentName);
                            memberCdr.setAgentFullName(agentFullName);
                        }
                        memberCdr.setRecordingFile(cdrData.getRecordingFile());
                        memberCdr.setRecordingFileType(recordingTypeValue);
                        if (!StringUtils.hasText((String)memberCdr.getRecordingFile()) && !(listCdr = this.cdrRepository.findByBridgeUUID(cdrData.getUuid().toString())).isEmpty()) {
                            for (CallDataRecord dataToSetFile : listCdr) {
                                if (!StringUtils.hasText((String)dataToSetFile.getRecordingFile())) continue;
                                memberCdr.setRecordingFile(dataToSetFile.getRecordingFile());
                                break;
                            }
                        }
                        memberCdr.setCustomerNumber(cdrData.getDestinationNumber());
                        memberCdr.setCallId(cdrData.getCallerIDNumber());
                        if (memberCdr.getStatus().equalsIgnoreCase("ABD at Agent") && !StringUtils.hasText((String)memberCdr.getCcAgent())) {
                            if (memberCdr.getCallDirection().equals("OUT")) {
                                memberCdr.setCcAgent(cdrData.getCallerIDNumber());
                            } else {
                                memberCdr.setCcAgent(cdrData.getDestinationNumber());
                            }
                        }
                        if (StringUtils.hasText((String)cdrData.getAgentName()) && StringUtils.hasText((String)cdrData.getTransferType()) && cdrData.getTransferType().equals("BLIND_TRANSFER")) {
                            memberCdr.setCustomerName(cdrData.getCallerIDName());
                            memberCdr.setCustomerNumber(cdrData.getCallerIDNumber());
                        }
                        if (StringUtils.hasText((String)memberCdr.getCustomerNumber()) && StringUtils.hasText((String)memberCdr.getCallDirection()) && memberCdr.getCallDirection().equalsIgnoreCase("IN")) {
                            memberCdr.setAgentTalkedTo(memberCdr.getCallId());
                        } else {
                            memberCdr.setAgentTalkedTo(memberCdr.getCustomerNumber());
                        }
                        this.updateQueuePerformanceData(Long.valueOf(midnightEpoch), memberCdr);
                        memberCdr.setRecordType(Integer.valueOf(1));
                        this.memberCDRRepository.save((Object)memberCdr);
                        this.updateDialer(Long.valueOf(midnightEpoch), cdrData);
                        toProcess.setIsDataSynced(Integer.valueOf(1));
                    } else if (!operatorCaseCDRData && cdrData.getRecordType().equals(AGENT)) {
                        List listOfHoldingCalls;
                        Optional queueData;
                        Optional agentData;
                        logger.info("Updating information for Agent.");
                        if (!StringUtils.hasText((String)cdrData.getAgentName()) && StringUtils.hasText((String)cdrData.getDirection())) {
                            if (cdrData.getDirection().equalsIgnoreCase("inbound")) {
                                cdrData.setAgentName(cdrData.getDestinationNumber());
                            } else {
                                cdrData.setAgentName(cdrData.getCallerIDNumber());
                            }
                        }
                        AgentCDR agentCdr = new AgentCDR();
                        if (cdrData.getUuid() != null) {
                            agentCdr.setUuid(cdrData.getUuid().toString());
                        }
                        if (cdrData.getMemberUUID() != null) {
                            agentCdr.setMemberUUID(cdrData.getMemberUUID().toString());
                        }
                        if (!StringUtils.hasText((String)cdrData.getAgentName()) && cdrData.getDirection().equalsIgnoreCase("inbound")) {
                            List agentRealTimeData2 = this.agentRealTimeRepository.findByContactNumber(cdrData.getCallerIDNumber());
                            if (!agentRealTimeData2.isEmpty()) {
                                cdrData.setAgentName(((AgentRealTime)agentRealTimeData2.get(0)).getAgentRealTimeKey().getAgent());
                            } else {
                                cdrData.setAgentName(cdrData.getCallerIDNumber());
                            }
                        }
                        if ((agentData = this.agentRepository.findByName(cdrData.getAgentName())).isPresent() && !StringUtils.hasText((String)cdrData.getQueue()) && StringUtils.hasText((String)((Agent)agentData.get()).getDefaultQueue())) {
                            cdrData.setQueue(((Agent)agentData.get()).getDefaultQueue());
                        }
                        if (!StringUtils.hasText((String)cdrData.getQueue()) && cdrData.getDirection().equalsIgnoreCase("inbound")) {
                            cdrData.setQueue(DIAL_OUT);
                        }
                        if ((queueData = this.queueRepository.findBySystemName(cdrData.getQueue())).isPresent()) {
                            if (StringUtils.hasText((String)((Queue)queueData.get()).getStrategy()) && "ring-all".equalsIgnoreCase(((Queue)queueData.get()).getStrategy()) && (toProcess.getAnswerTime() == null || toProcess.getAnswerTime() == 0L)) {
                                logger.info("ring all strategy ignored unanswered agent leg.");
                                toProcess.setIsDataSynced(Integer.valueOf(-6));
                                this.cdrRepository.save((Object)toProcess);
                                continue;
                            }
                            String[] queueDataSplitList = ((Queue)queueData.get()).getSystemName().split("_");
                            if (queueDataSplitList[0].equalsIgnoreCase("acd") && queueDataSplitList.length >= 3) {
                                isAcd = true;
                                agentCdr.setQueue(queueDataSplitList[1]);
                                agentCdr.setQueueName("operator " + queueDataSplitList[1]);
                                agentCdr.setQueueType(queueDataSplitList[2]);
                            } else {
                                agentCdr.setQueue(cdrData.getQueue());
                                if (StringUtils.hasText((String)((Queue)queueData.get()).getDescription())) {
                                    agentCdr.setQueueName(((Queue)queueData.get()).getDescription());
                                } else {
                                    agentCdr.setQueueName(cdrData.getQueue());
                                }
                            }
                        } else {
                            String[] cdrQueueDataSplitList;
                            if (!StringUtils.hasText((String)cdrData.getQueue()) || StringUtils.hasText((String)cdrData.getCoralCallDirection()) && cdrData.getCoralCallDirection().equalsIgnoreCase("dialout")) {
                                cdrData.setQueue(DIAL_OUT);
                            }
                            if ((cdrQueueDataSplitList = cdrData.getQueue().split("_"))[0].equalsIgnoreCase("acd") && cdrQueueDataSplitList.length >= 3) {
                                isAcd = true;
                                agentCdr.setQueue(cdrQueueDataSplitList[1]);
                                agentCdr.setQueueName("operator " + cdrQueueDataSplitList[1]);
                                agentCdr.setQueueType(cdrQueueDataSplitList[2]);
                            } else if (StringUtils.hasText((String)cdrData.getCoralCallDirection()) && cdrData.getCoralCallDirection().equalsIgnoreCase("dialout")) {
                                cdrData.setQueue(DIAL_OUT);
                                agentCdr.setQueue(DIAL_OUT);
                                agentCdr.setQueueName(cdrData.getQueue());
                            } else {
                                agentCdr.setQueue(cdrData.getQueue());
                                agentCdr.setQueueName(cdrData.getQueue());
                            }
                        }
                        queue = agentCdr.getQueue();
                        queueName = agentCdr.getQueueName();
                        CDRSetAgentNameModel getAgentDetails = this.getAgentFullName.getAgentName(cdrData.getAgentName());
                        if (StringUtils.hasText((String)getAgentDetails.getAgent())) {
                            agentCdr.setAgentName(getAgentDetails.getAgent());
                        } else {
                            agentCdr.setAgentName(cdrData.getAgentName());
                        }
                        agentCdr.setFullName(getAgentDetails.getAgentName());
                        agentCdr.setCallDirection(this.getDirection(cdrData));
                        agentCdr.setCallId(cdrData.getCallerIDNumber());
                        agentCdr.setCustomerNumber(cdrData.getDestinationNumber());
                        agentCdr.setCoralApp(cdrData.getCoralApp());
                        agentCdr.setAnswerTime(cdrData.getAnswerTime());
                        agentCdr.setBridgeUUID(cdrData.getBridgeUUID());
                        agentCdr.setCampaignName(cdrData.getCampaign());
                        agentCdr.setEndTime(cdrData.getEndTime());
                        agentCdr.setStartTime(cdrData.getStartTime());
                        agentCdr.setHangupCause(cdrData.getHangupCause());
                        agentCdr.setDuration(cdrData.getDuration());
                        agentCdr.setMos(cdrData.getRtpAudioInMos());
                        if (StringUtils.hasText((String)agentCdr.getCallDirection()) && agentCdr.getCallDirection().equalsIgnoreCase("IN")) {
                            agentCdr.setAgentTalkedTo(agentCdr.getCallId());
                        } else {
                            agentCdr.setAgentTalkedTo(agentCdr.getCustomerNumber());
                        }
                        Long ringDuration = 0L;
                        if (StringUtils.hasText((String)agentCdr.getBridgeUUID())) {
                            agentCdr.setIsMissed(Boolean.valueOf(false));
                        } else {
                            agentCdr.setIsMissed(Boolean.valueOf(true));
                        }
                        if (agentCdr.getAnswerTime() != null && agentCdr.getAnswerTime() > 0L) {
                            if (StringUtils.hasText((String)agentCdr.getBridgeUUID())) {
                                agentCdr.setTalkDuration(Long.valueOf(agentCdr.getEndTime() - agentCdr.getAnswerTime()));
                                if (agentCdr.getTalkDuration() == 0L) {
                                    agentCdr.setTalkDuration(Long.valueOf(1L));
                                }
                            } else {
                                agentCdr.setTalkDuration(Long.valueOf(0L));
                            }
                            ringDuration = agentCdr.getAnswerTime() - agentCdr.getStartTime();
                        } else {
                            agentCdr.setTalkDuration(Long.valueOf(0L));
                            ringDuration = agentCdr.getEndTime() - agentCdr.getStartTime();
                        }
                        Long talkTimeWithHoldCalls = 0L;
                        if (cdrData.getAnswerTime() != null && cdrData.getAnswerTime() > 0L && !(listOfHoldingCalls = this.agentCDRRepository.findAgentCDRs(cdrData.getAnswerTime(), cdrData.getEndTime(), agentCdr.getAgentName())).isEmpty()) {
                            Long overlapStartTime = cdrData.getAnswerTime();
                            if (overlapStartTime < ((AgentCDR)listOfHoldingCalls.get(0)).getAnswerTime()) {
                                overlapStartTime = ((AgentCDR)listOfHoldingCalls.get(0)).getAnswerTime();
                            }
                            Long onGoingEndTime = ((AgentCDR)listOfHoldingCalls.get(0)).getEndTime();
                            for (AgentCDR holdData : listOfHoldingCalls) {
                                if (overlapStartTime <= holdData.getAnswerTime() && onGoingEndTime >= holdData.getEndTime()) continue;
                                if (onGoingEndTime < holdData.getAnswerTime()) {
                                    talkTimeWithHoldCalls = talkTimeWithHoldCalls + (onGoingEndTime - overlapStartTime);
                                    overlapStartTime = holdData.getAnswerTime();
                                    onGoingEndTime = holdData.getEndTime();
                                }
                                if (onGoingEndTime >= holdData.getEndTime()) continue;
                                onGoingEndTime = holdData.getEndTime();
                            }
                            talkTimeWithHoldCalls = talkTimeWithHoldCalls + (onGoingEndTime - overlapStartTime);
                        }
                        agentCdr.setRealTalkDuration(Long.valueOf(agentCdr.getTalkDuration() - talkTimeWithHoldCalls));
                        agentCdr.setRealDialedRingDuration(Long.valueOf(0L));
                        agentCdr.setRecordingFile(cdrData.getRecordingFile());
                        agentCdr.setRecordingFileType(recordingTypeValue);
                        agentCdr.setPulse(Long.valueOf(cdrData.getPulse() != null && cdrData.getPulse() > 0L ? cdrData.getPulse() : 0L));
                        agentCdr.setPulseRate(Long.valueOf(cdrData.getPulseRate() != null && cdrData.getPulseRate() > 0L ? cdrData.getPulseRate() : 0L));
                        long totalCost = 0L;
                        if (agentCdr.getPulse() > 0L) {
                            totalCost = (long)Math.ceil((double)agentCdr.getRealTalkDuration().longValue() / (double)agentCdr.getPulse().longValue()) * agentCdr.getPulseRate();
                        }
                        agentCdr.setCost(Long.valueOf(totalCost));
                        agentCdr.setSecond10(Integer.valueOf(ringDuration <= 10L ? 1 : 0));
                        agentCdr.setSecond20(Integer.valueOf(ringDuration > 10L && ringDuration <= 20L ? 1 : 0));
                        agentCdr.setSecond30(Integer.valueOf(ringDuration > 20L && ringDuration <= 30L ? 1 : 0));
                        agentCdr.setSecond40(Integer.valueOf(ringDuration > 30L && ringDuration <= 40L ? 1 : 0));
                        agentCdr.setSecond50(Integer.valueOf(ringDuration > 40L && ringDuration <= 50L ? 1 : 0));
                        agentCdr.setSecond60(Integer.valueOf(ringDuration > 50L ? 1 : 0));
                        agentCdr.setRecordType(Integer.valueOf(2));
                        this.agentCDRRepository.save((Object)agentCdr);
                        this.updateLastNAgentRecord(agentCdr);
                        this.updateAgentPerformance(Long.valueOf(midnightEpoch), ringDuration, agentCdr);
                        this.updateLastAbandonedCdr(agentCdr, Long.valueOf(midnightEpoch));
                        toProcess.setIsDataSynced(Integer.valueOf(1));
                    }
                    Boolean ucIsCallerAndDirectionOut = false;
                    if (Boolean.TRUE.equals(Constants.SIP_TRUNK_CDR) && cdrData.getDirection().equalsIgnoreCase("outbound") && StringUtils.hasText((String)cdrData.getCoralCallDirection()) && (cdrData.getCoralCallDirection().equalsIgnoreCase("INT") || StringUtils.hasText((String)cdrData.getCoralApp()) && cdrData.getCoralApp().equalsIgnoreCase("uccall"))) {
                        UcUserDataModel isUc = this.checkUcUser(cdrData.getCallerIDNumber());
                        ucIsCallerAndDirectionOut = isUc.getIsUcUser();
                    }
                    if (StringUtils.hasText((String)cdrData.getCallerIDNumber()) && (toProcess.getDirection().equalsIgnoreCase("inbound") && StringUtils.hasText((String)cdrData.getContext()) && !cdrData.getContext().equalsIgnoreCase("rlu") && !cdrData.getContext().equalsIgnoreCase("resourcecall") && !cdrData.getDestinationNumber().startsWith("ResourceCall") || Boolean.TRUE.equals(Constants.SIP_TRUNK_CDR) && (StringUtils.hasText((String)cdrData.getContext()) && cdrData.getContext().equalsIgnoreCase("public") && !StringUtils.hasText((String)cdrData.getBridgeUUID()) && StringUtils.hasText((String)toProcess.getDirection()) && toProcess.getDirection().equalsIgnoreCase("outbound") || Boolean.TRUE.equals(ucIsCallerAndDirectionOut)))) {
                        UcUserDataModel destUcData;
                        UcUserDataModel callerUcData;
                        if (Boolean.TRUE.equals(Constants.SIP_TRUNK_CDR) && StringUtils.hasText((String)cdrData.getContext()) && cdrData.getContext().equalsIgnoreCase("voice_guidance")) {
                            cdrData.setBillsec(Long.valueOf(0L));
                        }
                        if (Boolean.FALSE.equals(Constants.SEND_CHANNELS_DATA_IN_BILLING_CDR)) {
                            this.setDataBillingCdrReport(Long.valueOf(midnightEpoch), cdrData);
                        }
                        Boolean isConferenceCdr = false;
                        if (CONFERENCE_NO.equalsIgnoreCase(cdrData.getCallerIDNumber()) || CONFERENCE_NO.equalsIgnoreCase(cdrData.getDestinationNumber())) {
                            isConferenceCdr = true;
                        }
                        if (Boolean.TRUE.equals((callerUcData = this.checkUcUser(cdrData.getCallerIDNumber())).getIsUcUser()) && !isConferenceCdr.booleanValue() && !this.isDestinationIsFaxUser(cdrData.getDestinationNumber())) {
                            this.updateUcUser(cdrData, cdrData.getCallerIDNumber(), "OUT", callerUcData);
                        }
                        if (Boolean.TRUE.equals((destUcData = this.checkUcUser(cdrData.getDestinationNumber())).getIsUcUser()) && !isConferenceCdr.booleanValue() && !this.isDestinationIsFaxUser(cdrData.getCallerIDNumber())) {
                            this.updateUcUser(cdrData, cdrData.getDestinationNumber(), "IN", destUcData);
                        }
                    }
                    if (cdrData.getBillsec() > Constants.TIME_DIFFERENCE_FOR_NOT_PROCESSING_CDR && Boolean.TRUE.equals(sendCdrDataIntoVoiceLogger != false && (StringUtils.hasText((String)toProcess.getBridgeUUID()) || StringUtils.hasText((String)toProcess.getCoralApp()) && toProcess.getCoralApp().equalsIgnoreCase("siprec")) && StringUtils.hasText((String)toProcess.getRecordingFile()) && StringUtils.hasText((String)toProcess.getDirection()) && toProcess.getDirection().equalsIgnoreCase("inbound") && StringUtils.hasText((String)cdrData.getCallerIDNumber()))) {
                        this.updateVoicePicker(cdrData, toProcess, queue, queueName);
                    }
                    this.cdrRepository.save((Object)toProcess);
                }
                catch (Exception ex) {
                    toProcess.setIsDataSynced(Integer.valueOf(-100));
                    this.cdrRepository.save((Object)toProcess);
                    logger.error("Error processing cdr data UUID : {} {} {}", (Object)toProcess.getUuid().toString(), (Object)ex.getMessage(), (Object)ex);
                }
            }
        } else {
            logger.info("cdrDataList is empty");
        }
        if (!agentAndBridgeUuidEmptyData.isEmpty()) {
            for (CallDataRecord missedData : agentAndBridgeUuidEmptyData) {
                try {
                    CDRSetAgentNameModel getAgentDetails;
                    logger.info("Updating information for Member Which is Missed {} ", (Object)missedData.getUuid().toString());
                    missedData.setRecordType(MEMBER);
                    long recordEpoch = missedData.getStartTime();
                    boolean isAcd = false;
                    logger.info("Processing CDR Data for UUID: {}", (Object)isAcd);
                    long midnightEpoch = this.dateFormatUtility.getMidnightEpochFromEpoch(recordEpoch);
                    CustomerCDR memberCdr = new CustomerCDR();
                    String agentId = "";
                    String agentName = "";
                    String agentFullName = "";
                    memberCdr.setUuid(missedData.getUuid().toString());
                    memberCdr.setBridgeUUID(missedData.getBridgeUUID());
                    memberCdr.setStartTime(missedData.getStartTime());
                    memberCdr.setAnswerTime(missedData.getAnswerTime());
                    memberCdr.setEndTime(missedData.getEndTime());
                    memberCdr.setDuration(missedData.getDuration());
                    memberCdr.setCampaign(missedData.getCampaign());
                    memberCdr.setAnsweredBy(missedData.getAgentName());
                    memberCdr.setMos(missedData.getRtpAudioInMos());
                    Optional queueData = this.queueRepository.findBySystemName(missedData.getQueue());
                    if (queueData.isPresent()) {
                        String[] queueDataSplitList = ((Queue)queueData.get()).getSystemName().split("_");
                        if (StringUtils.hasText((String)((Queue)queueData.get()).getSystemName())) {
                            memberCdr.setQueue(((Queue)queueData.get()).getSystemName());
                            memberCdr.setQueueName(((Queue)queueData.get()).getDescription());
                        } else {
                            memberCdr.setQueue(missedData.getQueue());
                            if (StringUtils.hasText((String)((Queue)queueData.get()).getDescription())) {
                                memberCdr.setQueueName(((Queue)queueData.get()).getDescription());
                            } else {
                                memberCdr.setQueueName(missedData.getQueue());
                            }
                        }
                        if (queueDataSplitList[0].equalsIgnoreCase("acd") && queueDataSplitList.length >= 3) {
                            memberCdr.setQueue(queueDataSplitList[1]);
                            memberCdr.setQueueName("operator " + queueDataSplitList[1]);
                            memberCdr.setQueueType(queueDataSplitList[2]);
                            isAcd = true;
                        }
                        if (StringUtils.hasText((String)((Queue)queueData.get()).getStrategy())) {
                            memberCdr.setQueueStrategy(((Queue)queueData.get()).getStrategy());
                        }
                    } else {
                        String[] cdrQueueDataSplitList;
                        if (!StringUtils.hasText((String)missedData.getQueue())) {
                            missedData.setQueue(DIAL_OUT);
                        }
                        if ((cdrQueueDataSplitList = missedData.getQueue().split("_"))[0].equalsIgnoreCase("acd") && cdrQueueDataSplitList.length >= 3) {
                            memberCdr.setQueue(cdrQueueDataSplitList[1]);
                            memberCdr.setQueueName("operator " + cdrQueueDataSplitList[1]);
                            memberCdr.setQueueType(cdrQueueDataSplitList[2]);
                            if (cdrQueueDataSplitList[2].equals("OUT")) {
                                memberCdr.setQueueStrategy("Dial");
                            } else {
                                memberCdr.setQueueStrategy("Pickup");
                            }
                            isAcd = true;
                        } else {
                            memberCdr.setQueue(missedData.getQueue());
                            memberCdr.setQueueName(missedData.getQueue());
                            memberCdr.setQueueStrategy("");
                        }
                    }
                    if (StringUtils.hasText((String)missedData.getAgentName())) {
                        getAgentDetails = this.getAgentFullName.getAgentName(missedData.getAgentName());
                    } else {
                        missedData.setAgentName("");
                        getAgentDetails = new CDRSetAgentNameModel("", "");
                    }
                    agentName = StringUtils.hasText((String)getAgentDetails.getAgent()) ? getAgentDetails.getAgent() : missedData.getAgentName();
                    agentFullName = getAgentDetails.getAgentName();
                    agentId = missedData.getAgentName();
                    memberCdr.setHangupCause(missedData.getHangupCause());
                    memberCdr.setCoralApp(missedData.getCoralApp());
                    memberCdr.setCallDisconnectionBy(null);
                    memberCdr.setCallType(null);
                    memberCdr.setCallback(null);
                    memberCdr.setCustomerFeedback(null);
                    memberCdr.setDtmf(null);
                    memberCdr.setLead(null);
                    memberCdr.setRetry(null);
                    memberCdr.setAgentRemark(null);
                    memberCdr.setRingDuration(Integer.valueOf(0));
                    memberCdr.setWaitTime(Long.valueOf(0L));
                    memberCdr.setPulse(Long.valueOf(missedData.getPulse() != null && missedData.getPulse() > 0L ? missedData.getPulse() : 0L));
                    memberCdr.setPulseRate(Long.valueOf(missedData.getPulseRate() != null && missedData.getPulseRate() > 0L ? missedData.getPulseRate() : 0L));
                    if (StringUtils.hasText((String)missedData.getQueueJoinedEpoch())) {
                        memberCdr.setQueueJoinedEpoch(Long.valueOf(Long.parseLong(missedData.getQueueJoinedEpoch())));
                    } else {
                        memberCdr.setQueueJoinedEpoch(Long.valueOf(0L));
                    }
                    memberCdr.setTransferTo(missedData.getTransferTo());
                    memberCdr.setTransferBy(missedData.getTransferBy());
                    memberCdr.setTransferStatus(StringUtils.hasText((String)missedData.getTransferType()) ? "success" : "");
                    memberCdr.setTransferType(missedData.getTransferType());
                    if (StringUtils.hasText((String)memberCdr.getBridgeUUID())) {
                        memberCdr.setFinalStatus(Integer.valueOf(1));
                        memberCdr.setFinalStatusName("Contacted");
                        memberCdr.setStatus("answered");
                        memberCdr.setCcAgent(agentId);
                        memberCdr.setAnsweredBy(agentId);
                        memberCdr.setAnsweredByName(agentName);
                        memberCdr.setAgentFullName(agentFullName);
                    } else if (memberCdr.getAnswerTime() > 0L) {
                        List cdrDataForAbandonedList = this.cdrRepository.findByMemberSessionUUIDOrderById(UUID.fromString(memberCdr.getUuid()));
                        if (!cdrDataForAbandonedList.isEmpty()) {
                            memberCdr.setFinalStatus(Integer.valueOf(-1));
                            memberCdr.setFinalStatusName("ABD at Agent");
                            memberCdr.setStatus("ABD at Agent");
                            agentId = ((CallDataRecord)cdrDataForAbandonedList.get(0)).getAgentName();
                            CDRSetAgentNameModel agentDetails = this.getAgentFullName.getAgentName(agentId);
                            memberCdr.setCcAgent(agentId);
                            memberCdr.setAnsweredBy(agentId);
                            memberCdr.setAnsweredByName(agentDetails.getAgent());
                            memberCdr.setAgentFullName(agentDetails.getAgentName());
                        } else {
                            memberCdr.setFinalStatus(Integer.valueOf(-2));
                            memberCdr.setFinalStatusName("ABD at Queue");
                            memberCdr.setStatus("ABD at Queue");
                            memberCdr.setCcAgent("");
                            memberCdr.setAnsweredBy("");
                            memberCdr.setAnsweredByName("");
                            memberCdr.setAgentFullName("");
                        }
                    } else {
                        memberCdr.setFinalStatus(Integer.valueOf(-3));
                        memberCdr.setFinalStatusName("Not Contacted");
                        memberCdr.setStatus("Not Contacted");
                        memberCdr.setCcAgent(agentId);
                        memberCdr.setAnsweredBy(agentId);
                        memberCdr.setAnsweredByName(agentName);
                        memberCdr.setAgentFullName(agentFullName);
                    }
                    memberCdr.setRecordingFile(missedData.getRecordingFile());
                    memberCdr.setRecordingFileType(this.typeOfRecording(missedData.getRecordingFile()));
                    memberCdr.setCallId(missedData.getCallerIDNumber());
                    memberCdr.setCallDirection("OUT");
                    memberCdr.setCustomerNumber(missedData.getDestinationNumber());
                    if (StringUtils.hasText((String)memberCdr.getCustomerNumber())) {
                        memberCdr.setAgentTalkedTo(memberCdr.getCustomerNumber());
                    }
                    if (memberCdr.getStatus().equalsIgnoreCase("ABD at Agent") && !StringUtils.hasText((String)memberCdr.getCcAgent())) {
                        memberCdr.setCcAgent(missedData.getCallerIDNumber());
                    }
                    if (memberCdr.getStatus().equalsIgnoreCase("ABD at Queue")) {
                        memberCdr.setCustomerName("");
                        memberCdr.setCustomerNumber("");
                    }
                    this.updateQueuePerformanceData(Long.valueOf(midnightEpoch), memberCdr);
                    memberCdr.setRecordType(Integer.valueOf(3));
                    this.memberCDRRepository.save((Object)memberCdr);
                    this.updateDialer(Long.valueOf(midnightEpoch), missedData);
                }
                catch (Exception ex) {
                    logger.error("Error while processing for Member Which is Missed UUID : {} {} {}", (Object)missedData.getUuid().toString(), (Object)ex.getMessage(), (Object)ex);
                }
            }
        }
        return cdrDataList;
    }

    private String typeOfRecording(String recordingFile) {
        String returnValue = "";
        if (StringUtils.hasText((String)recordingFile)) {
            String[] recordingData = recordingFile.split("\\.", -1);
            returnValue = recordingData.length > 1 && recordingData[recordingData.length - 1].equalsIgnoreCase("mp4") ? "VIDEO" : "AUDIO";
        }
        return returnValue;
    }

    private void updateAgentPerformance(Long midnightEpoch, Long ringDuration, AgentCDR agentCdr) {
        List dispositionData;
        AgentPerformanceCompositeKey agentKey = new AgentPerformanceCompositeKey();
        agentKey.setRecordEpoch(midnightEpoch);
        agentKey.setAgentName(agentCdr.getAgentName());
        Optional agentPerformance = this.agentPerformanceRepository.findById((Object)agentKey);
        AgentPerformance dataToSave = null;
        if (Boolean.TRUE.equals(agentCdr.getIsMissed())) {
            ringDuration = 0L;
        }
        if (agentPerformance.isPresent()) {
            dataToSave = (AgentPerformance)agentPerformance.get();
        } else {
            dataToSave = new AgentPerformance();
            dataToSave.setAgentPerformanceCompositeKey(agentKey);
            this.initializeAgentData(dataToSave);
        }
        Integer totalAcwDuration = dataToSave.getTotalAcwDuration();
        dataToSave.setFullName(agentCdr.getFullName());
        if (dataToSave.getTotalOfferedTalkDuration() == null) {
            dataToSave.setTotalOfferedTalkDuration(Long.valueOf(0L));
        }
        if (dataToSave.getTotalDialedTalkDuration() == null) {
            dataToSave.setTotalDialedTalkDuration(Long.valueOf(0L));
        }
        if (dataToSave.getAverageOfferedTalkDuration() == null) {
            dataToSave.setAverageOfferedTalkDuration(Long.valueOf(0L));
        }
        if (dataToSave.getAverageDialedTalkDuration() == null) {
            dataToSave.setAverageDialedTalkDuration(Long.valueOf(0L));
        }
        if (agentCdr.getCallDirection().equalsIgnoreCase("OUT")) {
            dataToSave.setTotalDialed(Integer.valueOf(dataToSave.getTotalDialed() + 1));
            dataToSave.setTotalConnected(Integer.valueOf(dataToSave.getTotalConnected() + (Boolean.TRUE.equals(agentCdr.getIsMissed()) ? 0 : 1)));
            dataToSave.setTotalNotConnected(Integer.valueOf(dataToSave.getTotalNotConnected() + (Boolean.TRUE.equals(agentCdr.getIsMissed()) ? 1 : 0)));
            dataToSave.setTotalDialedDuration(Long.valueOf(dataToSave.getTotalDialedDuration() + ringDuration));
            dataToSave.setRealTotalDialedDuration(Long.valueOf(0L));
            dataToSave.setTotalDialedTalkDuration(Long.valueOf(dataToSave.getTotalDialedTalkDuration() + agentCdr.getRealTalkDuration()));
        } else {
            dataToSave.setTotalOffered(Integer.valueOf(dataToSave.getTotalOffered() + 1));
            dataToSave.setTotalAnswered(Integer.valueOf(dataToSave.getTotalAnswered() + (Boolean.TRUE.equals(agentCdr.getIsMissed()) ? 0 : 1)));
            dataToSave.setTotalNoAnswered(Integer.valueOf(dataToSave.getTotalNoAnswered() + (Boolean.TRUE.equals(agentCdr.getIsMissed()) ? 1 : 0)));
            dataToSave.setTotalRingDuration(Long.valueOf(dataToSave.getTotalRingDuration() + ringDuration));
            dataToSave.setTotalOfferedTalkDuration(Long.valueOf(dataToSave.getTotalOfferedTalkDuration() + agentCdr.getRealTalkDuration()));
            dataToSave.setSecond10(Integer.valueOf(dataToSave.getSecond10() + agentCdr.getSecond10()));
            dataToSave.setSecond20(Integer.valueOf(dataToSave.getSecond20() + agentCdr.getSecond20()));
            dataToSave.setSecond30(Integer.valueOf(dataToSave.getSecond30() + agentCdr.getSecond30()));
            dataToSave.setSecond40(Integer.valueOf(dataToSave.getSecond40() + agentCdr.getSecond40()));
            dataToSave.setSecond50(Integer.valueOf(dataToSave.getSecond50() + agentCdr.getSecond50()));
            dataToSave.setSecond60(Integer.valueOf(dataToSave.getSecond60() + agentCdr.getSecond60()));
        }
        dataToSave.setTotalTalkDuration(Long.valueOf(dataToSave.getTotalTalkDuration() + agentCdr.getRealTalkDuration()));
        if (dataToSave.getTotalAnswered() > 0 && dataToSave.getTotalOfferedTalkDuration() > 0L) {
            dataToSave.setAverageOfferedTalkDuration(Long.valueOf(dataToSave.getTotalOfferedTalkDuration() / (long)dataToSave.getTotalAnswered().intValue()));
        }
        if (dataToSave.getTotalConnected() > 0 && dataToSave.getTotalDialedTalkDuration() > 0L) {
            dataToSave.setAverageDialedTalkDuration(Long.valueOf(dataToSave.getTotalDialedTalkDuration() / (long)dataToSave.getTotalConnected().intValue()));
        }
        if (dataToSave.getTotalAnswered() + dataToSave.getTotalConnected() > 0 && dataToSave.getTotalTalkDuration() > 0L) {
            dataToSave.setAverageTalkDuration(Long.valueOf(dataToSave.getTotalTalkDuration() / (long)(dataToSave.getTotalAnswered() + dataToSave.getTotalConnected())));
        }
        if (dataToSave.getTotalOffered() + dataToSave.getTotalDialed() > 0 && dataToSave.getTotalRingDuration() + dataToSave.getTotalDialedDuration() > 0L) {
            dataToSave.setAverageRingDuration(Long.valueOf((dataToSave.getTotalRingDuration() + dataToSave.getTotalDialedDuration()) / (long)(dataToSave.getTotalOffered() + dataToSave.getTotalDialed())));
        }
        if (StringUtils.hasText((String)agentCdr.getMemberUUID()) && (dispositionData = this.dynamicPopUpDataRepository.findByUuid(agentCdr.getMemberUUID())) != null && !dispositionData.isEmpty()) {
            DynamicPopUpData data = (DynamicPopUpData)dispositionData.get(0);
            if (StringUtils.hasText((String)agentCdr.getBridgeUUID())) {
                Long endTime = agentCdr.getEndTime();
                if (endTime != null) {
                    LocalDateTime endStamp = LocalDateTime.ofInstant(Instant.ofEpochSecond(endTime), ZoneId.systemDefault());
                    LocalDateTime dispositionTime = data.getRecordCreatedOn();
                    if (dispositionTime != null && endStamp != null) {
                        UserStatusDetails toSaveUserStatus = new UserStatusDetails();
                        toSaveUserStatus.setExtensionNumber(agentCdr.getAgentName());
                        toSaveUserStatus.setUserName(agentCdr.getAgentName());
                        toSaveUserStatus.setUserFullName(agentCdr.getFullName());
                        toSaveUserStatus.setStatus("ACW");
                        toSaveUserStatus.setEndEpoch(Long.valueOf(dispositionTime.atZone(zoneId).toEpochSecond()));
                        toSaveUserStatus.setEndStamp(dispositionTime);
                        toSaveUserStatus.setStartEpoch(endTime);
                        toSaveUserStatus.setStartStamp(this.dateFormatUtility.toLocalDateTime(endTime.longValue()));
                        this.userStatusDetailsRepository.save((Object)toSaveUserStatus);
                        Integer duration = this.dateFormatUtility.getDurationInSeconds(endStamp, dispositionTime);
                        dataToSave.setTotalAcwDuration(Integer.valueOf(totalAcwDuration + duration));
                    }
                    data.setIsCallPicked(Boolean.valueOf(true));
                }
            } else {
                data.setIsCallPicked(Boolean.valueOf(false));
            }
            this.dynamicPopUpDataRepository.save((Object)data);
        }
        this.updateAgentDataInRepository(dataToSave);
    }

    private synchronized void initializeAgentData(AgentPerformance dataToSave) {
        dataToSave.setTotalOffered(Integer.valueOf(0));
        dataToSave.setTotalAnswered(Integer.valueOf(0));
        dataToSave.setTotalNoAnswered(Integer.valueOf(0));
        dataToSave.setTotalRingDuration(Long.valueOf(0L));
        dataToSave.setTotalTalkDuration(Long.valueOf(0L));
        dataToSave.setTotalOfferedTalkDuration(Long.valueOf(0L));
        dataToSave.setTotalDialedTalkDuration(Long.valueOf(0L));
        dataToSave.setSecond10(Integer.valueOf(0));
        dataToSave.setSecond20(Integer.valueOf(0));
        dataToSave.setSecond30(Integer.valueOf(0));
        dataToSave.setSecond40(Integer.valueOf(0));
        dataToSave.setSecond50(Integer.valueOf(0));
        dataToSave.setSecond60(Integer.valueOf(0));
        dataToSave.setTotalDialed(Integer.valueOf(0));
        dataToSave.setTotalConnected(Integer.valueOf(0));
        dataToSave.setTotalNotConnected(Integer.valueOf(0));
        dataToSave.setTotalBreakDuration(Integer.valueOf(0));
        dataToSave.setTotalLoginDuration(Integer.valueOf(0));
        dataToSave.setTotalAcwDuration(Integer.valueOf(0));
        dataToSave.setTotalIdleDuration(Integer.valueOf(0));
        dataToSave.setIsLoggedIn(Boolean.valueOf(false));
        dataToSave.setIsBreak(Boolean.valueOf(false));
        dataToSave.setLoginTime(null);
        dataToSave.setLogoutTime(null);
        dataToSave.setIsLoggedOut(Boolean.valueOf(false));
        dataToSave.setTotalLogoutDuration(Integer.valueOf(0));
        dataToSave.setBreakTime(null);
        dataToSave.setUnServicetDuration(Integer.valueOf(0));
        dataToSave.setStartCallTime(null);
        dataToSave.setTotalDialedDuration(Long.valueOf(0L));
        dataToSave.setAverageAcwDuration(Integer.valueOf(0));
        dataToSave.setAverageRingDuration(Long.valueOf(0L));
        dataToSave.setAverageTalkDuration(Long.valueOf(0L));
        dataToSave.setUnServiceLoginTime(null);
        dataToSave.setRealTotalDialedDuration(Long.valueOf(0L));
        dataToSave.setAverageOfferedTalkDuration(Long.valueOf(0L));
        dataToSave.setAverageDialedTalkDuration(Long.valueOf(0L));
    }

    private void updateQueuePerformanceData(Long midnightEpoch, CustomerCDR cdr) {
        int totalAbandonedCalls;
        Optional breakTimeOpt;
        ACDSummary acdSummaryToSave;
        QueuePerformanceCompositeKey queuePerformanceKey = new QueuePerformanceCompositeKey();
        queuePerformanceKey.setRecordEpoch(midnightEpoch);
        queuePerformanceKey.setQueue(cdr.getQueue());
        queuePerformanceKey.setCallDirection(cdr.getCallDirection());
        ACDSummaryCompositeKey acdSummaryKey = new ACDSummaryCompositeKey();
        acdSummaryKey.setRecordEpoch(midnightEpoch);
        acdSummaryKey.setQueue(cdr.getQueue());
        acdSummaryKey.setAgentName(StringUtils.hasText((String)cdr.getAnsweredBy()) ? cdr.getAnsweredBy() : " Abandoned");
        Optional queuePerformance = this.queuePerformanceRepository.findById((Object)queuePerformanceKey);
        QueuePerformance queuePerformanceToSave = queuePerformance.isPresent() ? (QueuePerformance)queuePerformance.get() : new QueuePerformance();
        Optional acdSummary = this.acdSummaryRepository.findById((Object)acdSummaryKey);
        ACDSummary aCDSummary = acdSummaryToSave = acdSummary.isPresent() ? (ACDSummary)acdSummary.get() : new ACDSummary();
        if (!queuePerformance.isPresent()) {
            queuePerformanceToSave.setQueuePerformanceCompositeKey(queuePerformanceKey);
            queuePerformanceToSave.setTotalJoined(Integer.valueOf(0));
            queuePerformanceToSave.setTotalConnectedWithAgent(Integer.valueOf(0));
            queuePerformanceToSave.setTotalAbandonedAtAgent(Integer.valueOf(0));
            queuePerformanceToSave.setTotalAbandonedAtQueue(Integer.valueOf(0));
            queuePerformanceToSave.setTotalNoContact(Integer.valueOf(0));
            queuePerformanceToSave.setTotalCustomerTime(Long.valueOf(0L));
            queuePerformanceToSave.setTotalCustomerAgentTalkTime(Long.valueOf(0L));
            queuePerformanceToSave.setTotalWaitTime(Long.valueOf(0L));
            queuePerformanceToSave.setAverageTalkTime(Long.valueOf(0L));
            queuePerformanceToSave.setAbandonedPercentage(Double.valueOf(0.0));
            queuePerformanceToSave.setAverageNumberAgent(Integer.valueOf(0));
            queuePerformanceToSave.setServicePercentage(Double.valueOf(0.0));
            queuePerformanceToSave.setTotalWaitTime(Long.valueOf(0L));
            queuePerformanceToSave.setAnswerWaitSecond10(Integer.valueOf(0));
            queuePerformanceToSave.setAnswerWaitSecond20(Integer.valueOf(0));
            queuePerformanceToSave.setAnswerWaitSecond30(Integer.valueOf(0));
            queuePerformanceToSave.setAnswerWaitSecond40(Integer.valueOf(0));
            queuePerformanceToSave.setAnswerWaitSecond50(Integer.valueOf(0));
            queuePerformanceToSave.setAnswerWaitSecond60(Integer.valueOf(0));
            queuePerformanceToSave.setGreaterAnswerWaitSecond60(Integer.valueOf(0));
            queuePerformanceToSave.setAbandonedWaitSecond10(Integer.valueOf(0));
            queuePerformanceToSave.setAbandonedWaitSecond20(Integer.valueOf(0));
            queuePerformanceToSave.setAbandonedWaitSecond30(Integer.valueOf(0));
            queuePerformanceToSave.setAbandonedWaitSecond40(Integer.valueOf(0));
            queuePerformanceToSave.setAbandonedWaitSecond50(Integer.valueOf(0));
            queuePerformanceToSave.setAbandonedWaitSecond60(Integer.valueOf(0));
            queuePerformanceToSave.setGreaterAbandonedWaitSecond60(Integer.valueOf(0));
            queuePerformanceToSave.setTotalAbandonedWaitTime(Long.valueOf(0L));
            queuePerformanceToSave.setTotalAnswerWaitTime(Long.valueOf(0L));
            queuePerformanceToSave.setAverageAnswerWaitTime(Long.valueOf(0L));
            queuePerformanceToSave.setAverageAbandonedWaitTime(Long.valueOf(0L));
        }
        if (!acdSummary.isPresent()) {
            acdSummaryToSave.setAcdSummaryCompositeKey(acdSummaryKey);
            acdSummaryToSave.setAgentFullName(StringUtils.hasText((String)cdr.getAnsweredBy()) ? cdr.getAnsweredByName() : " Abandoned");
            acdSummaryToSave.setTotalJoined(Integer.valueOf(0));
            acdSummaryToSave.setTotalDialed(Integer.valueOf(0));
            acdSummaryToSave.setTotalConnectedWithAgentIncoming(Integer.valueOf(0));
            acdSummaryToSave.setTotalConnectedWithAgentOutgoing(Integer.valueOf(0));
            acdSummaryToSave.setTotalAbandonedAtAgent(Integer.valueOf(0));
            acdSummaryToSave.setTotalAbandonedAtQueue(Integer.valueOf(0));
            acdSummaryToSave.setTotalNoContact(Integer.valueOf(0));
            acdSummaryToSave.setTotalCustomerTime(Long.valueOf(0L));
            acdSummaryToSave.setTotalCustomerAgentTalkTime(Long.valueOf(0L));
            acdSummaryToSave.setTotalWaitTime(Long.valueOf(0L));
            acdSummaryToSave.setTotalCalls(Integer.valueOf(0));
            acdSummaryToSave.setStatus("Not Break");
            acdSummaryToSave.setTotalBreakDuration(Long.valueOf(0L));
            acdSummaryToSave.setBreakTimeEpoch(midnightEpoch);
        }
        if ((breakTimeOpt = this.operatorDailyBreakTimeRepository.findById((Object)acdSummaryKey)).isPresent()) {
            acdSummaryToSave.setStatus(((OperatorDailyBreakTime)breakTimeOpt.get()).getStatus());
            acdSummaryToSave.setTotalBreakDuration(((OperatorDailyBreakTime)breakTimeOpt.get()).getBreakDuration());
            acdSummaryToSave.setBreakTimeEpoch(((OperatorDailyBreakTime)breakTimeOpt.get()).getStatusUpdateTimeEpoch());
        } else {
            acdSummaryToSave.setStatus("Not Break");
            acdSummaryToSave.setTotalBreakDuration(Long.valueOf(0L));
            acdSummaryToSave.setBreakTimeEpoch(midnightEpoch);
        }
        cdr.setAgentTalkTime(Long.valueOf(0L));
        AtomicBoolean isWaitTimeComputed = new AtomicBoolean(false);
        this.cdrRepository.findByBridgeUUID(cdr.getUuid()).forEach(agentRecord -> {
            String recordType;
            String string = recordType = StringUtils.hasText((String)agentRecord.getRecordType()) ? agentRecord.getRecordType() : "";
            if (agentRecord.getAnswerTime() > 0L && !recordType.equals(MEMBER)) {
                cdr.setAgentTalkTime(Long.valueOf(cdr.getAgentTalkTime() + (agentRecord.getEndTime() - agentRecord.getAnswerTime())));
                if (!isWaitTimeComputed.get()) {
                    if (cdr.getQueueJoinedEpoch() != null && cdr.getQueueJoinedEpoch() > 0L) {
                        cdr.setWaitTime(Long.valueOf(agentRecord.getAnswerTime() - cdr.getQueueJoinedEpoch()));
                    } else {
                        cdr.setWaitTime(Long.valueOf(agentRecord.getAnswerTime() - cdr.getStartTime()));
                    }
                    isWaitTimeComputed.set(true);
                }
            }
        });
        if (StringUtils.hasText((String)cdr.getBridgeUUID())) {
            if (cdr.getAgentTalkTime() == 0L) {
                cdr.setAgentTalkTime(Long.valueOf(1L));
            }
            queuePerformanceToSave.setTotalAnswerWaitTime(Long.valueOf(queuePerformanceToSave.getTotalAnswerWaitTime() + cdr.getWaitTime()));
            queuePerformanceToSave.setAnswerWaitSecond10(Integer.valueOf(queuePerformanceToSave.getAnswerWaitSecond10() + (cdr.getWaitTime() <= 10L ? 1 : 0)));
            queuePerformanceToSave.setAnswerWaitSecond20(Integer.valueOf(queuePerformanceToSave.getAnswerWaitSecond20() + (cdr.getWaitTime() > 10L && cdr.getWaitTime() <= 20L ? 1 : 0)));
            queuePerformanceToSave.setAnswerWaitSecond30(Integer.valueOf(queuePerformanceToSave.getAnswerWaitSecond30() + (cdr.getWaitTime() > 20L && cdr.getWaitTime() <= 30L ? 1 : 0)));
            queuePerformanceToSave.setAnswerWaitSecond40(Integer.valueOf(queuePerformanceToSave.getAnswerWaitSecond40() + (cdr.getWaitTime() > 30L && cdr.getWaitTime() <= 40L ? 1 : 0)));
            queuePerformanceToSave.setAnswerWaitSecond50(Integer.valueOf(queuePerformanceToSave.getAnswerWaitSecond50() + (cdr.getWaitTime() > 40L && cdr.getWaitTime() <= 50L ? 1 : 0)));
            queuePerformanceToSave.setAnswerWaitSecond60(Integer.valueOf(queuePerformanceToSave.getAnswerWaitSecond60() + (cdr.getWaitTime() > 50L && cdr.getWaitTime() <= 60L ? 1 : 0)));
            queuePerformanceToSave.setGreaterAnswerWaitSecond60(Integer.valueOf(queuePerformanceToSave.getGreaterAnswerWaitSecond60() + (cdr.getWaitTime() > 60L ? 1 : 0)));
        } else {
            if (cdr.getQueueJoinedEpoch() != null && cdr.getQueueJoinedEpoch() > 0L) {
                cdr.setWaitTime(Long.valueOf(cdr.getEndTime() - cdr.getQueueJoinedEpoch()));
            } else {
                cdr.setWaitTime(Long.valueOf(cdr.getEndTime() - cdr.getStartTime()));
            }
            if (cdr.getStatus().equalsIgnoreCase("ABD at Queue") || cdr.getStatus().equalsIgnoreCase("ABD at Agent")) {
                queuePerformanceToSave.setTotalAbandonedWaitTime(Long.valueOf(queuePerformanceToSave.getTotalAbandonedWaitTime() + cdr.getWaitTime()));
                queuePerformanceToSave.setAbandonedWaitSecond10(Integer.valueOf(queuePerformanceToSave.getAbandonedWaitSecond10() + (cdr.getWaitTime() <= 10L ? 1 : 0)));
                queuePerformanceToSave.setAbandonedWaitSecond20(Integer.valueOf(queuePerformanceToSave.getAbandonedWaitSecond20() + (cdr.getWaitTime() > 10L && cdr.getWaitTime() <= 20L ? 1 : 0)));
                queuePerformanceToSave.setAbandonedWaitSecond30(Integer.valueOf(queuePerformanceToSave.getAbandonedWaitSecond30() + (cdr.getWaitTime() > 20L && cdr.getWaitTime() <= 30L ? 1 : 0)));
                queuePerformanceToSave.setAbandonedWaitSecond40(Integer.valueOf(queuePerformanceToSave.getAbandonedWaitSecond40() + (cdr.getWaitTime() > 30L && cdr.getWaitTime() <= 40L ? 1 : 0)));
                queuePerformanceToSave.setAbandonedWaitSecond50(Integer.valueOf(queuePerformanceToSave.getAbandonedWaitSecond50() + (cdr.getWaitTime() > 40L && cdr.getWaitTime() <= 50L ? 1 : 0)));
                queuePerformanceToSave.setAbandonedWaitSecond60(Integer.valueOf(queuePerformanceToSave.getAbandonedWaitSecond60() + (cdr.getWaitTime() > 50L && cdr.getWaitTime() <= 60L ? 1 : 0)));
                queuePerformanceToSave.setGreaterAbandonedWaitSecond60(Integer.valueOf(queuePerformanceToSave.getGreaterAbandonedWaitSecond60() + (cdr.getWaitTime() > 60L ? 1 : 0)));
            }
        }
        queuePerformanceToSave.setTotalCustomerAgentTalkTime(Long.valueOf(queuePerformanceToSave.getTotalCustomerAgentTalkTime() + cdr.getAgentTalkTime()));
        acdSummaryToSave.setTotalCustomerAgentTalkTime(Long.valueOf(acdSummaryToSave.getTotalCustomerAgentTalkTime() + cdr.getAgentTalkTime()));
        queuePerformanceToSave.setTotalJoined(Integer.valueOf(queuePerformanceToSave.getTotalJoined() + 1));
        if (cdr.getCallDirection().equals("IN")) {
            acdSummaryToSave.setTotalJoined(Integer.valueOf(acdSummaryToSave.getTotalJoined() + 1));
        } else {
            acdSummaryToSave.setTotalDialed(Integer.valueOf(acdSummaryToSave.getTotalDialed() + 1));
        }
        acdSummaryToSave.setTotalCalls(Integer.valueOf(acdSummaryToSave.getTotalCalls() + 1));
        if (cdr.getFinalStatus() == 1) {
            queuePerformanceToSave.setTotalConnectedWithAgent(Integer.valueOf(queuePerformanceToSave.getTotalConnectedWithAgent() + 1));
            if (cdr.getCallDirection().equals("IN")) {
                acdSummaryToSave.setTotalConnectedWithAgentIncoming(Integer.valueOf(acdSummaryToSave.getTotalConnectedWithAgentIncoming() + 1));
            } else {
                acdSummaryToSave.setTotalConnectedWithAgentOutgoing(Integer.valueOf(acdSummaryToSave.getTotalConnectedWithAgentOutgoing() + 1));
            }
        } else if (cdr.getFinalStatus() == -1) {
            queuePerformanceToSave.setTotalAbandonedAtAgent(Integer.valueOf(queuePerformanceToSave.getTotalAbandonedAtAgent() + 1));
            acdSummaryToSave.setTotalAbandonedAtAgent(Integer.valueOf(acdSummaryToSave.getTotalAbandonedAtAgent() + 1));
        } else if (cdr.getFinalStatus() == -2) {
            queuePerformanceToSave.setTotalAbandonedAtQueue(Integer.valueOf(queuePerformanceToSave.getTotalAbandonedAtQueue() + 1));
            acdSummaryToSave.setTotalAbandonedAtQueue(Integer.valueOf(acdSummaryToSave.getTotalAbandonedAtQueue() + 1));
        } else {
            queuePerformanceToSave.setTotalNoContact(Integer.valueOf(queuePerformanceToSave.getTotalNoContact() + 1));
            acdSummaryToSave.setTotalNoContact(Integer.valueOf(acdSummaryToSave.getTotalNoContact() + 1));
        }
        if (cdr.getAnswerTime() > 0L) {
            queuePerformanceToSave.setTotalCustomerTime(Long.valueOf(queuePerformanceToSave.getTotalCustomerTime() + (cdr.getEndTime() - cdr.getAnswerTime())));
            acdSummaryToSave.setTotalCustomerTime(Long.valueOf(acdSummaryToSave.getTotalCustomerTime() + (cdr.getEndTime() - cdr.getAnswerTime())));
            if (cdr.getCallDirection().equals("OUT")) {
                cdr.setWaitTime(Long.valueOf(0L));
            } else {
                queuePerformanceToSave.setTotalWaitTime(Long.valueOf(queuePerformanceToSave.getTotalWaitTime() + cdr.getWaitTime()));
                acdSummaryToSave.setTotalWaitTime(Long.valueOf(acdSummaryToSave.getTotalWaitTime() + cdr.getWaitTime()));
            }
        } else {
            cdr.setWaitTime(Long.valueOf(0L));
        }
        if (queuePerformanceToSave.getTotalCustomerAgentTalkTime() > 0L) {
            queuePerformanceToSave.setAverageTalkTime(Long.valueOf(queuePerformanceToSave.getTotalCustomerAgentTalkTime() / (long)queuePerformanceToSave.getTotalConnectedWithAgent().intValue()));
        }
        if (queuePerformanceToSave.getTotalConnectedWithAgent() != null && queuePerformanceToSave.getTotalConnectedWithAgent() > 0) {
            queuePerformanceToSave.setAverageAnswerWaitTime(Long.valueOf(queuePerformanceToSave.getTotalAnswerWaitTime() / (long)queuePerformanceToSave.getTotalConnectedWithAgent().intValue()));
        }
        if ((totalAbandonedCalls = (queuePerformanceToSave.getTotalAbandonedAtAgent() != null ? queuePerformanceToSave.getTotalAbandonedAtAgent() : 0) + (queuePerformanceToSave.getTotalAbandonedAtQueue() != null ? queuePerformanceToSave.getTotalAbandonedAtQueue() : 0)) > 0) {
            queuePerformanceToSave.setAverageAbandonedWaitTime(Long.valueOf(queuePerformanceToSave.getTotalAbandonedWaitTime() / (long)totalAbandonedCalls));
        }
        if (queuePerformanceToSave.getTotalJoined() > 0) {
            double totalConnected = queuePerformanceToSave.getTotalConnectedWithAgent().intValue();
            double totalJoined = queuePerformanceToSave.getTotalJoined().intValue();
            double servicePercentage = totalConnected / totalJoined * 100.0;
            BigDecimal roundedService = new BigDecimal(servicePercentage).setScale(2, RoundingMode.HALF_UP);
            queuePerformanceToSave.setServicePercentage(Double.valueOf(roundedService.doubleValue()));
            double abandonedPercentage = 100.0 - roundedService.doubleValue();
            BigDecimal roundedAbandoned = new BigDecimal(abandonedPercentage).setScale(2, RoundingMode.HALF_UP);
            queuePerformanceToSave.setAbandonedPercentage(Double.valueOf(roundedAbandoned.doubleValue()));
        }
        long totalCost = 0L;
        if (cdr.getPulse() != null && cdr.getPulse() > 0L && cdr.getPulseRate() != null && cdr.getPulseRate() > 0L) {
            totalCost = (long)Math.ceil((double)cdr.getAgentTalkTime().longValue() / (double)cdr.getPulse().longValue()) * cdr.getPulseRate();
        }
        cdr.setCost(Long.valueOf(totalCost));
        acdSummaryToSave.setQueueName(cdr.getQueueName());
        queuePerformanceToSave.setQueueName(cdr.getQueueName());
        this.acdSummaryRepository.save((Object)acdSummaryToSave);
        this.queuePerformanceRepository.save((Object)queuePerformanceToSave);
    }

    private void updateCampaignPerformance(Long midnightEpoch, CallDataRecord cdr, String campaignName) {
        CampaignPerformance dataToSave;
        CampaignPerformanceCompositeKey recordKey = new CampaignPerformanceCompositeKey();
        recordKey.setRecordEpoch(midnightEpoch);
        recordKey.setCampaignName(campaignName);
        Optional campaignPerformance = this.campaignPerformanceRepository.findById((Object)recordKey);
        CampaignPerformance campaignPerformance2 = dataToSave = campaignPerformance.isPresent() ? (CampaignPerformance)campaignPerformance.get() : new CampaignPerformance();
        if (!campaignPerformance.isPresent()) {
            dataToSave.setCampaignPerformanceCompositeKey(recordKey);
            dataToSave.setTotalDialed(Long.valueOf(0L));
            dataToSave.setTotalAgentConnectTime(Long.valueOf(0L));
            dataToSave.setTotalConnectedWithAgent(Integer.valueOf(0));
            dataToSave.setTotalMemberTime(Long.valueOf(0L));
            dataToSave.setTotalOffered(Integer.valueOf(0));
        }
        dataToSave.setTotalDialed(Long.valueOf(dataToSave.getTotalDialed() + 1L));
        if (cdr.getAnswerTime() > 0L) {
            this.cdrRepository.findByMemberUUID(cdr.getUuid()).forEach(agentRecord -> {
                if (agentRecord.getAnswerTime() > 0L) {
                    dataToSave.setTotalAgentConnectTime(Long.valueOf(dataToSave.getTotalAgentConnectTime() + (agentRecord.getEndTime() - agentRecord.getAnswerTime())));
                }
            });
            dataToSave.setTotalOffered(Integer.valueOf(dataToSave.getTotalOffered() + 1));
            dataToSave.setTotalConnectedWithAgent(Integer.valueOf(dataToSave.getTotalConnectedWithAgent() + (StringUtils.hasText((String)cdr.getBridgeUUID()) ? 1 : 0)));
            dataToSave.setTotalMemberTime(Long.valueOf(dataToSave.getTotalMemberTime() + (cdr.getEndTime() - cdr.getAnswerTime())));
        }
        this.campaignPerformanceRepository.save((Object)dataToSave);
    }

    private void updateLeadPerformance(Long midnightEpoch, CallDataRecord cdr, String leadId) {
        LeadPerformance dataToSave;
        LeadPerformanceCompositeKey recordKey = new LeadPerformanceCompositeKey();
        recordKey.setRecordEpoch(midnightEpoch);
        recordKey.setUuid(leadId);
        Optional leadPerformance = this.leadPerformanceRepository.findById((Object)recordKey);
        LeadPerformance leadPerformance2 = dataToSave = leadPerformance.isPresent() ? (LeadPerformance)leadPerformance.get() : new LeadPerformance();
        if (!leadPerformance.isPresent()) {
            dataToSave.setLeadPerformanceCompositeKey(recordKey);
            dataToSave.setTotalDialed(Long.valueOf(0L));
            dataToSave.setTotalAgentConnectTime(Long.valueOf(0L));
            dataToSave.setTotalConnectedWithAgent(Integer.valueOf(0));
            dataToSave.setTotalMemberTime(Long.valueOf(0L));
            dataToSave.setTotalOffered(Integer.valueOf(0));
        }
        dataToSave.setTotalDialed(Long.valueOf(dataToSave.getTotalDialed() + 1L));
        if (cdr.getAnswerTime() > 0L) {
            this.cdrRepository.findByMemberUUID(cdr.getUuid()).forEach(agentRecord -> {
                if (agentRecord.getAnswerTime() > 0L) {
                    dataToSave.setTotalAgentConnectTime(Long.valueOf(dataToSave.getTotalAgentConnectTime() + (agentRecord.getEndTime() - agentRecord.getAnswerTime())));
                }
            });
            dataToSave.setTotalOffered(Integer.valueOf(dataToSave.getTotalOffered() + 1));
            dataToSave.setTotalConnectedWithAgent(Integer.valueOf(dataToSave.getTotalConnectedWithAgent() + (StringUtils.hasText((String)cdr.getBridgeUUID()) ? 1 : 0)));
            dataToSave.setTotalMemberTime(Long.valueOf(dataToSave.getTotalMemberTime() + (cdr.getEndTime() - cdr.getAnswerTime())));
        }
        this.leadPerformanceRepository.save((Object)dataToSave);
    }

    private void updateLastNAgentRecord(AgentCDR cdrData) {
        LastNAgentCDR lastNAgentCDR = new LastNAgentCDR();
        lastNAgentCDR.setUuid(cdrData.getUuid());
        lastNAgentCDR.setAgentName(cdrData.getAgentName());
        lastNAgentCDR.setAnswerTime(cdrData.getAnswerTime());
        lastNAgentCDR.setBridgeUUID(cdrData.getBridgeUUID());
        lastNAgentCDR.setCampaignName(cdrData.getCampaignName());
        lastNAgentCDR.setCustomerNumber(cdrData.getCustomerNumber());
        lastNAgentCDR.setEndTime(cdrData.getEndTime());
        lastNAgentCDR.setQueueName(cdrData.getQueueName());
        lastNAgentCDR.setRecordingFile(cdrData.getRecordingFile());
        lastNAgentCDR.setRecordingFileType(this.typeOfRecording(lastNAgentCDR.getRecordingFile()));
        lastNAgentCDR.setStartTime(cdrData.getStartTime());
        lastNAgentCDR.setQueue(cdrData.getQueue());
        lastNAgentCDR.setPulse(cdrData.getPulse());
        lastNAgentCDR.setPulseRate(cdrData.getPulseRate());
        lastNAgentCDR.setRecordType(cdrData.getRecordType());
        lastNAgentCDR.setFullName(cdrData.getFullName());
        lastNAgentCDR.setIsMissed(cdrData.getIsMissed());
        lastNAgentCDR.setCallId(cdrData.getCallId());
        lastNAgentCDR.setQueueType(cdrData.getQueueType());
        lastNAgentCDR.setLeadName(cdrData.getLeadName());
        lastNAgentCDR.setHangupCause(cdrData.getHangupCause());
        lastNAgentCDR.setSecond10(cdrData.getSecond10());
        lastNAgentCDR.setSecond20(cdrData.getSecond20());
        lastNAgentCDR.setSecond30(cdrData.getSecond30());
        lastNAgentCDR.setSecond40(cdrData.getSecond40());
        lastNAgentCDR.setSecond50(cdrData.getSecond50());
        lastNAgentCDR.setSecond60(cdrData.getSecond60());
        lastNAgentCDR.setCallDirection(cdrData.getCallDirection());
        lastNAgentCDR.setCost(cdrData.getCost());
        lastNAgentCDR.setTalkDuration(cdrData.getRealTalkDuration());
        lastNAgentCDR.setAgentTalkedTo(cdrData.getAgentTalkedTo());
        if (cdrData.getCallDirection().equalsIgnoreCase("IN")) {
            if (Boolean.TRUE.equals(cdrData.getIsMissed())) {
                lastNAgentCDR.setRecordGroup("IN-M");
            } else {
                lastNAgentCDR.setRecordGroup("IN-A");
            }
        } else if (Boolean.TRUE.equals(cdrData.getIsMissed())) {
            lastNAgentCDR.setRecordGroup("OUT-M");
        } else {
            lastNAgentCDR.setRecordGroup("OUT-A");
        }
        this.lastNAgentCDRRepository.save((Object)lastNAgentCDR);
        List agentRecords = this.lastNAgentCDRRepository.findByAgentNameAndRecordGroupOrderByStartTime(lastNAgentCDR.getAgentName(), lastNAgentCDR.getRecordGroup());
        int recordsToDelete = agentRecords.size() - this.lastNRecords;
        if (recordsToDelete > 0) {
            for (int i = 0; i < recordsToDelete; ++i) {
                this.lastNAgentCDRRepository.delete(agentRecords.get(i));
            }
        }
    }

    private void updateDialer(Long midnightEpoch, CallDataRecord cdrData) {
        String uploadLead;
        Long uploadLeadId;
        Optional leadData;
        if (StringUtils.hasText((String)cdrData.getCallerIDName()) && cdrData.getCallerIDName().toLowerCase().startsWith("lead") && (leadData = this.uploadLeadDataRepository.findById((Object)(uploadLeadId = Long.valueOf(Long.parseLong(uploadLead = cdrData.getCallerIDName().toLowerCase().split("_")[1].split(":")[1]))))).isPresent()) {
            String uuid = ((UploadLeadData)leadData.get()).getUuid();
            this.updateLeadPerformance(midnightEpoch, cdrData, uuid);
            if (StringUtils.hasText((String)cdrData.getCampaign())) {
                this.updateCampaignPerformance(midnightEpoch, cdrData, cdrData.getCampaign());
            }
        }
    }

    public int channelDataCollection() {
        List channelList = null;
        try {
            channelList = this.channelRepository.findByIsDataSyncedAndRecordingFile();
            if (!channelList.isEmpty()) {
                for (Channel toSaveData : channelList) {
                    int isDataSynced = this.channelDataTransfer(toSaveData);
                    toSaveData.setIsDataSynced(Integer.valueOf(isDataSynced));
                    this.channelRepository.save((Object)toSaveData);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error in Getting Data from db {}", (Object)e.getMessage());
        }
        return channelList != null ? channelList.size() : 0;
    }

    public int processUserStatusInteractions() {
        List userStatusDataList = null;
        try {
            userStatusDataList = "O".equalsIgnoreCase(CALLCENTERVERSION) ? this.userStatusRepository.findByIsDataSyncedForO() : this.userStatusRepository.findByIsDataSyncedForNOrNull();
            if (!userStatusDataList.isEmpty()) {
                for (UserStatus userStatus : userStatusDataList) {
                    UserDetailsDataModel agentDetails = this.checkUserDetails(userStatus.getUsername(), "ROLE_AGENT");
                    UserDetailsDataModel ocAdminDetails = this.checkUserDetails(userStatus.getUsername(), "ROLE_OCADMIN");
                    int isDataSynced = 2;
                    if (Boolean.TRUE.equals(agentDetails.getIsUserPresentForRole()) || Boolean.TRUE.equals(ocAdminDetails.getIsUserPresentForRole())) {
                        isDataSynced = this.processAgentLoginData(userStatus);
                    }
                    userStatus.setIsDataSynced(Integer.valueOf(isDataSynced));
                    this.userStatusRepository.save((Object)userStatus);
                }
            } else {
                logger.info("userStatusData List is empty");
            }
        }
        catch (Exception e) {
            logger.error("Error in Getting Data from db {}", (Object)e.getMessage());
        }
        return userStatusDataList != null ? userStatusDataList.size() : 0;
    }

    private void updateAgentDataInRepository(AgentPerformance dataToSave) {
        this.agentPerformanceRepository.save((Object)dataToSave);
    }

    private void computeOperatorBreakTime(long midnightEpoch, UserStatus userDetails) {
        try {
            Tiers operatorQueueData;
            List operatorQueueDetails = this.tiersRepository.findByAgent(userDetails.getExtensionNumber());
            if (!operatorQueueDetails.isEmpty() && StringUtils.hasText((String)(operatorQueueData = (Tiers)operatorQueueDetails.get(0)).getQueue()) && operatorQueueData.getQueue().startsWith("ACD")) {
                ACDSummaryCompositeKey operatorKey = new ACDSummaryCompositeKey();
                operatorKey.setRecordEpoch(Long.valueOf(midnightEpoch));
                operatorKey.setAgentName(userDetails.getExtensionNumber());
                operatorKey.setQueue(operatorQueueData.getQueue().split("_")[1]);
                Optional operatorDetails = this.operatorDailyBreakTimeRepository.findById((Object)operatorKey);
                LocalDateTime currentTime = userDetails.getCurrTime();
                long currentEpoch = currentTime.atZone(ZoneId.systemDefault()).toEpochSecond();
                if (operatorDetails.isPresent()) {
                    OperatorDailyBreakTime existingRecord = (OperatorDailyBreakTime)operatorDetails.get();
                    if ("On Break".equalsIgnoreCase(existingRecord.getStatus())) {
                        if ("BreakOut".equalsIgnoreCase(userDetails.getStatus()) || !"BreakIn".equalsIgnoreCase(userDetails.getStatus())) {
                            long breakDuration = currentEpoch - existingRecord.getStatusUpdateTimeEpoch();
                            existingRecord.setBreakDuration(Long.valueOf(existingRecord.getBreakDuration() + breakDuration));
                            existingRecord.setStatus("Not Break");
                            existingRecord.setStatusUpdateTimeEpoch(Long.valueOf(currentEpoch));
                        }
                    } else if ("BreakIn".equalsIgnoreCase(userDetails.getStatus())) {
                        existingRecord.setStatusUpdateTimeEpoch(Long.valueOf(currentEpoch));
                        existingRecord.setStatus("On Break");
                    } else {
                        existingRecord.setStatus("Not Break");
                    }
                    this.operatorDailyBreakTimeRepository.save((Object)existingRecord);
                } else {
                    OperatorDailyBreakTime newOperatorDetails = new OperatorDailyBreakTime();
                    newOperatorDetails.setAcdSummaryCompositeKey(operatorKey);
                    newOperatorDetails.setBreakDuration(Long.valueOf(0L));
                    newOperatorDetails.setStatusUpdateTimeEpoch(Long.valueOf(currentEpoch));
                    newOperatorDetails.setStatus("BreakIn".equalsIgnoreCase(userDetails.getStatus()) ? "On Break" : "Not Break");
                    this.operatorDailyBreakTimeRepository.save((Object)newOperatorDetails);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error While Computing Break time for operator: {} {} {}", (Object)userDetails.getUuid().toString(), (Object)e.getMessage(), (Object)e);
        }
    }

    private int processAgentLoginData(UserStatus userDetails) {
        try {
            LocalDateTime currTime = userDetails.getCurrTime();
            long midnightEpoch = this.dateFormatUtility.getMidNightEpochFromDateTime(currTime);
            AgentPerformanceCompositeKey agentKey = new AgentPerformanceCompositeKey();
            agentKey.setRecordEpoch(Long.valueOf(midnightEpoch));
            agentKey.setAgentName(userDetails.getUsername());
            this.computeOperatorBreakTime(midnightEpoch, userDetails);
            Optional agentPerformance = this.agentPerformanceRepository.findById((Object)agentKey);
            AgentPerformance dataToSave = null;
            if (agentPerformance.isPresent()) {
                dataToSave = (AgentPerformance)agentPerformance.get();
            } else {
                dataToSave = new AgentPerformance();
                dataToSave.setAgentPerformanceCompositeKey(agentKey);
                this.initializeAgentData(dataToSave);
            }
            if (!StringUtils.hasText((String)dataToSave.getFullName()) && StringUtils.hasText((String)userDetails.getUserFullName())) {
                dataToSave.setFullName(userDetails.getUserFullName());
            }
            String status = userDetails.getStatus();
            boolean isBreak = dataToSave.getIsBreak() == null ? false : dataToSave.getIsBreak();
            boolean isLoggedIn = dataToSave.getIsLoggedIn() == null ? false : dataToSave.getIsLoggedIn();
            LocalDateTime breakTime = dataToSave.getBreakTime();
            LocalDateTime loginTime = dataToSave.getLoginTime();
            LocalDateTime logoutTime = dataToSave.getLogoutTime();
            boolean isLoggedOut = dataToSave.getIsLoggedOut() == null ? false : dataToSave.getIsLoggedOut();
            Integer totalLoginDuration = dataToSave.getTotalLoginDuration() == null ? 0 : dataToSave.getTotalLoginDuration();
            Integer totalBreakDuration = dataToSave.getTotalBreakDuration() == null ? 0 : dataToSave.getTotalBreakDuration();
            Integer totalLogoutDuration = dataToSave.getTotalLogoutDuration() == null ? 0 : dataToSave.getTotalLogoutDuration();
            Integer unServiceDuration = dataToSave.getUnServicetDuration() == null ? 0 : dataToSave.getUnServicetDuration();
            LocalDateTime unServiceLoginTime = dataToSave.getUnServiceLoginTime();
            Long recordEpoch = agentKey.getRecordEpoch();
            LocalDateTime recordEpochTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(recordEpoch), ZoneId.systemDefault());
            String currentStatus = !StringUtils.hasText((String)dataToSave.getCurrentStatus()) ? " " : dataToSave.getCurrentStatus();
            Integer totalAcwDuration = dataToSave.getTotalAcwDuration() == null ? 0 : dataToSave.getTotalAcwDuration();
            if (!status.equalsIgnoreCase("ACW")) {
                if (status.equalsIgnoreCase("Login")) {
                    if (!currentStatus.equalsIgnoreCase(status)) {
                        if (!isLoggedIn) {
                            dataToSave.setIsLoggedIn(Boolean.valueOf(true));
                            dataToSave.setLoginTime(currTime);
                            if (isLoggedOut) {
                                if (logoutTime != null) {
                                    this.saveUserStatusDetails(userDetails, logoutTime, currTime, "Logout");
                                    int logoutDuration = this.dateFormatUtility.getDurationInSeconds(logoutTime, currTime);
                                    dataToSave.setTotalLogoutDuration(Integer.valueOf(totalLogoutDuration + logoutDuration));
                                    dataToSave.setIsLoggedOut(Boolean.valueOf(false));
                                    dataToSave.setLogoutTime(null);
                                }
                            } else {
                                dataToSave.setIsLoggedOut(Boolean.valueOf(false));
                            }
                        }
                        if (unServiceLoginTime == null) {
                            dataToSave.setStartCallTime(null);
                            dataToSave.setUnServiceLoginTime(currTime);
                        }
                        if (isBreak) {
                            if (breakTime != null) {
                                this.saveUserStatusDetails(userDetails, breakTime, currTime, "Break");
                                int breakDuration = this.dateFormatUtility.getDurationInSeconds(breakTime, currTime);
                                dataToSave.setTotalBreakDuration(Integer.valueOf(totalBreakDuration + breakDuration));
                                dataToSave.setIsBreak(Boolean.valueOf(false));
                                dataToSave.setBreakTime(null);
                            } else {
                                dataToSave.setIsBreak(Boolean.valueOf(false));
                            }
                        }
                    }
                } else if (status.equalsIgnoreCase("Start Call")) {
                    if (!currentStatus.equalsIgnoreCase(status)) {
                        if (unServiceLoginTime != null) {
                            dataToSave.setStartCallTime(currTime);
                            this.saveUserStatusDetails(userDetails, unServiceLoginTime, currTime, "Start Call");
                            int unserviceDurationUpdate = this.dateFormatUtility.getDurationInSeconds(unServiceLoginTime, currTime);
                            dataToSave.setUnServicetDuration(Integer.valueOf(unServiceDuration + unserviceDurationUpdate));
                            dataToSave.setUnServiceLoginTime(null);
                        }
                        if (isBreak) {
                            if (breakTime != null) {
                                this.saveUserStatusDetails(userDetails, breakTime, currTime, "Break");
                                int breakDuration = this.dateFormatUtility.getDurationInSeconds(breakTime, currTime);
                                dataToSave.setTotalBreakDuration(Integer.valueOf(totalBreakDuration + breakDuration));
                                dataToSave.setIsBreak(Boolean.valueOf(false));
                                dataToSave.setBreakTime(null);
                            } else {
                                dataToSave.setIsBreak(Boolean.valueOf(false));
                            }
                        }
                    }
                } else if (status.equalsIgnoreCase("Off-Hook") || status.equalsIgnoreCase("Manual Dial")) {
                    if (!currentStatus.equalsIgnoreCase(status)) {
                        if (isBreak) {
                            if (breakTime != null) {
                                this.saveUserStatusDetails(userDetails, breakTime, currTime, "Break");
                                int breakDuration = this.dateFormatUtility.getDurationInSeconds(breakTime, currTime);
                                dataToSave.setTotalBreakDuration(Integer.valueOf(totalBreakDuration + breakDuration));
                                dataToSave.setIsBreak(Boolean.valueOf(false));
                                dataToSave.setBreakTime(null);
                            } else {
                                dataToSave.setIsBreak(Boolean.valueOf(false));
                            }
                        }
                        if (unServiceLoginTime != null) {
                            dataToSave.setStartCallTime(currTime);
                            this.saveUserStatusDetails(userDetails, unServiceLoginTime, currTime, "Start Call");
                            int unserviceDurationUpdate = this.dateFormatUtility.getDurationInSeconds(unServiceLoginTime, currTime);
                            dataToSave.setUnServicetDuration(Integer.valueOf(unServiceDuration + unserviceDurationUpdate));
                            dataToSave.setUnServiceLoginTime(null);
                        }
                    }
                } else if (isLoggedIn && status.equalsIgnoreCase("Logout")) {
                    if (!currentStatus.equalsIgnoreCase(status)) {
                        int loginDuration;
                        dataToSave.setIsLoggedOut(Boolean.valueOf(true));
                        dataToSave.setLogoutTime(currTime);
                        if (loginTime != null) {
                            this.saveUserStatusDetails(userDetails, loginTime, currTime, "Login");
                            loginDuration = this.dateFormatUtility.getDurationInSeconds(loginTime, currTime);
                            dataToSave.setTotalLoginDuration(Integer.valueOf(totalLoginDuration + loginDuration));
                            dataToSave.setIsLoggedIn(Boolean.valueOf(false));
                            dataToSave.setLoginTime(null);
                        } else {
                            this.saveUserStatusDetails(userDetails, currTime.minusSeconds(1L), currTime, "Login");
                            loginDuration = this.dateFormatUtility.getDurationInSeconds(recordEpochTime, currTime);
                            dataToSave.setTotalLoginDuration(Integer.valueOf(totalLoginDuration + loginDuration));
                            dataToSave.setIsLoggedIn(Boolean.valueOf(false));
                        }
                        if (isBreak) {
                            if (breakTime != null) {
                                this.saveUserStatusDetails(userDetails, breakTime, currTime, "Break");
                                int breakDuration = this.dateFormatUtility.getDurationInSeconds(breakTime, currTime);
                                dataToSave.setTotalBreakDuration(Integer.valueOf(totalBreakDuration + breakDuration));
                                dataToSave.setIsBreak(Boolean.valueOf(false));
                                dataToSave.setBreakTime(null);
                            } else {
                                dataToSave.setIsBreak(Boolean.valueOf(false));
                            }
                        }
                        if (unServiceLoginTime != null) {
                            dataToSave.setStartCallTime(currTime);
                            this.saveUserStatusDetails(userDetails, unServiceLoginTime, currTime, "Start Call");
                            int unserviceDurationUpdate = this.dateFormatUtility.getDurationInSeconds(unServiceLoginTime, currTime);
                            dataToSave.setUnServicetDuration(Integer.valueOf(unServiceDuration + unserviceDurationUpdate));
                            dataToSave.setUnServiceLoginTime(null);
                        }
                    }
                } else if (!currentStatus.equalsIgnoreCase(status)) {
                    if (!isBreak) {
                        dataToSave.setIsBreak(Boolean.valueOf(true));
                        dataToSave.setBreakTime(currTime);
                    }
                    if (unServiceLoginTime != null) {
                        dataToSave.setStartCallTime(currTime);
                        this.saveUserStatusDetails(userDetails, unServiceLoginTime, currTime, "Start Call");
                        int unserviceDurationUpdate = this.dateFormatUtility.getDurationInSeconds(unServiceLoginTime, currTime);
                        dataToSave.setUnServicetDuration(Integer.valueOf(unServiceDuration + unserviceDurationUpdate));
                        dataToSave.setUnServiceLoginTime(null);
                    }
                }
            } else if ("O".equals(CALLCENTERVERSION) && status.equalsIgnoreCase("ACW")) {
                this.saveUserStatusDetails(userDetails, userDetails.getCurrTime(), userDetails.getPreviousTime(), "ACW");
                dataToSave.setTotalAcwDuration(Integer.valueOf(totalAcwDuration + this.dateFormatUtility.getDurationInSeconds(userDetails.getCurrTime(), userDetails.getPreviousTime())));
            }
            dataToSave.setCurrentStatus(status);
            this.updateAgentDataInRepository(dataToSave);
            return 1;
        }
        catch (Exception e) {
            logger.error("Error in processing  Agent Login Data. {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }

    private void saveUserStatusDetails(UserStatus userDetails, LocalDateTime startStamp, LocalDateTime endStamp, String status) {
        try {
            UserStatusDetails toSaveUserStatus = new UserStatusDetails();
            toSaveUserStatus.setExtensionNumber(userDetails.getExtensionNumber());
            toSaveUserStatus.setUserName(userDetails.getUsername());
            toSaveUserStatus.setUserFullName(userDetails.getUserFullName());
            toSaveUserStatus.setStatus(status);
            toSaveUserStatus.setStartStamp(startStamp);
            toSaveUserStatus.setEndStamp(endStamp);
            toSaveUserStatus.setStartEpoch(Long.valueOf(this.dateFormatUtility.toEpoch(startStamp)));
            toSaveUserStatus.setEndEpoch(Long.valueOf(this.dateFormatUtility.toEpoch(endStamp)));
            this.userStatusDetailsRepository.save((Object)toSaveUserStatus);
        }
        catch (Exception e) {
            logger.error("Error While saving user status details: {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String getDirection(CallDataRecord cdr) {
        String returnValue = "";
        returnValue = StringUtils.hasText((String)cdr.getCallerIDName()) && cdr.getCallerIDName().startsWith("lead") ? "OUT" : (StringUtils.hasText((String)cdr.getQueue()) && (cdr.getQueue().equalsIgnoreCase(DIAL_OUT) || cdr.getQueue().endsWith("_OUT")) ? "OUT" : (StringUtils.hasText((String)cdr.getAgentType()) && cdr.getAgentType().equalsIgnoreCase("manual") ? "OUT" : "IN"));
        return returnValue;
    }

    private void updateVoicePicker(CallDataRecord cdrData, CallDataRecord originalCdr, String queue, String queueName) {
        Boolean callerIsExtension = false;
        Boolean destinationIsExtension = false;
        try {
            Optional agentExtensionsDetails;
            VoiceLogger voiceLogger = new VoiceLogger();
            voiceLogger.setAgentName(cdrData.getAgentName());
            voiceLogger.setAnswerTime(cdrData.getAnswerTime());
            voiceLogger.setBillsec(cdrData.getBillsec());
            voiceLogger.setCallerIdNumber(cdrData.getCallerIDNumber());
            voiceLogger.setMos(cdrData.getRtpAudioInMos());
            voiceLogger.setQueue(queue);
            if (StringUtils.hasText((String)queueName)) {
                voiceLogger.setQueueName(queueName.trim().replaceAll("\\s+", "_"));
            }
            if (StringUtils.hasText((String)cdrData.getBridgeUUID())) {
                voiceLogger.setStatus("answered");
            } else if (voiceLogger.getAnswerTime() != null && voiceLogger.getAnswerTime() > 0L) {
                voiceLogger.setStatus("answered");
            } else {
                voiceLogger.setStatus("unanswered");
            }
            if (StringUtils.hasText((String)cdrData.getDestinationNumber()) && cdrData.getDestinationNumber().equalsIgnoreCase("siprec")) {
                voiceLogger.setDestinationNumber("");
            } else {
                voiceLogger.setDestinationNumber(cdrData.getDestinationNumber().split("@", 2)[0].trim());
            }
            if (StringUtils.hasText((String)cdrData.getCallerIDNumber())) {
                Optional callerExtensionsDetails = this.extensionsRepository.findByExtension(cdrData.getCallerIDNumber());
                if (callerExtensionsDetails.isPresent()) {
                    voiceLogger.setCallerName(((Extension)callerExtensionsDetails.get()).getName());
                    callerIsExtension = true;
                } else {
                    voiceLogger.setCallerName(voiceLogger.getCallerIdNumber());
                }
            } else {
                voiceLogger.setCallerName("");
            }
            Optional destinationExtensionsDetails = this.extensionsRepository.findByExtension(cdrData.getDestinationNumber());
            if (destinationExtensionsDetails.isPresent()) {
                destinationIsExtension = true;
            }
            voiceLogger.setColumn3(cdrData.getColumn3());
            voiceLogger.setCoralApp(cdrData.getCoralApp());
            if (callerIsExtension.booleanValue() && destinationIsExtension.booleanValue()) {
                voiceLogger.setDirection("INT");
            } else if (callerIsExtension.booleanValue()) {
                voiceLogger.setDirection("OUT");
            } else {
                voiceLogger.setDirection("IN");
            }
            Boolean isAgentUpdated = false;
            if (StringUtils.hasText((String)cdrData.getQueue()) && !originalCdr.getQueue().equalsIgnoreCase(DIAL_OUT) && StringUtils.hasText((String)voiceLogger.getDirection()) && (voiceLogger.getDirection().equalsIgnoreCase("INT") || voiceLogger.getDirection().equalsIgnoreCase("IN")) && StringUtils.hasText((String)originalCdr.getAgentName())) {
                voiceLogger.setDestinationNumber(originalCdr.getAgentName());
                isAgentUpdated = true;
            }
            if (StringUtils.hasText((String)voiceLogger.getDestinationNumber())) {
                if (destinationIsExtension.booleanValue()) {
                    voiceLogger.setDestName(((Extension)destinationExtensionsDetails.get()).getName());
                } else if (voiceLogger.getDirection().equalsIgnoreCase("INT") || voiceLogger.getDirection().equalsIgnoreCase("IN")) {
                    voiceLogger.setDestName(cdrData.getDestinationName());
                } else {
                    voiceLogger.setDestName("");
                }
            } else {
                voiceLogger.setDestName("");
            }
            if (!StringUtils.hasText((String)voiceLogger.getCallerName())) {
                voiceLogger.setCallerName(voiceLogger.getCallerIdNumber());
            }
            if (isAgentUpdated.booleanValue() && (agentExtensionsDetails = this.extensionsRepository.findByExtension(voiceLogger.getDestinationNumber())).isPresent()) {
                voiceLogger.setDestName(((Extension)agentExtensionsDetails.get()).getName());
            }
            if (StringUtils.hasText((String)voiceLogger.getDestinationNumber()) && !StringUtils.hasText((String)voiceLogger.getDestName()) && !cdrData.getDestinationNumber().equalsIgnoreCase("siprec")) {
                voiceLogger.setDestName(voiceLogger.getDestinationNumber());
            }
            voiceLogger.setDuration(cdrData.getDuration());
            voiceLogger.setEndTime(cdrData.getEndTime());
            voiceLogger.setFileTime(cdrData.getStartTime());
            voiceLogger.setHangupCause(cdrData.getHangupCause());
            voiceLogger.setLocation(cdrData.getRemoteMeidaIp());
            voiceLogger.setRecordFilename(cdrData.getRecordingFile());
            voiceLogger.setRecordingFileType(this.typeOfRecording(voiceLogger.getRecordFilename()));
            voiceLogger.setRemoteCallerIp(cdrData.getRemoteCallerIp());
            voiceLogger.setStartTime(cdrData.getStartTime());
            voiceLogger.setUuid(cdrData.getUuid().toString());
            if (!StringUtils.hasText((String)voiceLogger.getCoralApp())) {
                voiceLogger.setCoralApp(voiceLogger.getRecordingFileType());
            }
            voiceLogger.setRtpJitterMinVariance(cdrData.getRtpJitterMinVariance());
            voiceLogger.setRtpJitterMaxVariance(cdrData.getRtpJitterMaxVariance());
            voiceLogger.setRtpJitterLossRate(cdrData.getRtpJitterLossRate());
            this.voiceLoggerRepository.save((Object)voiceLogger);
        }
        catch (Exception e) {
            logger.error("Error in updating voiceLogger data. {} {} ", (Object)e.getMessage(), (Object)e);
        }
    }

    private int channelDataTransfer(Channel channelData) {
        try {
            long duration;
            VoiceLogger voiceLogger = new VoiceLogger();
            voiceLogger.setCallerIdNumber(channelData.getActualLocalUser() != null ? channelData.getActualLocalUser() : channelData.getLocalUser());
            voiceLogger.setCallerName(channelData.getLocalName());
            voiceLogger.setDestinationNumber(channelData.getActualRemoteUser() != null ? channelData.getActualRemoteUser() : channelData.getRemoteUser());
            voiceLogger.setHangupCause(channelData.getHangupCause());
            voiceLogger.setStartTime(Long.valueOf(channelData.getRingEpoch() / 1000L));
            voiceLogger.setEndTime(Long.valueOf(channelData.getEndEpoch() / 1000L));
            voiceLogger.setDirection(channelData.getDirection());
            voiceLogger.setColumn3(channelData.getId().toString());
            voiceLogger.setRecordFilename(channelData.getRecordingFile());
            voiceLogger.setRecordingFileType(this.typeOfRecording(voiceLogger.getRecordFilename()));
            voiceLogger.setMos(channelData.getMos());
            voiceLogger.setQueue("");
            voiceLogger.setQueueName("");
            if (channelData.getAnswerEpoch() > 0L) {
                duration = (long)Math.ceil((double)(channelData.getEndEpoch() - channelData.getAnswerEpoch()) / 1000.0);
                voiceLogger.setStatus("answered");
            } else {
                duration = 0L;
                voiceLogger.setStatus("unanswered");
            }
            voiceLogger.setDuration(Integer.valueOf((int)duration));
            voiceLogger.setAgentName("");
            voiceLogger.setBillsec(Long.valueOf(duration));
            voiceLogger.setCdrId(channelData.getId());
            voiceLogger.setRemoteCallerIp(channelData.getSourceIp());
            voiceLogger.setRemoteCalleeIp(channelData.getDestinationIp());
            voiceLogger.setCoralApp(channelData.getServerCode());
            voiceLogger.setAnswerTime(channelData.getAnswerEpoch() == 0L ? null : Long.valueOf(channelData.getAnswerEpoch() / 1000L));
            voiceLogger.setLocation(channelData.getHostname());
            voiceLogger.setDestName(channelData.getRemoteName());
            voiceLogger.setFileTime(Long.valueOf(channelData.getRingEpoch() / 1000L));
            voiceLogger.setRtpJitterMinVariance(channelData.getRtpJitterMinVariance());
            voiceLogger.setRtpJitterMaxVariance(channelData.getRtpJitterMaxVariance());
            voiceLogger.setRtpJitterLossRate(channelData.getRtpJitterLossRate());
            this.voiceLoggerRepository.save((Object)voiceLogger);
            return 1;
        }
        catch (Exception e) {
            logger.error("Error in transfering channelData. {}", (Object)e.getMessage());
            return 0;
        }
    }

    public void setDataFromChannelsInBillingCdr() {
        List channelDataList = this.channelForBillingCdrRepository.findAllDataForSynced();
        if (!channelDataList.isEmpty()) {
            for (ChannelForBillingCdr channelData : channelDataList) {
                LocalDateTime cdrGeneratedTime = channelData.getStartTime();
                long midnightEpoch = this.dateFormatUtility.getMidNightEpochFromDateTime(cdrGeneratedTime);
                logger.info("channel data process for billing cdr callId : {} {}", (Object)channelData.getCallId(), (Object)midnightEpoch);
                try {
                    Optional dataPresentInBillingCdr = this.billingCDRRepository.findByUuid(channelData.getCallId());
                    if (dataPresentInBillingCdr.isPresent()) {
                        logger.info("Channel data is already processed with same callId.");
                        continue;
                    }
                    BillingCDR dataToSave = new BillingCDR();
                    dataToSave.setCallerIDNumber(channelData.getCallerIdNumber());
                    dataToSave.setCallerName(channelData.getCallerName());
                    dataToSave.setDestinationNumber(channelData.getDestinationNumber());
                    dataToSave.setDestinationName(channelData.getDestinationName());
                    dataToSave.setStartTime(Long.valueOf(this.dateFormatUtility.toEpoch(channelData.getStartTime())));
                    if (channelData.getAnswerTime() != null) {
                        dataToSave.setAnswerTime(Long.valueOf(this.dateFormatUtility.toEpoch(channelData.getAnswerTime())));
                    } else {
                        dataToSave.setAnswerTime(Long.valueOf(0L));
                    }
                    dataToSave.setEndTime(Long.valueOf(this.dateFormatUtility.toEpoch(channelData.getEndTime())));
                    if (StringUtils.hasText((String)channelData.getStatus()) && channelData.getStatus().equalsIgnoreCase("Answered")) {
                        dataToSave.setCallConnected(Boolean.valueOf(true));
                        dataToSave.setTalkDuration(Long.valueOf(dataToSave.getEndTime() - dataToSave.getAnswerTime()));
                    } else {
                        dataToSave.setCallConnected(Boolean.valueOf(false));
                        dataToSave.setTalkDuration(Long.valueOf(0L));
                    }
                    dataToSave.setMos(channelData.getMos());
                    dataToSave.setPulse(channelData.getPulse());
                    dataToSave.setPulseRate(channelData.getPulseRate());
                    dataToSave.setDuration(channelData.getDuration());
                    dataToSave.setDIDNumber(channelData.getDIDNumber());
                    dataToSave.setDODNumber(channelData.getDODNumber());
                    dataToSave.setCallType(channelData.getCallType());
                    dataToSave.setCoralApp("");
                    dataToSave.setCoralGateway(channelData.getCoralGateway());
                    dataToSave.setCoralGatewayName(channelData.getCoralGatewayName());
                    dataToSave.setCoralInBoundGateway(channelData.getCoralInBoundGateway());
                    dataToSave.setCoralInBoundGatewayName(channelData.getCoralInBoundGatewayName());
                    long totalCost = 0L;
                    if (dataToSave.getPulse() > 0L) {
                        totalCost = (long)Math.ceil((double)dataToSave.getTalkDuration().longValue() / (double)dataToSave.getPulse().longValue()) * dataToSave.getPulseRate();
                    }
                    dataToSave.setCost(Long.valueOf(totalCost));
                    Optional callerIsExtension = this.extensionsRepository.findByExtension(channelData.getCallerIdNumber());
                    Optional destinationIsExtension = this.extensionsRepository.findByExtension(channelData.getDestinationNumber());
                    if (callerIsExtension.isPresent() && destinationIsExtension.isPresent()) {
                        dataToSave.setCoralCallDirection("INT");
                        if (!StringUtils.hasText((String)dataToSave.getCallerName())) {
                            dataToSave.setCallerName(((Extension)callerIsExtension.get()).getName());
                        }
                        if (!StringUtils.hasText((String)dataToSave.getDestinationName())) {
                            dataToSave.setDestinationName(((Extension)destinationIsExtension.get()).getName());
                        }
                        dataToSave.setCallType("INTERCOM");
                    } else if (callerIsExtension.isPresent()) {
                        dataToSave.setCoralCallDirection("OUT");
                        if (!StringUtils.hasText((String)dataToSave.getCallerName())) {
                            dataToSave.setCallerName(((Extension)callerIsExtension.get()).getName());
                        }
                        dataToSave.setCallType(this.checkCallType(dataToSave.getDestinationNumber()));
                    } else {
                        dataToSave.setCoralCallDirection("IN");
                        if (!StringUtils.hasText((String)dataToSave.getDestinationName())) {
                            dataToSave.setDestinationName(((Extension)destinationIsExtension.get()).getName());
                        }
                        dataToSave.setCallType("INCOMING");
                    }
                    dataToSave.setUuid(channelData.getCallId());
                    if (!StringUtils.hasText((String)dataToSave.getCallerName())) {
                        dataToSave.setCallerName(channelData.getCallerIdNumber());
                    }
                    if (!StringUtils.hasText((String)dataToSave.getDestinationName())) {
                        dataToSave.setDestinationName(channelData.getDestinationNumber());
                    }
                    if (StringUtils.hasText((String)dataToSave.getCoralInBoundGateway())) {
                        dataToSave.setCoralGateway("");
                    }
                    String callerDepartmentCode = "";
                    String callerDepartmentName = "";
                    String destinationDepartmentCode = "";
                    String destinationDepartmentName = "";
                    if (callerIsExtension.isPresent() && StringUtils.hasText((String)((Extension)callerIsExtension.get()).getDepartment())) {
                        callerDepartmentCode = ((Extension)callerIsExtension.get()).getDepartment();
                        callerDepartmentName = this.getDepartmentDetails(callerDepartmentCode);
                    }
                    if (destinationIsExtension.isPresent() && StringUtils.hasText((String)((Extension)destinationIsExtension.get()).getDepartment())) {
                        destinationDepartmentCode = ((Extension)destinationIsExtension.get()).getDepartment();
                        destinationDepartmentName = this.getDepartmentDetails(destinationDepartmentCode);
                    }
                    dataToSave.setCallerDepartmentCode(callerDepartmentCode);
                    dataToSave.setCallerDepartmentName(callerDepartmentName);
                    dataToSave.setDepartmentCode(callerDepartmentCode);
                    dataToSave.setDepartmentName(callerDepartmentName);
                    dataToSave.setDestinationDepartmentCode(destinationDepartmentCode);
                    dataToSave.setDestinationDepartmentName(destinationDepartmentName);
                    if (StringUtils.hasText((String)dataToSave.getCoralCallDirection())) {
                        if (dataToSave.getCoralCallDirection().equalsIgnoreCase("INT")) {
                            this.updateBillingCDRSummaryReportFromChannels(Long.valueOf(midnightEpoch), dataToSave.getCallerIDNumber(), dataToSave, Boolean.valueOf(false));
                            this.updateBillingCDRSummaryReportFromChannels(Long.valueOf(midnightEpoch), dataToSave.getDestinationNumber(), dataToSave, Boolean.valueOf(true));
                        } else if (dataToSave.getCoralCallDirection().equalsIgnoreCase("IN")) {
                            this.updateBillingCDRSummaryReportFromChannels(Long.valueOf(midnightEpoch), dataToSave.getDestinationNumber(), dataToSave, Boolean.valueOf(false));
                        } else {
                            this.updateBillingCDRSummaryReportFromChannels(Long.valueOf(midnightEpoch), dataToSave.getCallerIDNumber(), dataToSave, Boolean.valueOf(false));
                        }
                    }
                    this.billingCDRRepository.save((Object)dataToSave);
                    if (Boolean.TRUE.equals(Constants.BILLING_ENABLE_THIRD_PARTY_BILLING)) {
                        this.activeMQProducer.sendMessageToQueue("billing-cdr", (Object)dataToSave);
                    }
                    this.channelRepository.updateIsDataSynced(channelData.getCallId(), Integer.valueOf(1));
                }
                catch (Exception e) {
                    this.channelRepository.updateIsDataSynced(channelData.getCallId(), Integer.valueOf(-100));
                    logger.error("Error while processing channel data for billing cdr (callId={}): {}", (Object)channelData.getCallId(), (Object)e.getMessage(), (Object)e);
                }
            }
        } else {
            logger.info("channel data list is empty for billing cdr.");
        }
    }

    private String checkCallType(String destinationNumber) {
        List dialCodeListData = this.dialCodeListRepository.findAll();
        if (!dialCodeListData.isEmpty()) {
            DialCodeList dialCodeData = (DialCodeList)dialCodeListData.get(0);
            if (StringUtils.hasText((String)dialCodeData.getIsd()) && destinationNumber.startsWith(dialCodeData.getIsd())) {
                return "ISD";
            }
            if (StringUtils.hasText((String)dialCodeData.getStd()) && destinationNumber.startsWith(dialCodeData.getStd())) {
                return "STD";
            }
            return "LOCAL";
        }
        return "LOCAL";
    }

    private void setDataBillingCdrReport(Long midnightEpoch, CallDataRecord cdrData) {
        try {
            logger.info("Setting CdrData into Billing CDR ");
            BillingCDR billingCdrData = new BillingCDR();
            billingCdrData.setAgentName(cdrData.getAgentName());
            billingCdrData.setMos(cdrData.getRtpAudioInMos());
            billingCdrData.setDuration(Long.valueOf(cdrData.getDuration() != null ? cdrData.getDuration().longValue() : 0L));
            billingCdrData.setCoralApp(cdrData.getCoralApp());
            billingCdrData.setAnswerTime(cdrData.getAnswerTime());
            billingCdrData.setBillsec(cdrData.getBillsec());
            billingCdrData.setBridgeUUID(cdrData.getBridgeUUID());
            billingCdrData.setPulse(Long.valueOf(cdrData.getPulse() != null && cdrData.getPulse() > 0L ? cdrData.getPulse() : 0L));
            billingCdrData.setPulseRate(Long.valueOf(cdrData.getPulseRate() != null && cdrData.getPulseRate() > 0L ? cdrData.getPulseRate() : 0L));
            billingCdrData.setCallerIDNumber(cdrData.getCallerIDNumber());
            billingCdrData.setDestinationNumber(cdrData.getDestinationNumber());
            billingCdrData.setEndTime(cdrData.getEndTime());
            billingCdrData.setInitialCallerIdNumber(cdrData.getInitialCallerIdNumber());
            billingCdrData.setMemberSessionUUID(cdrData.getMemberSessionUUID());
            billingCdrData.setQueue(cdrData.getQueue());
            billingCdrData.setRecordType(cdrData.getRecordType());
            billingCdrData.setRecordingFile(cdrData.getRecordingFile());
            billingCdrData.setRecordingFileType(this.typeOfRecording(cdrData.getRecordingFile()));
            billingCdrData.setStartTime(cdrData.getStartTime());
            billingCdrData.setUuid(cdrData.getUuid().toString());
            billingCdrData.setDestinationName(cdrData.getDestinationName());
            billingCdrData.setMemberUUID(cdrData.getMemberUUID());
            billingCdrData.setInitialDestinationNumber(cdrData.getInitialDestinationNumber());
            billingCdrData.setCoralGateway(cdrData.getCoralGateway());
            if (StringUtils.hasText((String)cdrData.getCoralGateway()) && !StringUtils.hasText((String)cdrData.getCoralGatewayName())) {
                Optional outGateway = this.gatewayMasterRepository.findByGwCode(cdrData.getCoralGateway());
                if (outGateway.isPresent() && StringUtils.hasText((String)((GatewayMaster)outGateway.get()).getGwName())) {
                    billingCdrData.setCoralGatewayName(((GatewayMaster)outGateway.get()).getGwName());
                } else {
                    billingCdrData.setCoralGatewayName(billingCdrData.getCoralGateway());
                }
            } else {
                billingCdrData.setCoralGatewayName(cdrData.getCoralGatewayName());
            }
            billingCdrData.setCoralInBoundGateway(cdrData.getCoralInBoundGateway());
            if (StringUtils.hasText((String)cdrData.getCoralInBoundGateway()) && !StringUtils.hasText((String)cdrData.getCoralInBoundGatewayName())) {
                Optional inGateway = this.inboundGatewayRepository.findByGwCode(billingCdrData.getCoralInBoundGateway());
                if (inGateway.isPresent() && StringUtils.hasText((String)((InboundGateway)inGateway.get()).getGwName())) {
                    billingCdrData.setCoralInBoundGatewayName(((InboundGateway)inGateway.get()).getGwName());
                } else {
                    billingCdrData.setCoralInBoundGatewayName(billingCdrData.getCoralInBoundGateway());
                }
            } else {
                billingCdrData.setCoralInBoundGatewayName(cdrData.getCoralInBoundGatewayName());
            }
            billingCdrData.setContext(cdrData.getContext());
            if (StringUtils.hasText((String)cdrData.getCoralFeatureCode())) {
                billingCdrData.setCoralFeatureCode(cdrData.getCoralFeatureCode());
            } else {
                billingCdrData.setCoralFeatureCode("");
            }
            String destinationNumber = "";
            destinationNumber = StringUtils.hasText((String)cdrData.getInitialDestinationNumber()) ? cdrData.getInitialDestinationNumber() : cdrData.getDestinationNumber();
            Optional callerIsExtension = this.extensionsRepository.findByExtension(cdrData.getCallerIDNumber());
            Optional destinationIsExtension = this.extensionsRepository.findByExtension(destinationNumber);
            if (StringUtils.hasText((String)cdrData.getCoralCallDirection())) {
                if (cdrData.getCoralCallDirection().equalsIgnoreCase("INT") && StringUtils.hasText((String)cdrData.getContext()) && cdrData.getContext().equalsIgnoreCase("public")) {
                    billingCdrData.setCoralCallDirection("IN");
                    billingCdrData.setCallType("INCOMING");
                } else {
                    billingCdrData.setCoralCallDirection(cdrData.getCoralCallDirection());
                    if (cdrData.getCoralCallDirection().equalsIgnoreCase("INT")) {
                        billingCdrData.setCallType("INTERCOM");
                    } else if (cdrData.getCoralCallDirection().equalsIgnoreCase("IN")) {
                        billingCdrData.setCallType("INCOMING");
                    } else {
                        billingCdrData.setCallType(this.checkCallType(billingCdrData.getDestinationNumber()));
                    }
                }
            } else if (callerIsExtension.isPresent() && destinationIsExtension.isPresent()) {
                billingCdrData.setCoralCallDirection("INT");
                billingCdrData.setCallType("INTERCOM");
            } else if (destinationIsExtension.isPresent()) {
                billingCdrData.setCoralCallDirection("IN");
                billingCdrData.setCallType("INCOMING");
            } else {
                billingCdrData.setCoralCallDirection("OUT");
                billingCdrData.setCallType(this.checkCallType(billingCdrData.getDestinationNumber()));
            }
            if (callerIsExtension.isPresent() && StringUtils.hasText((String)((Extension)callerIsExtension.get()).getName())) {
                billingCdrData.setCallerName(((Extension)callerIsExtension.get()).getName());
            } else if (StringUtils.hasText((String)cdrData.getCallerIDName())) {
                billingCdrData.setCallerName(cdrData.getCallerIDName());
            } else {
                billingCdrData.setCallerName(cdrData.getCallerIDNumber());
            }
            if (destinationIsExtension.isPresent() && StringUtils.hasText((String)((Extension)destinationIsExtension.get()).getName())) {
                billingCdrData.setDestinationName(((Extension)destinationIsExtension.get()).getName());
            } else if (StringUtils.hasText((String)cdrData.getDestinationName())) {
                billingCdrData.setDestinationName(cdrData.getDestinationName());
            } else {
                billingCdrData.setDestinationName(cdrData.getDestinationNumber());
            }
            String callerDepartmentCode = "";
            String callerDepartmentName = "";
            String destinationDepartmentCode = "";
            String destinationDepartmentName = "";
            if (callerIsExtension.isPresent() && StringUtils.hasText((String)((Extension)callerIsExtension.get()).getDepartment())) {
                callerDepartmentCode = ((Extension)callerIsExtension.get()).getDepartment();
                callerDepartmentName = this.getDepartmentDetails(callerDepartmentCode);
            }
            if (destinationIsExtension.isPresent() && StringUtils.hasText((String)((Extension)destinationIsExtension.get()).getDepartment())) {
                destinationDepartmentCode = ((Extension)destinationIsExtension.get()).getDepartment();
                destinationDepartmentName = this.getDepartmentDetails(destinationDepartmentCode);
            }
            billingCdrData.setCallerDepartmentCode(callerDepartmentCode);
            billingCdrData.setCallerDepartmentName(callerDepartmentName);
            billingCdrData.setDepartmentCode(callerDepartmentCode);
            billingCdrData.setDepartmentName(callerDepartmentName);
            billingCdrData.setDestinationDepartmentCode(destinationDepartmentCode);
            billingCdrData.setDestinationDepartmentName(destinationDepartmentName);
            billingCdrData.setTransferAgent(StringUtils.hasText((String)cdrData.getTransferBy()) ? cdrData.getTransferBy() : "");
            billingCdrData.setAllDestinationNames("");
            billingCdrData.setOperator("");
            if (StringUtils.hasText((String)cdrData.getBridgeUUID())) {
                billingCdrData.setCallConnected(Boolean.valueOf(true));
                billingCdrData.setRingDuration(Long.valueOf(cdrData.getAnswerTime() - cdrData.getStartTime()));
                billingCdrData.setTalkDuration(Long.valueOf(cdrData.getEndTime() - cdrData.getAnswerTime()));
                if (billingCdrData.getTalkDuration() == 0L) {
                    billingCdrData.setTalkDuration(Long.valueOf(1L));
                }
            } else {
                billingCdrData.setCallConnected(Boolean.valueOf(false));
                billingCdrData.setRingDuration(Long.valueOf(cdrData.getEndTime() - cdrData.getStartTime()));
                billingCdrData.setTalkDuration(Long.valueOf(0L));
            }
            long totalCost = 0L;
            if (billingCdrData.getPulse() > 0L) {
                totalCost = (long)Math.ceil((double)billingCdrData.getTalkDuration().longValue() / (double)billingCdrData.getPulse().longValue()) * billingCdrData.getPulseRate();
            }
            billingCdrData.setCost(Long.valueOf(totalCost));
            if (StringUtils.hasText((String)billingCdrData.getCoralInBoundGateway())) {
                billingCdrData.setCoralGateway("");
            }
            if (StringUtils.hasText((String)cdrData.getCoralCallDirection())) {
                if (cdrData.getCoralCallDirection().equalsIgnoreCase("INT")) {
                    this.updateBillingCDRSummaryReport(midnightEpoch, cdrData.getCallerIDNumber(), billingCdrData, Boolean.valueOf(false), cdrData);
                    this.updateBillingCDRSummaryReport(midnightEpoch, destinationNumber, billingCdrData, Boolean.valueOf(true), cdrData);
                } else if (cdrData.getCoralCallDirection().equalsIgnoreCase("IN")) {
                    this.updateBillingCDRSummaryReport(midnightEpoch, destinationNumber, billingCdrData, Boolean.valueOf(false), cdrData);
                } else if (cdrData.getCoralCallDirection().equalsIgnoreCase("OUT")) {
                    this.updateBillingCDRSummaryReport(midnightEpoch, cdrData.getCallerIDNumber(), billingCdrData, Boolean.valueOf(false), cdrData);
                }
            }
            this.billingCDRRepository.save((Object)billingCdrData);
            if (Boolean.TRUE.equals(Constants.BILLING_ENABLE_THIRD_PARTY_BILLING)) {
                this.activeMQProducer.sendMessageToQueue("billing-cdr", (Object)billingCdrData);
            }
        }
        catch (Exception e) {
            logger.error("Error While Setting Data in Billing Cdr {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private String getDepartmentDetails(String departmentCode) {
        String returnValue = "";
        Optional departmentData = this.departmentRepository.findByCode(departmentCode);
        if (departmentData.isPresent()) {
            return ((Department)departmentData.get()).getDescription();
        }
        return returnValue;
    }

    private void updateBillingCDRSummaryReportFromChannels(Long midnightEpoch, String extension, BillingCDR billingCDR, Boolean destinationIsExtensionINTCall) {
        try {
            BillingCDRSummaryCompositeKey billingCdrSummaryCompositeKey = new BillingCDRSummaryCompositeKey();
            billingCdrSummaryCompositeKey.setStartDayEpoch(midnightEpoch);
            billingCdrSummaryCompositeKey.setExtension(extension);
            Optional billingCdrSummary = this.billingCDRSummaryRepository.findById((Object)billingCdrSummaryCompositeKey);
            BillingCDRSummary dataToSave = null;
            if (billingCdrSummary.isPresent()) {
                dataToSave = (BillingCDRSummary)billingCdrSummary.get();
            } else {
                dataToSave = new BillingCDRSummary();
                dataToSave.setBillingCDRCompositeKey(billingCdrSummaryCompositeKey);
                this.initializeBillingCDRSummary(dataToSave);
            }
            if (!StringUtils.hasText((String)dataToSave.getDepartmentCode())) {
                dataToSave.setDepartmentCode(destinationIsExtensionINTCall != false ? billingCDR.getDestinationDepartmentCode() : billingCDR.getCallerDepartmentCode());
            }
            if (!StringUtils.hasText((String)dataToSave.getDepartmentName())) {
                dataToSave.setDepartmentName(destinationIsExtensionINTCall != false ? billingCDR.getDestinationDepartmentName() : billingCDR.getCallerDepartmentName());
            }
            if (billingCDR.getCoralCallDirection().equalsIgnoreCase("INT")) {
                if (Boolean.TRUE.equals(destinationIsExtensionINTCall)) {
                    dataToSave.setInternalReceived(Integer.valueOf(dataToSave.getInternalReceived() + 1));
                    if (Boolean.TRUE.equals(billingCDR.getCallConnected())) {
                        dataToSave.setInternalReceivedAnswered(Integer.valueOf(dataToSave.getInternalReceivedAnswered() + 1));
                    } else {
                        dataToSave.setInternalReceivedAbandoned(Integer.valueOf(dataToSave.getInternalReceivedAbandoned() + 1));
                    }
                } else {
                    dataToSave.setInternalDialed(Integer.valueOf(dataToSave.getInternalDialed() + 1));
                }
            } else if (billingCDR.getCoralCallDirection().equalsIgnoreCase("IN")) {
                dataToSave.setExternalReceived(Integer.valueOf(dataToSave.getExternalReceived() + 1));
                if (Boolean.TRUE.equals(billingCDR.getCallConnected())) {
                    dataToSave.setExternalReceivedAnswered(Integer.valueOf(dataToSave.getExternalReceivedAnswered() + 1));
                } else {
                    dataToSave.setExternalReceivedAbandoned(Integer.valueOf(dataToSave.getExternalReceivedAbandoned() + 1));
                }
            } else {
                dataToSave.setExternalDialed(Integer.valueOf(dataToSave.getExternalDialed() + 1));
            }
            this.billingCDRSummaryRepository.save((Object)dataToSave);
        }
        catch (Exception e) {
            logger.error("Error While Setting Data in Billing Cdr of Channels in Summary Report {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void updateBillingCDRSummaryReport(Long midnightEpoch, String extension, BillingCDR billingCDR, Boolean destinationIsExtensionINTCall, CallDataRecord cdrData) {
        try {
            BillingCDRSummaryCompositeKey billingCdrSummaryCompisteKey = new BillingCDRSummaryCompositeKey();
            billingCdrSummaryCompisteKey.setStartDayEpoch(midnightEpoch);
            billingCdrSummaryCompisteKey.setExtension(extension);
            Optional billingCdrSummary = this.billingCDRSummaryRepository.findById((Object)billingCdrSummaryCompisteKey);
            BillingCDRSummary dataToSave = null;
            if (billingCdrSummary.isPresent()) {
                dataToSave = (BillingCDRSummary)billingCdrSummary.get();
            } else {
                dataToSave = new BillingCDRSummary();
                dataToSave.setBillingCDRCompositeKey(billingCdrSummaryCompisteKey);
                this.initializeBillingCDRSummary(dataToSave);
            }
            if (!StringUtils.hasText((String)dataToSave.getDepartmentCode())) {
                dataToSave.setDepartmentCode(destinationIsExtensionINTCall != false ? billingCDR.getDestinationDepartmentCode() : billingCDR.getCallerDepartmentCode());
            }
            if (!StringUtils.hasText((String)dataToSave.getDepartmentName())) {
                dataToSave.setDepartmentName(destinationIsExtensionINTCall != false ? billingCDR.getDestinationDepartmentName() : billingCDR.getCallerDepartmentName());
            }
            if (cdrData.getCoralCallDirection().equalsIgnoreCase("INT")) {
                if (Boolean.TRUE.equals(destinationIsExtensionINTCall)) {
                    dataToSave.setInternalReceived(Integer.valueOf(dataToSave.getInternalReceived() + 1));
                    if (Boolean.TRUE.equals(billingCDR.getCallConnected())) {
                        dataToSave.setInternalReceivedAnswered(Integer.valueOf(dataToSave.getInternalReceivedAnswered() + 1));
                    } else {
                        dataToSave.setInternalReceivedAbandoned(Integer.valueOf(dataToSave.getInternalReceivedAbandoned() + 1));
                    }
                } else {
                    dataToSave.setInternalDialed(Integer.valueOf(dataToSave.getInternalDialed() + 1));
                }
            } else if (cdrData.getCoralCallDirection().equalsIgnoreCase("IN")) {
                dataToSave.setExternalReceived(Integer.valueOf(dataToSave.getExternalReceived() + 1));
                if (Boolean.TRUE.equals(billingCDR.getCallConnected())) {
                    dataToSave.setExternalReceivedAnswered(Integer.valueOf(dataToSave.getExternalReceivedAnswered() + 1));
                } else {
                    dataToSave.setExternalReceivedAbandoned(Integer.valueOf(dataToSave.getExternalReceivedAbandoned() + 1));
                }
            } else {
                dataToSave.setExternalDialed(Integer.valueOf(dataToSave.getExternalDialed() + 1));
            }
            this.billingCDRSummaryRepository.save((Object)dataToSave);
        }
        catch (Exception e) {
            logger.error("Error While Setting Data in Billing Cdr Summary Report {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private UcUserDataModel checkUcUser(String ucUser) {
        UcUserDataModel returnValue = new UcUserDataModel();
        returnValue.setIsUcUser(Boolean.valueOf(false));
        returnValue.setUcUserId("");
        returnValue.setUcUserName("");
        Optional isExtensionPresent = this.extensionsRepository.findByExtension(ucUser);
        if (isExtensionPresent.isPresent() && StringUtils.hasText((String)((Extension)isExtensionPresent.get()).getAssignedUser())) {
            UserDetailsDataModel ucUserDetails = this.checkUserDetails(((Extension)isExtensionPresent.get()).getAssignedUser(), "ROLE_USERS");
            if (StringUtils.hasText((String)((Extension)isExtensionPresent.get()).getExtensionType()) && ((Extension)isExtensionPresent.get()).getExtensionType().equalsIgnoreCase("softfax")) {
                returnValue.setIsUcUser(Boolean.valueOf(false));
            } else {
                returnValue.setIsUcUser(ucUserDetails.getIsUserPresentForRole());
            }
            returnValue.setUcUserId(ucUserDetails.getUserName());
            returnValue.setUcUserName(ucUserDetails.getUserFullName());
        } else {
            logger.info("Extension details not present for User Id:{} ", (Object)ucUser);
        }
        return returnValue;
    }

    private UserDetailsDataModel checkUserDetails(String userName, String checkRole) {
        UserDetailsDataModel returnValue = new UserDetailsDataModel();
        returnValue.setIsUserPresentForRole(Boolean.valueOf(false));
        returnValue.setUserName("");
        returnValue.setUserFullName("");
        Optional isUserPresent = this.userRepository.findByUsername(userName);
        if (isUserPresent.isPresent()) {
            User user = (User)isUserPresent.get();
            returnValue.setUserFullName(user.getDescription());
            returnValue.setUserName(user.getUsername());
            List userRoles = this.userRoleRepository.findByUser(user);
            for (UserRole userRole : userRoles) {
                Role role = userRole.getRole();
                if (role == null || !role.getShortCode().equalsIgnoreCase(checkRole)) continue;
                returnValue.setIsUserPresentForRole(Boolean.valueOf(true));
                break;
            }
        }
        return returnValue;
    }

    private boolean isDestinationIsFaxUser(String extension) {
        Optional isExtensionPresent = this.extensionsRepository.findByExtension(extension);
        return isExtensionPresent.isPresent() && StringUtils.hasText((String)((Extension)isExtensionPresent.get()).getExtensionType()) && ((Extension)isExtensionPresent.get()).getExtensionType().equalsIgnoreCase("softfax");
    }

    private void updateUcUser(CallDataRecord cdrData, String ucUser, String callDirection, UcUserDataModel ucData) {
        try {
            logger.info("Creating Uc User data for : {}", (Object)ucData.getUcUserId());
            UcUserDetails newUcUserDetails = new UcUserDetails();
            newUcUserDetails.setCallDirection(callDirection);
            newUcUserDetails.setCallReceivedOn(cdrData.getStartTime());
            newUcUserDetails.setUcNumber(ucUser);
            newUcUserDetails.setUcUserName(ucData.getUcUserName());
            newUcUserDetails.setUuid(cdrData.getUuid().toString());
            newUcUserDetails.setUcUserId(ucData.getUcUserId());
            if (cdrData.getBillsec() == 0L) {
                newUcUserDetails.setCallDuration(Long.valueOf(0L));
                newUcUserDetails.setIsMissed(Boolean.valueOf(true));
            } else {
                newUcUserDetails.setCallDuration(cdrData.getBillsec());
                newUcUserDetails.setIsMissed(Boolean.valueOf(false));
            }
            if (cdrData.getBillsec() == 0L && callDirection.equalsIgnoreCase("OUT")) {
                newUcUserDetails.setIsMissed(Boolean.valueOf(false));
            }
            newUcUserDetails.setUcDialedTo("OUT".equalsIgnoreCase(callDirection) ? cdrData.getDestinationNumber() : cdrData.getCallerIDNumber());
            if (callDirection.equalsIgnoreCase("IN") && Boolean.TRUE.equals(newUcUserDetails.getIsMissed())) {
                Optional ucNotificationData = this.ucNotificationRepository.findByUcUser(newUcUserDetails.getUcUserId());
                if (ucNotificationData.isPresent()) {
                    ((UcNotification)ucNotificationData.get()).setMissedCall(Integer.valueOf(((UcNotification)ucNotificationData.get()).getMissedCall() + 1));
                    this.ucNotificationRepository.save(ucNotificationData.get());
                } else {
                    this.ucNotificationRepository.save((Object)new UcNotification(null, newUcUserDetails.getUcUserId(), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0)));
                }
            }
            this.ucUserDetailsRepository.save((Object)newUcUserDetails);
        }
        catch (Exception e) {
            logger.error("Error while creating UC user data for '{}': {}", (Object)ucUser, (Object)e.getMessage(), (Object)e);
        }
    }

    private void initializeBillingCDRSummary(BillingCDRSummary dataToSave) {
        dataToSave.setExternalDialed(Integer.valueOf(0));
        dataToSave.setExternalReceived(Integer.valueOf(0));
        dataToSave.setExternalReceivedAbandoned(Integer.valueOf(0));
        dataToSave.setExternalReceivedAnswered(Integer.valueOf(0));
        dataToSave.setInternalDialed(Integer.valueOf(0));
        dataToSave.setInternalReceived(Integer.valueOf(0));
        dataToSave.setInternalReceivedAbandoned(Integer.valueOf(0));
        dataToSave.setInternalReceivedAnswered(Integer.valueOf(0));
        dataToSave.setDepartmentCode("");
        dataToSave.setDepartmentName("");
    }

    private void updateLastAbandonedCdr(AgentCDR agentCdr, Long midnightEpoch) {
        LastAbandonedCdrCompositeKey lastAbondendKey = new LastAbandonedCdrCompositeKey();
        lastAbondendKey.setRecordEpoch(midnightEpoch);
        try {
            if (agentCdr.getCallDirection().equalsIgnoreCase("IN")) {
                lastAbondendKey.setCallerIdNumber(agentCdr.getCallId());
            } else {
                lastAbondendKey.setCallerIdNumber(agentCdr.getCustomerNumber());
            }
            Optional existingRecord = this.lastAbandonedCdrRepository.findById((Object)lastAbondendKey);
            if (existingRecord.isPresent()) {
                LastAbandonedCdr cdr = (LastAbandonedCdr)existingRecord.get();
                if (agentCdr.getAnswerTime() != null && agentCdr.getAnswerTime() > 0L) {
                    this.lastAbandonedCdrRepository.delete((Object)cdr);
                } else {
                    cdr.setTotalCalls(Integer.valueOf(cdr.getTotalCalls() + 1));
                    cdr.setCallStartTime(agentCdr.getStartTime());
                    this.lastAbandonedCdrRepository.save((Object)cdr);
                }
            } else if (agentCdr.getAnswerTime() == null || agentCdr.getAnswerTime() == 0L) {
                LastAbandonedCdr newCdr = new LastAbandonedCdr(lastAbondendKey, agentCdr.getStartTime(), Integer.valueOf(1));
                this.lastAbandonedCdrRepository.save((Object)newCdr);
            }
        }
        catch (Exception e) {
            logger.error("Error while updating LastAbandonedCdr table {} {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

