/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.component.service.SystemAlertGenerate;
import com.coraltele.telemetry.helper.SystemHealthHelper;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.ChartDataModel;
import com.coraltele.telemetry.thread.MetricsCollectionThread;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemHealthMonitorThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(MetricsCollectionThread.class);
    public volatile boolean isRunning = true;
    private Thread thread;
    private SystemHealthHelper systemHealthHelper;
    private SystemAlertGenerate systemAlertGenerate;

    public SystemHealthMonitorThread() {
        logger.info("System Health Monitor Thread");
        this.thread = new Thread((Runnable)this);
        this.thread.start();
    }

    public SystemHealthMonitorThread(SystemHealthHelper systemHealthHelper, SystemAlertGenerate systemAlertGenerate) {
        this.systemHealthHelper = systemHealthHelper;
        this.systemAlertGenerate = systemAlertGenerate;
    }

    @Override
    public void run() {
        this.HelperParameterInput();
        throw new UnsupportedOperationException("Unimplemented method 'run'");
    }

    public void HelperParameterInput() {
        List swaprMemory = this.systemHealthHelper.getSwapMemory(this.systemHealthHelper.ipValue);
        List cpuLoad = this.systemHealthHelper.getCpuLoad(this.systemHealthHelper.ipValue);
        List diskSpace = this.systemHealthHelper.getHardDiskData(this.systemHealthHelper.ipValue);
        ChartDataModel listProcess = this.systemHealthHelper.getListProcess(this.systemHealthHelper.ipValue);
        List ramInfo = this.systemHealthHelper.getRamInfoSingleSeries(this.systemHealthHelper.ipValue);
        this.systemAlertGenerate.SnmpProcess(swaprMemory, cpuLoad, diskSpace, listProcess, ramInfo);
    }
}

