/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.user.service;

import com.coraltele.telemetry.db.users.main.entity.Role;
import com.coraltele.telemetry.db.users.main.repository.RoleRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.ReturnField;
import com.coraltele.telemetry.service.user.model.RoleModel;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleService {
    private static final Logger logger = LogManager.getLogger(RoleService.class);
    @Autowired
    private RoleRepository roleRepository;

    public RequestResponse createRole(RoleModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Role role = new Role();
            role.setDescription(data.getDescription());
            role.setEnabled(data.getEnabled());
            this.roleRepository.save((Object)role);
            ReturnField field = new ReturnField();
            field.setId(role.getId());
            field.setDescription(role.getDescription());
            returnValue.setStatus(0);
            returnValue.setMessage(" Registered");
            returnValue.setMessageDetail("Role registered successfully ");
            returnValue.setData((Object)field);
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to create role");
            returnValue.setMessageDetail("Contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getById(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional role = this.roleRepository.findById(id);
            if (role.isPresent()) {
                RoleModel data = new RoleModel();
                data.setId(((Role)role.get()).getId());
                data.setDescription(((Role)role.get()).getDescription());
                data.setEnabled(((Role)role.get()).getEnabled());
                returnValue.setStatus(0);
                returnValue.setMessage("role Found");
                returnValue.setData((Object)data);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("contact with administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateRole(int id, RoleModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional role = this.roleRepository.findById(id);
            if (role.isPresent()) {
                ((Role)role.get()).setDescription(data.getDescription());
                ((Role)role.get()).setEnabled(data.getEnabled());
                this.roleRepository.save(role.get());
                returnValue.setStatus(0);
                returnValue.setMessage("Updated");
                returnValue.setMessageDetail("Role Updated successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Role not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to update user");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteRole(int id) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional role = this.roleRepository.findById(id);
            if (role.isPresent()) {
                this.roleRepository.deleteById((Object)id);
                returnValue.setStatus(0);
                returnValue.setMessage("deleted");
                returnValue.setMessageDetail("Record deleted successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to delete role");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }
}

